/*
 * Decompiled with CFR 0.152.
 */
package org.sparkproject.connect.grpc.internal;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.sparkproject.guava.base.Preconditions;
import org.sparkproject.guava.base.Throwables;

public final class LogExceptionRunnable
implements Runnable {
    private static final Logger log = Logger.getLogger(LogExceptionRunnable.class.getName());
    private final Runnable task;

    public LogExceptionRunnable(Runnable task) {
        this.task = (Runnable)Preconditions.checkNotNull((Object)task, (Object)"task");
    }

    @Override
    public void run() {
        try {
            this.task.run();
        }
        catch (Throwable t) {
            log.log(Level.SEVERE, "Exception while executing runnable " + this.task, t);
            Throwables.throwIfUnchecked((Throwable)t);
            throw new AssertionError((Object)t);
        }
    }

    public String toString() {
        return "LogExceptionRunnable(" + this.task + ")";
    }
}

