/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.orc;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.io.sarg.SearchArgument;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobID;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.TaskID;
import org.apache.hadoop.mapreduce.TaskType;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;
import org.apache.hadoop.mapreduce.task.TaskAttemptContextImpl;
import org.apache.orc.OrcConf;
import org.apache.orc.OrcFile;
import org.apache.orc.TypeDescription;
import org.apache.orc.mapred.OrcOutputFormat;
import org.apache.orc.mapred.OrcStruct;
import org.apache.orc.mapreduce.OrcInputFormat;
import org.apache.spark.SparkConf;
import org.apache.spark.TaskContext$;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.memory.MemoryMode;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.AttributeReference;
import org.apache.spark.sql.catalyst.expressions.JoinedRow;
import org.apache.spark.sql.catalyst.expressions.UnsafeProjection;
import org.apache.spark.sql.catalyst.expressions.codegen.GenerateUnsafeProjection$;
import org.apache.spark.sql.catalyst.types.DataTypeUtils$;
import org.apache.spark.sql.execution.datasources.FileFormat;
import org.apache.spark.sql.execution.datasources.FileFormat$;
import org.apache.spark.sql.execution.datasources.OutputWriter;
import org.apache.spark.sql.execution.datasources.OutputWriterFactory;
import org.apache.spark.sql.execution.datasources.PartitionedFile;
import org.apache.spark.sql.execution.datasources.RecordReaderIterator;
import org.apache.spark.sql.execution.datasources.orc.OrcColumnarBatchReader;
import org.apache.spark.sql.execution.datasources.orc.OrcDeserializer;
import org.apache.spark.sql.execution.datasources.orc.OrcFilters$;
import org.apache.spark.sql.execution.datasources.orc.OrcOptions;
import org.apache.spark.sql.execution.datasources.orc.OrcOutputWriter;
import org.apache.spark.sql.execution.datasources.orc.OrcUtils$;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.internal.SessionState;
import org.apache.spark.sql.internal.SessionStateHelper;
import org.apache.spark.sql.sources.DataSourceRegister;
import org.apache.spark.sql.sources.Filter;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.AtomicType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimeType;
import org.apache.spark.sql.types.UserDefinedType;
import org.apache.spark.sql.types.VariantType;
import org.apache.spark.sql.vectorized.ColumnarBatch;
import org.apache.spark.util.SerializableConfiguration;
import org.apache.spark.util.SerializableConfiguration$;
import org.apache.spark.util.Utils$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.Iterator;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\u0005\rf\u0001\u0002\u0007\u000e\u0001qAQa\u000f\u0001\u0005\u0002qBQa\u0010\u0001\u0005B\u0001CQ\u0001\u0014\u0001\u0005B\u0001CQ!\u0014\u0001\u0005B9CQA\u0015\u0001\u0005BMCQ\u0001\u0018\u0001\u0005BuCq!a\u0003\u0001\t\u0003\ni\u0001C\u0004\u0002.\u0001!\t%a\f\t\u000f\u0005]\u0002\u0001\"\u0011\u0002:!9\u0011\u0011\n\u0001\u0005B\u0005-\u0003bBAK\u0001\u0011\u0005\u0013q\u0013\u0002\u000e\u001fJ\u001cg)\u001b7f\r>\u0014X.\u0019;\u000b\u00059y\u0011aA8sG*\u0011\u0001#E\u0001\fI\u0006$\u0018m]8ve\u000e,7O\u0003\u0002\u0013'\u0005IQ\r_3dkRLwN\u001c\u0006\u0003)U\t1a]9m\u0015\t1r#A\u0003ta\u0006\u00148N\u0003\u0002\u00193\u00051\u0011\r]1dQ\u0016T\u0011AG\u0001\u0004_J<7\u0001A\n\u0007\u0001u\u0019s%L\u001a\u0011\u0005y\tS\"A\u0010\u000b\u0003\u0001\nQa]2bY\u0006L!AI\u0010\u0003\r\u0005s\u0017PU3g!\t!S%D\u0001\u0010\u0013\t1sB\u0001\u0006GS2,gi\u001c:nCR\u0004\"\u0001K\u0016\u000e\u0003%R!AK\n\u0002\u000fM|WO]2fg&\u0011A&\u000b\u0002\u0013\t\u0006$\u0018mU8ve\u000e,'+Z4jgR,'\u000f\u0005\u0002/c5\tqF\u0003\u00021'\u0005A\u0011N\u001c;fe:\fG.\u0003\u00023_\t\u00112+Z:tS>t7\u000b^1uK\"+G\u000e]3s!\t!\u0014(D\u00016\u0015\t1t'\u0001\u0002j_*\t\u0001(\u0001\u0003kCZ\f\u0017B\u0001\u001e6\u00051\u0019VM]5bY&T\u0018M\u00197f\u0003\u0019a\u0014N\\5u}Q\tQ\b\u0005\u0002?\u00015\tQ\"A\u0005tQ>\u0014HOT1nKR\t\u0011\t\u0005\u0002C\u0013:\u00111i\u0012\t\u0003\t~i\u0011!\u0012\u0006\u0003\rn\ta\u0001\u0010:p_Rt\u0014B\u0001% \u0003\u0019\u0001&/\u001a3fM&\u0011!j\u0013\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005!{\u0012\u0001\u0003;p'R\u0014\u0018N\\4\u0002\u0011!\f7\u000f[\"pI\u0016$\u0012a\u0014\t\u0003=AK!!U\u0010\u0003\u0007%sG/\u0001\u0004fcV\fGn\u001d\u000b\u0003)^\u0003\"AH+\n\u0005Y{\"a\u0002\"p_2,\u0017M\u001c\u0005\u00061\u0016\u0001\r!W\u0001\u0006_RDWM\u001d\t\u0003=iK!aW\u0010\u0003\u0007\u0005s\u00170A\u0006j]\u001a,'oU2iK6\fG\u0003\u00020h[J\u00042AH0b\u0013\t\u0001wD\u0001\u0004PaRLwN\u001c\t\u0003E\u0016l\u0011a\u0019\u0006\u0003IN\tQ\u0001^=qKNL!AZ2\u0003\u0015M#(/^2u)f\u0004X\rC\u0003i\r\u0001\u0007\u0011.\u0001\u0007ta\u0006\u00148nU3tg&|g\u000e\u0005\u0002kW6\t1#\u0003\u0002m'\ta1\u000b]1sWN+7o]5p]\")aN\u0002a\u0001_\u00069q\u000e\u001d;j_:\u001c\b\u0003\u0002\"q\u0003\u0006K!!]&\u0003\u00075\u000b\u0007\u000fC\u0003t\r\u0001\u0007A/A\u0003gS2,7\u000fE\u0002vuvt!A\u001e=\u000f\u0005\u0011;\u0018\"\u0001\u0011\n\u0005e|\u0012a\u00029bG.\fw-Z\u0005\u0003wr\u00141aU3r\u0015\tIx\u0004E\u0002\u007f\u0003\u000fi\u0011a \u0006\u0005\u0003\u0003\t\u0019!\u0001\u0002gg*\u0019\u0011QA\f\u0002\r!\fGm\\8q\u0013\r\tIa \u0002\u000b\r&dWm\u0015;biV\u001c\u0018\u0001\u00049sKB\f'/Z,sSR,GCCA\b\u0003+\t9\"a\n\u0002*A\u0019A%!\u0005\n\u0007\u0005MqBA\nPkR\u0004X\u000f^,sSR,'OR1di>\u0014\u0018\u0010C\u0003i\u000f\u0001\u0007\u0011\u000eC\u0004\u0002\u001a\u001d\u0001\r!a\u0007\u0002\u0007)|'\r\u0005\u0003\u0002\u001e\u0005\rRBAA\u0010\u0015\u0011\t\t#a\u0001\u0002\u00135\f\u0007O]3ek\u000e,\u0017\u0002BA\u0013\u0003?\u00111AS8c\u0011\u0015qw\u00011\u0001p\u0011\u0019\tYc\u0002a\u0001C\u0006QA-\u0019;b'\u000eDW-\\1\u0002\u0019M,\b\u000f]8si\n\u000bGo\u00195\u0015\u000bQ\u000b\t$a\r\t\u000b!D\u0001\u0019A5\t\r\u0005U\u0002\u00021\u0001b\u0003\u0019\u00198\r[3nC\u0006Y\u0011n]*qY&$\u0018M\u00197f)\u001d!\u00161HA\u001f\u0003\u007fAQ\u0001[\u0005A\u0002%DQA\\\u0005A\u0002=Dq!!\u0011\n\u0001\u0004\t\u0019%\u0001\u0003qCRD\u0007c\u0001@\u0002F%\u0019\u0011qI@\u0003\tA\u000bG\u000f[\u0001\u001fEVLG\u000e\u001a*fC\u0012,'oV5uQB\u000b'\u000f^5uS>tg+\u00197vKN$\u0002#!\u0014\u0002l\u00055\u0014qNA:\u0003o\n\u0019)!\"\u0011\u000fy\ty%a\u0015\u0002Z%\u0019\u0011\u0011K\u0010\u0003\u0013\u0019+hn\u0019;j_:\f\u0004c\u0001\u0013\u0002V%\u0019\u0011qK\b\u0003\u001fA\u000b'\u000f^5uS>tW\r\u001a$jY\u0016\u0004R!^A.\u0003?J1!!\u0018}\u0005!IE/\u001a:bi>\u0014\b\u0003BA1\u0003Oj!!a\u0019\u000b\u0007\u0005\u00154#\u0001\u0005dCR\fG._:u\u0013\u0011\tI'a\u0019\u0003\u0017%sG/\u001a:oC2\u0014vn\u001e\u0005\u0006Q*\u0001\r!\u001b\u0005\u0007\u0003WQ\u0001\u0019A1\t\r\u0005E$\u00021\u0001b\u0003=\u0001\u0018M\u001d;ji&|gnU2iK6\f\u0007BBA;\u0015\u0001\u0007\u0011-\u0001\bsKF,\u0018N]3e'\u000eDW-\\1\t\u000f\u0005e$\u00021\u0001\u0002|\u00059a-\u001b7uKJ\u001c\b\u0003B;{\u0003{\u00022\u0001KA@\u0013\r\t\t)\u000b\u0002\u0007\r&dG/\u001a:\t\u000b9T\u0001\u0019A8\t\u000f\u0005\u001d%\u00021\u0001\u0002\n\u0006Q\u0001.\u00193p_B\u001cuN\u001c4\u0011\t\u0005-\u0015\u0011S\u0007\u0003\u0003\u001bSA!a$\u0002\u0004\u0005!1m\u001c8g\u0013\u0011\t\u0019*!$\u0003\u001b\r{gNZ5hkJ\fG/[8o\u0003=\u0019X\u000f\u001d9peR$\u0015\r^1UsB,Gc\u0001+\u0002\u001a\"9\u00111T\u0006A\u0002\u0005u\u0015\u0001\u00033bi\u0006$\u0016\u0010]3\u0011\u0007\t\fy*C\u0002\u0002\"\u000e\u0014\u0001\u0002R1uCRK\b/\u001a")
public class OrcFileFormat
implements FileFormat,
DataSourceRegister,
SessionStateHelper,
Serializable {
    @Override
    public SessionState sessionState(SparkSession sparkSession) {
        return SessionStateHelper.sessionState$(this, sparkSession);
    }

    @Override
    public SparkConf getSparkConf(SparkSession sparkSession) {
        return SessionStateHelper.getSparkConf$(this, sparkSession);
    }

    @Override
    public SQLConf getSqlConf(SparkSession sparkSession) {
        return SessionStateHelper.getSqlConf$(this, sparkSession);
    }

    @Override
    public Configuration getHadoopConf(SparkSession sparkSession, Map<String, String> options) {
        return SessionStateHelper.getHadoopConf$(this, sparkSession, options);
    }

    @Override
    public Configuration getHadoopConf(SparkSession sparkSession) {
        return SessionStateHelper.getHadoopConf$(this, sparkSession);
    }

    @Override
    public Option<Seq<String>> vectorTypes(StructType requiredSchema, StructType partitionSchema, SQLConf sqlConf) {
        return FileFormat.vectorTypes$(this, requiredSchema, partitionSchema, sqlConf);
    }

    @Override
    public Function1<PartitionedFile, Iterator<InternalRow>> buildReader(SparkSession sparkSession, StructType dataSchema, StructType partitionSchema, StructType requiredSchema, Seq<Filter> filters, Map<String, String> options, Configuration hadoopConf) {
        return FileFormat.buildReader$(this, sparkSession, dataSchema, partitionSchema, requiredSchema, filters, options, hadoopConf);
    }

    @Override
    public AttributeReference createFileMetadataCol() {
        return FileFormat.createFileMetadataCol$(this);
    }

    @Override
    public boolean supportReadDataType(DataType dataType) {
        return FileFormat.supportReadDataType$(this, dataType);
    }

    @Override
    public boolean supportFieldName(String name) {
        return FileFormat.supportFieldName$(this, name);
    }

    @Override
    public boolean allowDuplicatedColumnNames() {
        return FileFormat.allowDuplicatedColumnNames$(this);
    }

    @Override
    public Seq<StructField> metadataSchemaFields() {
        return FileFormat.metadataSchemaFields$(this);
    }

    @Override
    public Map<String, Function1<PartitionedFile, Object>> fileConstantMetadataExtractors() {
        return FileFormat.fileConstantMetadataExtractors$(this);
    }

    @Override
    public String shortName() {
        return "orc";
    }

    public String toString() {
        return "ORC";
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }

    public boolean equals(Object other) {
        return other instanceof OrcFileFormat;
    }

    @Override
    public Option<StructType> inferSchema(SparkSession sparkSession, Map<String, String> options, Seq<FileStatus> files) {
        return OrcUtils$.MODULE$.inferSchema(sparkSession, files, options);
    }

    @Override
    public OutputWriterFactory prepareWrite(SparkSession sparkSession, Job job, Map<String, String> options, StructType dataSchema) {
        SQLConf sqlConf = this.getSqlConf(sparkSession);
        OrcOptions orcOptions = new OrcOptions(options, sqlConf);
        Configuration conf = job.getConfiguration();
        conf.set(OrcConf.COMPRESS.getAttribute(), orcOptions.compressionCodec());
        ((JobConf)conf).setOutputFormat(OrcOutputFormat.class);
        int batchSize = sqlConf.orcVectorizedWriterBatchSize();
        return new OutputWriterFactory(null, batchSize){
            private final int batchSize$1;

            public OutputWriter newInstance(String path, StructType dataSchema, TaskAttemptContext context) {
                return new OrcOutputWriter(path, dataSchema, context, this.batchSize$1);
            }

            public String getFileExtension(TaskAttemptContext context) {
                String name = context.getConfiguration().get(OrcConf.COMPRESS.getAttribute());
                String compressionExtension = (String)OrcUtils$.MODULE$.extensionsForCompressionCodecNames().getOrElse((Object)name, (Function0 & Serializable)() -> "");
                return compressionExtension + ".orc";
            }
            {
                this.batchSize$1 = batchSize$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$getFileExtension$1()}, serializedLambda);
            }
        };
    }

    @Override
    public boolean supportBatch(SparkSession sparkSession, StructType schema) {
        SQLConf sqlConf = this.getSqlConf(sparkSession);
        return sqlConf.orcVectorizedReaderEnabled() && schema.forall((Function1 & Serializable)s -> BoxesRunTime.boxToBoolean((boolean)OrcUtils$.MODULE$.supportColumnarReads(s.dataType(), sqlConf.orcVectorizedReaderNestedColumnEnabled())));
    }

    @Override
    public boolean isSplitable(SparkSession sparkSession, Map<String, String> options, Path path) {
        return true;
    }

    @Override
    public Function1<PartitionedFile, Iterator<InternalRow>> buildReaderWithPartitionValues(SparkSession sparkSession, StructType dataSchema, StructType partitionSchema, StructType requiredSchema, Seq<Filter> filters, Map<String, String> options, Configuration hadoopConf) {
        boolean enableVectorizedReader;
        StructType resultSchema = new StructType((StructField[])ArrayOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.refArrayOps((Object[])requiredSchema.fields()), (Object)partitionSchema.fields(), ClassTag$.MODULE$.apply(StructField.class)));
        SQLConf sqlConf = this.getSqlConf(sparkSession);
        int capacity = sqlConf.orcVectorizedReaderBatchSize();
        boolean bl = enableVectorizedReader = sqlConf.orcVectorizedReaderEnabled() && ((String)options.getOrElse((Object)FileFormat$.MODULE$.OPTION_RETURNING_BATCH(), (Function0 & Serializable)() -> {
            throw new IllegalArgumentException("OPTION_RETURNING_BATCH should always be set for OrcFileFormat. To workaround this issue, set spark.sql.orc.enableVectorizedReader=false.");
        })).equals("true");
        if (enableVectorizedReader) {
            Predef$.MODULE$.assert(this.supportBatch(sparkSession, resultSchema));
        }
        MemoryMode memoryMode = sqlConf.offHeapColumnVectorEnabled() ? MemoryMode.OFF_HEAP : MemoryMode.ON_HEAP;
        OrcConf.IS_SCHEMA_EVOLUTION_CASE_SENSITIVE.setBoolean(hadoopConf, sqlConf.caseSensitiveAnalysis());
        Broadcast broadcastedConf = SerializableConfiguration$.MODULE$.broadcast(sparkSession.sparkContext(), hadoopConf);
        boolean isCaseSensitive = sqlConf.caseSensitiveAnalysis();
        boolean orcFilterPushDown = sqlConf.orcFilterPushDown();
        return (Function1 & Serializable)file -> {
            Tuple2 tuple2;
            Configuration conf = ((SerializableConfiguration)broadcastedConf.value()).value();
            Path filePath = file.toPath();
            FileSystem fs = filePath.getFileSystem(conf);
            OrcFile.ReaderOptions readerOptions = OrcFile.readerOptions((Configuration)conf).filesystem(fs);
            TypeDescription orcSchema = (TypeDescription)Utils$.MODULE$.tryWithResource((Function0 & Serializable)() -> OrcFile.createReader((Path)filePath, (OrcFile.ReaderOptions)readerOptions), (Function1 & Serializable)x$1 -> x$1.getSchema());
            Option<Tuple2<int[], Object>> resultedColPruneInfo = OrcUtils$.MODULE$.requestedColumnIds(isCaseSensitive, dataSchema, requiredSchema, orcSchema, conf);
            if (resultedColPruneInfo.isEmpty()) {
                return package$.MODULE$.Iterator().empty();
            }
            if (orcFilterPushDown && filters.nonEmpty()) {
                StructType fileSchema = OrcUtils$.MODULE$.toCatalystSchema(orcSchema);
                OrcFilters$.MODULE$.createFilter(fileSchema, filters).foreach((Function1 & Serializable)f -> {
                    OrcFileFormat.$anonfun$buildReaderWithPartitionValues$5(conf, fileSchema, f);
                    return BoxedUnit.UNIT;
                });
            }
            if ((tuple2 = (Tuple2)resultedColPruneInfo.get()) == null) {
                throw new MatchError((Object)tuple2);
            }
            int[] requestedColIds = (int[])tuple2._1();
            boolean canPruneCols = tuple2._2$mcZ$sp();
            Tuple2 tuple22 = new Tuple2((Object)requestedColIds, (Object)BoxesRunTime.boxToBoolean((boolean)canPruneCols));
            int[] requestedColIds2 = (int[])tuple22._1();
            boolean canPruneCols2 = tuple22._2$mcZ$sp();
            String resultSchemaString = OrcUtils$.MODULE$.orcResultSchemaString(canPruneCols2, dataSchema, resultSchema, partitionSchema, conf);
            Predef$.MODULE$.assert(requestedColIds2.length == requiredSchema.length(), (Function0 & Serializable)() -> "[BUG] requested column IDs do not match required schema");
            Configuration taskConf = new Configuration(conf);
            String includeColumns = Predef$.MODULE$.wrapIntArray((int[])ArrayOps$.MODULE$.sorted$extension(Predef$.MODULE$.intArrayOps((int[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.intArrayOps(requestedColIds2), (Function1)(JFunction1.mcZI.sp & Serializable)x$3 -> x$3 != -1)), (Ordering)Ordering.Int$.MODULE$)).mkString(",");
            taskConf.set(OrcConf.INCLUDE_COLUMNS.getAttribute(), includeColumns);
            FileSplit fileSplit = new FileSplit(filePath, file.start(), file.length(), (String[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(String.class)));
            TaskAttemptID attemptId = new TaskAttemptID(new TaskID(new JobID(), TaskType.MAP, 0), 0);
            TaskAttemptContextImpl taskAttemptContext = new TaskAttemptContextImpl(taskConf, attemptId);
            if (enableVectorizedReader) {
                OrcColumnarBatchReader batchReader = new OrcColumnarBatchReader(capacity, memoryMode);
                RecordReaderIterator<ColumnarBatch> iter = new RecordReaderIterator<ColumnarBatch>(batchReader);
                Option$.MODULE$.apply((Object)TaskContext$.MODULE$.get()).foreach((Function1 & Serializable)x$4 -> x$4.addTaskCompletionListener((Function1 & Serializable)x$5 -> {
                    iter.close();
                    return BoxedUnit.UNIT;
                }));
                int[] requestedDataColIds = (int[])ArrayOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.intArrayOps(requestedColIds2), Array$.MODULE$.fill(partitionSchema.length(), (Function0)(JFunction0.mcI.sp & Serializable)() -> -1, (ClassTag)ClassTag$.MODULE$.Int()), (ClassTag)ClassTag$.MODULE$.Int());
                int[] requestedPartitionColIds = (int[])ArrayOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.intArrayOps((int[])Array$.MODULE$.fill(requiredSchema.length(), (Function0)(JFunction0.mcI.sp & Serializable)() -> -1, (ClassTag)ClassTag$.MODULE$.Int())), (IterableOnce)package$.MODULE$.Range().apply(0, partitionSchema.length()), (ClassTag)ClassTag$.MODULE$.Int());
                batchReader.initialize((InputSplit)fileSplit, (TaskAttemptContext)taskAttemptContext, readerOptions.getOrcTail());
                batchReader.initBatch(TypeDescription.fromString((String)resultSchemaString), resultSchema.fields(), requestedDataColIds, requestedPartitionColIds, file.partitionValues());
                return iter;
            }
            RecordReader orcRecordReader = new OrcInputFormat().createRecordReader((InputSplit)fileSplit, (TaskAttemptContext)taskAttemptContext);
            RecordReaderIterator iter = new RecordReaderIterator(orcRecordReader);
            Option$.MODULE$.apply((Object)TaskContext$.MODULE$.get()).foreach((Function1 & Serializable)x$6 -> x$6.addTaskCompletionListener((Function1 & Serializable)x$7 -> {
                iter.close();
                return BoxedUnit.UNIT;
            }));
            Seq fullSchema = (Seq)DataTypeUtils$.MODULE$.toAttributes(requiredSchema).$plus$plus((IterableOnce)DataTypeUtils$.MODULE$.toAttributes(partitionSchema));
            UnsafeProjection unsafeProjection = (UnsafeProjection)GenerateUnsafeProjection$.MODULE$.generate((Object)fullSchema, fullSchema);
            OrcDeserializer deserializer = new OrcDeserializer(requiredSchema, requestedColIds2);
            if (partitionSchema.length() == 0) {
                return iter.map((Function1 & Serializable)value -> unsafeProjection.apply(deserializer.deserialize((OrcStruct)value)));
            }
            JoinedRow joinedRow = new JoinedRow();
            return iter.map((Function1 & Serializable)value -> unsafeProjection.apply((InternalRow)joinedRow.apply(deserializer.deserialize((OrcStruct)value), file.partitionValues())));
        };
    }

    @Override
    public boolean supportDataType(DataType dataType) {
        DataType dataType2 = dataType;
        if (dataType2 instanceof VariantType) {
            return false;
        }
        if (dataType2 instanceof TimeType) {
            return false;
        }
        if (dataType2 instanceof AtomicType) {
            return true;
        }
        if (dataType2 instanceof StructType) {
            StructType structType = (StructType)dataType2;
            return structType.forall((Function1 & Serializable)f -> BoxesRunTime.boxToBoolean((boolean)this.supportDataType(f.dataType())));
        }
        if (dataType2 instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)dataType2;
            DataType elementType = arrayType.elementType();
            return this.supportDataType(elementType);
        }
        if (dataType2 instanceof MapType) {
            MapType mapType = (MapType)dataType2;
            DataType keyType = mapType.keyType();
            DataType valueType = mapType.valueType();
            return this.supportDataType(keyType) && this.supportDataType(valueType);
        }
        if (dataType2 instanceof UserDefinedType) {
            UserDefinedType userDefinedType = (UserDefinedType)dataType2;
            return this.supportDataType(userDefinedType.sqlType());
        }
        return false;
    }

    public static final /* synthetic */ void $anonfun$buildReaderWithPartitionValues$5(Configuration conf$1, StructType fileSchema$1, SearchArgument f) {
        OrcInputFormat.setSearchArgument((Configuration)conf$1, (SearchArgument)f, (String[])fileSchema$1.fieldNames());
    }

    public OrcFileFormat() {
        FileFormat.$init$(this);
        SessionStateHelper.$init$(this);
    }
}

