/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.streaming.checkpointing;

import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.execution.streaming.checkpointing.CommitLog$;
import org.apache.spark.sql.execution.streaming.checkpointing.CommitMetadata;
import org.apache.spark.sql.execution.streaming.checkpointing.CommitMetadata$;
import org.apache.spark.sql.execution.streaming.checkpointing.HDFSMetadataLog;
import org.apache.spark.sql.internal.SQLConf$;
import scala.Predef$;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.io.Source$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005-4A!\u0004\b\u0001;!AQ\u0005\u0001B\u0001B\u0003%a\u0005\u0003\u0005+\u0001\t\u0005\t\u0015!\u0003,\u0011\u0015A\u0004\u0001\"\u0001:\u0011\u001di\u0004A1A\u0005\nyBaa\u0011\u0001!\u0002\u0013y\u0004B\u0002#\u0001\t#\"R\t\u0003\u0004Q\u0001\u0011EC#U\u0004\u00069:A\t!\u0018\u0004\u0006\u001b9A\tA\u0018\u0005\u0006q%!\tA\u0019\u0005\bG&\u0011\r\u0011\"\u0003e\u0011\u0019Q\u0017\u0002)A\u0005K\nI1i\\7nSRdun\u001a\u0006\u0003\u001fA\tQb\u00195fG.\u0004x.\u001b8uS:<'BA\t\u0013\u0003%\u0019HO]3b[&twM\u0003\u0002\u0014)\u0005IQ\r_3dkRLwN\u001c\u0006\u0003+Y\t1a]9m\u0015\t9\u0002$A\u0003ta\u0006\u00148N\u0003\u0002\u001a5\u00051\u0011\r]1dQ\u0016T\u0011aG\u0001\u0004_J<7\u0001A\n\u0003\u0001y\u00012a\b\u0011#\u001b\u0005q\u0011BA\u0011\u000f\u0005=AEIR*NKR\fG-\u0019;b\u0019><\u0007CA\u0010$\u0013\t!cB\u0001\bD_6l\u0017\u000e^'fi\u0006$\u0017\r^1\u0002\u0019M\u0004\u0018M]6TKN\u001c\u0018n\u001c8\u0011\u0005\u001dBS\"\u0001\u000b\n\u0005%\"\"\u0001D*qCJ\\7+Z:tS>t\u0017\u0001\u00029bi\"\u0004\"\u0001L\u001b\u000f\u00055\u001a\u0004C\u0001\u00182\u001b\u0005y#B\u0001\u0019\u001d\u0003\u0019a$o\\8u})\t!'A\u0003tG\u0006d\u0017-\u0003\u00025c\u00051\u0001K]3eK\u001aL!AN\u001c\u0003\rM#(/\u001b8h\u0015\t!\u0014'\u0001\u0004=S:LGO\u0010\u000b\u0004umb\u0004CA\u0010\u0001\u0011\u0015)3\u00011\u0001'\u0011\u0015Q3\u00011\u0001,\u0003\u001d1VIU*J\u001f:+\u0012a\u0010\t\u0003\u0001\u0006k\u0011!M\u0005\u0003\u0005F\u00121!\u00138u\u0003!1VIU*J\u001f:\u0003\u0013a\u00033fg\u0016\u0014\u0018.\u00197ju\u0016$\"A\t$\t\u000b\u001d3\u0001\u0019\u0001%\u0002\u0005%t\u0007CA%O\u001b\u0005Q%BA&M\u0003\tIwNC\u0001N\u0003\u0011Q\u0017M^1\n\u0005=S%aC%oaV$8\u000b\u001e:fC6\f\u0011b]3sS\u0006d\u0017N_3\u0015\u0007I+v\u000b\u0005\u0002A'&\u0011A+\r\u0002\u0005+:LG\u000fC\u0003W\u000f\u0001\u0007!%\u0001\u0005nKR\fG-\u0019;b\u0011\u0015Av\u00011\u0001Z\u0003\ryW\u000f\u001e\t\u0003\u0013jK!a\u0017&\u0003\u0019=+H\u000f];u'R\u0014X-Y7\u0002\u0013\r{W.\\5u\u0019><\u0007CA\u0010\n'\tIq\f\u0005\u0002AA&\u0011\u0011-\r\u0002\u0007\u0003:L(+\u001a4\u0015\u0003u\u000b!\"R'Q)f{&jU(O+\u0005)\u0007C\u00014j\u001b\u00059'B\u00015M\u0003\u0011a\u0017M\\4\n\u0005Y:\u0017aC#N!RKvLS*P\u001d\u0002\u0002")
public class CommitLog
extends HDFSMetadataLog<CommitMetadata> {
    private final int VERSION;

    private int VERSION() {
        return this.VERSION;
    }

    @Override
    public CommitMetadata deserialize(InputStream in) {
        Iterator lines = Source$.MODULE$.fromInputStream(in, StandardCharsets.UTF_8.name()).getLines();
        if (!lines.hasNext()) {
            throw new IllegalStateException("Incomplete log file in the offset commit log");
        }
        this.validateVersionExactMatch(((String)lines.next()).trim(), this.VERSION());
        String metadataJson = lines.hasNext() ? (String)lines.next() : CommitLog$.MODULE$.org$apache$spark$sql$execution$streaming$checkpointing$CommitLog$$EMPTY_JSON();
        return CommitMetadata$.MODULE$.apply(metadataJson);
    }

    @Override
    public void serialize(CommitMetadata metadata, OutputStream out) {
        out.write(("v" + this.VERSION()).getBytes(StandardCharsets.UTF_8));
        out.write(10);
        out.write(metadata.json().getBytes(StandardCharsets.UTF_8));
    }

    public CommitLog(SparkSession sparkSession, String path) {
        super(sparkSession, path, ClassTag$.MODULE$.apply(CommitMetadata.class));
        this.VERSION = StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(sparkSession.conf().get(SQLConf$.MODULE$.STATE_STORE_CHECKPOINT_FORMAT_VERSION().key())));
    }
}

