/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.network.protocol;

import io.netty.buffer.ByteBuf;
import org.apache.spark.network.buffer.ManagedBuffer;
import org.apache.spark.network.protocol.Encodable;

public interface Message
extends Encodable {
    public Type type();

    public ManagedBuffer body();

    public boolean isBodyInFrame();

    public static final class Type
    extends Enum<Type>
    implements Encodable {
        public static final /* enum */ Type ChunkFetchRequest = new Type(0);
        public static final /* enum */ Type ChunkFetchSuccess = new Type(1);
        public static final /* enum */ Type ChunkFetchFailure = new Type(2);
        public static final /* enum */ Type RpcRequest = new Type(3);
        public static final /* enum */ Type RpcResponse = new Type(4);
        public static final /* enum */ Type RpcFailure = new Type(5);
        public static final /* enum */ Type StreamRequest = new Type(6);
        public static final /* enum */ Type StreamResponse = new Type(7);
        public static final /* enum */ Type StreamFailure = new Type(8);
        public static final /* enum */ Type OneWayMessage = new Type(9);
        public static final /* enum */ Type UploadStream = new Type(10);
        public static final /* enum */ Type MergedBlockMetaRequest = new Type(11);
        public static final /* enum */ Type MergedBlockMetaSuccess = new Type(12);
        public static final /* enum */ Type User = new Type(-1);
        private final byte id;
        private static final /* synthetic */ Type[] $VALUES;

        public static Type[] values() {
            return (Type[])$VALUES.clone();
        }

        public static Type valueOf(String name) {
            return Enum.valueOf(Type.class, name);
        }

        private Type(int id) {
            assert (id < 128) : "Cannot have more than 128 message types";
            this.id = (byte)id;
        }

        public byte id() {
            return this.id;
        }

        @Override
        public int encodedLength() {
            return 1;
        }

        @Override
        public void encode(ByteBuf buf) {
            buf.writeByte((int)this.id);
        }

        public static Type decode(ByteBuf buf) {
            byte id = buf.readByte();
            return switch (id) {
                case 0 -> ChunkFetchRequest;
                case 1 -> ChunkFetchSuccess;
                case 2 -> ChunkFetchFailure;
                case 3 -> RpcRequest;
                case 4 -> RpcResponse;
                case 5 -> RpcFailure;
                case 6 -> StreamRequest;
                case 7 -> StreamResponse;
                case 8 -> StreamFailure;
                case 9 -> OneWayMessage;
                case 10 -> UploadStream;
                case 11 -> MergedBlockMetaRequest;
                case 12 -> MergedBlockMetaSuccess;
                case -1 -> throw new IllegalArgumentException("User type messages cannot be decoded.");
                default -> throw new IllegalArgumentException("Unknown message type: " + id);
            };
        }

        private static /* synthetic */ Type[] $values() {
            return new Type[]{ChunkFetchRequest, ChunkFetchSuccess, ChunkFetchFailure, RpcRequest, RpcResponse, RpcFailure, StreamRequest, StreamResponse, StreamFailure, OneWayMessage, UploadStream, MergedBlockMetaRequest, MergedBlockMetaSuccess, User};
        }

        static {
            $VALUES = Type.$values();
        }
    }
}

