/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.OctetLength$;
import org.apache.spark.sql.catalyst.expressions.UnaryExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.internal.types.StringTypeWithCollation$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.StringType;
import org.apache.spark.sql.types.TypeCollection$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Product;
import scala.collection.Iterator;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="_FUNC_(expr) - Returns the byte length of string data or number of bytes of binary data.", examples="\n    Examples:\n      > SELECT _FUNC_('Spark SQL');\n       9\n      > SELECT _FUNC_(x'537061726b2053514c');\n       9\n  ", since="2.3.0", group="string_funcs")
@ScalaSignature(bytes="\u0006\u0005\u0005Ug\u0001\u0002\u000f\u001e\u0001*B\u0001\u0002\u0012\u0001\u0003\u0016\u0004%\t!\u0012\u0005\t\u0013\u0002\u0011\t\u0012)A\u0005\r\")!\n\u0001C\u0001\u0017\")a\n\u0001C!\u001f\")1\u000b\u0001C!)\")1\f\u0001C!9\")1\r\u0001C!\u001f\")A\r\u0001C)K\")1\u000e\u0001C!Y\")!\u0010\u0001C!w\"9\u0011\u0011\u0002\u0001\u0005R\u0005-\u0001\"CA\t\u0001\u0005\u0005I\u0011AA\n\u0011%\t9\u0002AI\u0001\n\u0003\tI\u0002C\u0005\u00020\u0001\t\t\u0011\"\u0011\u00022!I\u0011\u0011\t\u0001\u0002\u0002\u0013\u0005\u00111\t\u0005\n\u0003\u0017\u0002\u0011\u0011!C\u0001\u0003\u001bB\u0011\"a\u0015\u0001\u0003\u0003%\t%!\u0016\t\u0013\u0005\r\u0004!!A\u0005\u0002\u0005\u0015\u0004\"CA5\u0001\u0005\u0005I\u0011IA6\u0011%\ty\u0007AA\u0001\n\u0003\n\thB\u0005\u0002\u0016v\t\t\u0011#\u0001\u0002\u0018\u001aAA$HA\u0001\u0012\u0003\tI\n\u0003\u0004K-\u0011\u0005\u0011\u0011\u0017\u0005\n\u0003g3\u0012\u0011!C#\u0003kC\u0011\"a.\u0017\u0003\u0003%\t)!/\t\u0013\u0005uf#!A\u0005\u0002\u0006}\u0006\"CAf-\u0005\u0005I\u0011BAg\u0005-y5\r^3u\u0019\u0016tw\r\u001e5\u000b\u0005yy\u0012aC3yaJ,7o]5p]NT!\u0001I\u0011\u0002\u0011\r\fG/\u00197zgRT!AI\u0012\u0002\u0007M\fHN\u0003\u0002%K\u0005)1\u000f]1sW*\u0011aeJ\u0001\u0007CB\f7\r[3\u000b\u0003!\n1a\u001c:h\u0007\u0001\u0019R\u0001A\u00160ea\u0002\"\u0001L\u0017\u000e\u0003uI!AL\u000f\u0003\u001fUs\u0017M]=FqB\u0014Xm]:j_:\u0004\"\u0001\f\u0019\n\u0005Ej\"AF%na2L7-\u001b;DCN$\u0018J\u001c9viRK\b/Z:\u0011\u0005M2T\"\u0001\u001b\u000b\u0003U\nQa]2bY\u0006L!a\u000e\u001b\u0003\u000fA\u0013x\u000eZ;diB\u0011\u0011(\u0011\b\u0003u}r!a\u000f \u000e\u0003qR!!P\u0015\u0002\rq\u0012xn\u001c;?\u0013\u0005)\u0014B\u0001!5\u0003\u001d\u0001\u0018mY6bO\u0016L!AQ\"\u0003\u0019M+'/[1mSj\f'\r\\3\u000b\u0005\u0001#\u0014!B2iS2$W#\u0001$\u0011\u00051:\u0015B\u0001%\u001e\u0005))\u0005\u0010\u001d:fgNLwN\\\u0001\u0007G\"LG\u000e\u001a\u0011\u0002\rqJg.\u001b;?)\taU\n\u0005\u0002-\u0001!)Ai\u0001a\u0001\r\u0006qa.\u001e7m\u0013:$x\u000e\\3sC:$X#\u0001)\u0011\u0005M\n\u0016B\u0001*5\u0005\u001d\u0011un\u001c7fC:\f\u0001\u0002Z1uCRK\b/Z\u000b\u0002+B\u0011a+W\u0007\u0002/*\u0011\u0001,I\u0001\u0006if\u0004Xm]\u0005\u00035^\u0013\u0001\u0002R1uCRK\b/Z\u0001\u000bS:\u0004X\u000f\u001e+za\u0016\u001cX#A/\u0011\u0007er\u0006-\u0003\u0002`\u0007\n\u00191+Z9\u0011\u0005Y\u000b\u0017B\u00012X\u0005A\t%m\u001d;sC\u000e$H)\u0019;b)f\u0004X-\u0001\u000ed_:$X\r\u001f;J]\u0012,\u0007/\u001a8eK:$hi\u001c7eC\ndW-\u0001\u0007ok2d7+\u00194f\u000bZ\fG\u000e\u0006\u0002gSB\u00111gZ\u0005\u0003QR\u00121!\u00118z\u0011\u0015Q\u0007\u00021\u0001g\u0003\u00151\u0018\r\\;f\u0003%!wnR3o\u0007>$W\rF\u0002ngb\u0004\"A\\9\u000e\u0003=T!\u0001]\u000f\u0002\u000f\r|G-Z4f]&\u0011!o\u001c\u0002\t\u000bb\u0004(oQ8eK\")A/\u0003a\u0001k\u0006\u00191\r\u001e=\u0011\u000594\u0018BA<p\u00059\u0019u\u000eZ3hK:\u001cuN\u001c;fqRDQ!_\u0005A\u00025\f!!\u001a<\u0002\u0015A\u0014X\r\u001e;z\u001d\u0006lW-F\u0001}!\ri\u00181\u0001\b\u0003}~\u0004\"a\u000f\u001b\n\u0007\u0005\u0005A'\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003\u000b\t9A\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003\u0003!\u0014\u0001F<ji\"tUm^\"iS2$\u0017J\u001c;fe:\fG\u000eF\u0002M\u0003\u001bAa!a\u0004\f\u0001\u00041\u0015\u0001\u00038fo\u000eC\u0017\u000e\u001c3\u0002\t\r|\u0007/\u001f\u000b\u0004\u0019\u0006U\u0001b\u0002#\r!\u0003\u0005\rAR\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\tYBK\u0002G\u0003;Y#!a\b\u0011\t\u0005\u0005\u00121F\u0007\u0003\u0003GQA!!\n\u0002(\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003S!\u0014AC1o]>$\u0018\r^5p]&!\u0011QFA\u0012\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0005\u0005M\u0002\u0003BA\u001b\u0003\u007fi!!a\u000e\u000b\t\u0005e\u00121H\u0001\u0005Y\u0006twM\u0003\u0002\u0002>\u0005!!.\u0019<b\u0013\u0011\t)!a\u000e\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0016\u0005\u0005\u0015\u0003cA\u001a\u0002H%\u0019\u0011\u0011\n\u001b\u0003\u0007%sG/\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\u0007\u0019\fy\u0005C\u0005\u0002RA\t\t\u00111\u0001\u0002F\u0005\u0019\u0001\u0010J\u0019\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"!a\u0016\u0011\u000b\u0005e\u0013q\f4\u000e\u0005\u0005m#bAA/i\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005\u0005\u00141\f\u0002\t\u0013R,'/\u0019;pe\u0006A1-\u00198FcV\fG\u000eF\u0002Q\u0003OB\u0001\"!\u0015\u0013\u0003\u0003\u0005\rAZ\u0001\u0013aJ|G-^2u\u000b2,W.\u001a8u\u001d\u0006lW\r\u0006\u0003\u00024\u00055\u0004\"CA)'\u0005\u0005\t\u0019AA#\u0003\u0019)\u0017/^1mgR\u0019\u0001+a\u001d\t\u0011\u0005EC#!AA\u0002\u0019D3\u0003AA<\u0003{\ny(a!\u0002\u0006\u0006%\u00151RAH\u0003#\u00032\u0001LA=\u0013\r\tY(\b\u0002\u0016\u000bb\u0004(/Z:tS>tG)Z:de&\u0004H/[8o\u0003\u0015)8/Y4fC\t\t\t)\u0001-`\rVs5i\u0018\u0015fqB\u0014\u0018\u0006I\u0017!%\u0016$XO\u001d8tAQDW\r\t2zi\u0016\u0004C.\u001a8hi\"\u0004sN\u001a\u0011tiJLgn\u001a\u0011eCR\f\u0007e\u001c:!]Vl'-\u001a:!_\u001a\u0004#-\u001f;fg\u0002zg\r\t2j]\u0006\u0014\u0018\u0010\t3bi\u0006t\u0013\u0001C3yC6\u0004H.Z:\"\u0005\u0005\u001d\u0015!\u001e\u0006!A\u0001\u0002S\t_1na2,7O\u000f\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!?\u001a+fjQ0)OM\u0003\u0018M]6!'Fcu%K\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!s)\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003sLR+O\u0007~C\u0003pJ\u001b4oA2\u0014g\u000e\u001a7EJ\u0002TgM\u001b2i\r<\u0013f\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u0011:\u0015\u0001\u0002\u0013!B:j]\u000e,\u0017EAAG\u0003\u0015\u0011df\r\u00181\u0003\u00159'o\\;qC\t\t\u0019*\u0001\u0007tiJLgnZ0gk:\u001c7/A\u0006PGR,G\u000fT3oORD\u0007C\u0001\u0017\u0017'\u00151\u00121TAT!\u0019\ti*a)G\u00196\u0011\u0011q\u0014\u0006\u0004\u0003C#\u0014a\u0002:v]RLW.Z\u0005\u0005\u0003K\u000byJA\tBEN$(/Y2u\rVt7\r^5p]F\u0002B!!+\u000206\u0011\u00111\u0016\u0006\u0005\u0003[\u000bY$\u0001\u0002j_&\u0019!)a+\u0015\u0005\u0005]\u0015\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\u0005M\u0012!B1qa2LHc\u0001'\u0002<\")A)\u0007a\u0001\r\u00069QO\\1qa2LH\u0003BAa\u0003\u000f\u0004BaMAb\r&\u0019\u0011Q\u0019\u001b\u0003\r=\u0003H/[8o\u0011!\tIMGA\u0001\u0002\u0004a\u0015a\u0001=%a\u0005aqO]5uKJ+\u0007\u000f\\1dKR\u0011\u0011q\u001a\t\u0005\u0003k\t\t.\u0003\u0003\u0002T\u0006]\"AB(cU\u0016\u001cG\u000f")
public class OctetLength
extends UnaryExpression
implements ImplicitCastInputTypes,
Serializable {
    private final Expression child;

    public static Option<Expression> unapply(OctetLength x$0) {
        return OctetLength$.MODULE$.unapply(x$0);
    }

    public static <A> Function1<Expression, A> andThen(Function1<OctetLength, A> g) {
        return OctetLength$.MODULE$.andThen(g);
    }

    public static <A$> Function1<A$, OctetLength> compose(Function1<A$, Expression> g) {
        return OctetLength$.MODULE$.compose(g);
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    @Override
    public Expression child() {
        return this.child;
    }

    @Override
    public boolean nullIntolerant() {
        return true;
    }

    @Override
    public DataType dataType() {
        return IntegerType$.MODULE$;
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return new .colon.colon((Object)TypeCollection$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AbstractDataType[]{StringTypeWithCollation$.MODULE$.apply(true, StringTypeWithCollation$.MODULE$.apply$default$2(), StringTypeWithCollation$.MODULE$.apply$default$3()), BinaryType$.MODULE$})), (List)Nil$.MODULE$);
    }

    @Override
    public boolean contextIndependentFoldable() {
        return this.child().contextIndependentFoldable();
    }

    @Override
    public Object nullSafeEval(Object value) {
        DataType dataType = this.child().dataType();
        if (dataType instanceof StringType) {
            return BoxesRunTime.boxToInteger((int)((UTF8String)value).numBytes());
        }
        if (BinaryType$.MODULE$.equals(dataType)) {
            return BoxesRunTime.boxToInteger((int)((byte[])value).length);
        }
        throw new MatchError((Object)dataType);
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        DataType dataType = this.child().dataType();
        if (dataType instanceof StringType) {
            return this.defineCodeGen(ctx, ev, (Function1<String, String>)(Function1 & Serializable)c -> "(" + c + ").numBytes()");
        }
        if (BinaryType$.MODULE$.equals(dataType)) {
            return this.defineCodeGen(ctx, ev, (Function1<String, String>)(Function1 & Serializable)c -> "(" + c + ").length");
        }
        throw new MatchError((Object)dataType);
    }

    @Override
    public String prettyName() {
        return "octet_length";
    }

    @Override
    public OctetLength withNewChildInternal(Expression newChild) {
        return this.copy(newChild);
    }

    public OctetLength copy(Expression child) {
        return new OctetLength(child);
    }

    public Expression copy$default$1() {
        return this.child();
    }

    @Override
    public String productPrefix() {
        return "OctetLength";
    }

    public int productArity() {
        return 1;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.child();
            }
        }
        return Statics.ioobe((int)x$1);
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof OctetLength;
    }

    @Override
    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "child";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof OctetLength)) return false;
        boolean bl = true;
        if (!bl) return false;
        OctetLength octetLength = (OctetLength)x$1;
        Expression expression = this.child();
        Expression expression2 = octetLength.child();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        if (!octetLength.canEqual(this)) return false;
        return true;
    }

    public OctetLength(Expression child) {
        this.child = child;
        ExpectsInputTypes.$init$(this);
    }
}

