/*
 * Decompiled with CFR 0.152.
 */
package org.sparkproject.org.apache.arrow.vector.complex.impl;

import java.time.LocalDateTime;
import java.util.concurrent.TimeUnit;
import org.sparkproject.org.apache.arrow.vector.complex.impl.AbstractFieldReader;
import org.sparkproject.org.apache.arrow.vector.holders.NullableTimeStampSecHolder;
import org.sparkproject.org.apache.arrow.vector.holders.TimeStampSecHolder;
import org.sparkproject.org.apache.arrow.vector.types.Types;
import org.sparkproject.org.apache.arrow.vector.util.DateUtility;

public class NullableTimeStampSecHolderReaderImpl
extends AbstractFieldReader {
    private NullableTimeStampSecHolder holder;

    public NullableTimeStampSecHolderReaderImpl(NullableTimeStampSecHolder holder) {
        this.holder = holder;
    }

    @Override
    public int size() {
        throw new UnsupportedOperationException("You can't call size on a Holder value reader.");
    }

    @Override
    public boolean next() {
        throw new UnsupportedOperationException("You can't call next on a single value reader.");
    }

    @Override
    public void setPosition(int index) {
        throw new UnsupportedOperationException("You can't call next on a single value reader.");
    }

    @Override
    public Types.MinorType getMinorType() {
        return Types.MinorType.TIMESTAMPSEC;
    }

    @Override
    public boolean isSet() {
        return this.holder.isSet == 1;
    }

    @Override
    public void read(TimeStampSecHolder h) {
        h.value = this.holder.value;
    }

    @Override
    public void read(NullableTimeStampSecHolder h) {
        h.value = this.holder.value;
        h.isSet = this.isSet() ? 1 : 0;
    }

    @Override
    public LocalDateTime readLocalDateTime() {
        if (!this.isSet()) {
            return null;
        }
        long millis = TimeUnit.SECONDS.toMillis(this.holder.value);
        return DateUtility.getLocalDateTimeFromEpochMilli(millis);
    }

    @Override
    public Object readObject() {
        return this.readLocalDateTime();
    }
}

