/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.streaming.checkpointing;

import java.io.FileNotFoundException;
import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.LogEntry$;
import org.apache.spark.internal.LogKey;
import org.apache.spark.internal.LogKeys;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.MDC;
import org.apache.spark.internal.MessageWithContext;
import org.apache.spark.sql.execution.streaming.checkpointing.CheckpointFileManager;
import org.apache.spark.sql.execution.streaming.checkpointing.ChecksumCancellableFSDataOutputStream;
import org.apache.spark.sql.execution.streaming.checkpointing.ChecksumCheckpointFileManager$;
import org.apache.spark.sql.execution.streaming.checkpointing.ChecksumFSDataInputStream;
import org.apache.spark.util.ThreadUtils$;
import org.slf4j.Logger;
import org.slf4j.event.Level;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContext$;
import scala.concurrent.ExecutionContextExecutorService;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\t\u0005a\u0001\u0002\u0012$\u0001IB\u0001b\u0011\u0001\u0003\u0006\u0004%I\u0001\u0012\u0005\t\u000b\u0002\u0011\t\u0011)A\u0005s!Aa\t\u0001BC\u0002\u0013\u0005q\t\u0003\u0005L\u0001\t\u0005\t\u0015!\u0003I\u0011!a\u0005A!b\u0001\n\u0003i\u0005\u0002C)\u0001\u0005\u0003\u0005\u000b\u0011\u0002(\t\u0011I\u0003!Q1A\u0005\u0002\u001dC\u0001b\u0015\u0001\u0003\u0002\u0003\u0006I\u0001\u0013\u0005\u0006)\u0002!\t!\u0016\u0005\b7\u0002\u0011\r\u0011\"\u0003]\u0011\u0019\u0019\u0007\u0001)A\u0005;\")A\r\u0001C!K\")A\r\u0001C!w\")Q\u0010\u0001C!}\"9\u0011q\u0001\u0001\u0005\n\u0005%\u0001bBA\u0007\u0001\u0011\u0005\u0013q\u0002\u0005\b\u0003\u000f\u0002A\u0011BA%\u0011\u001d\ti\u0006\u0001C!\u0003?Bq!!\u001b\u0001\t\u0003\nY\u0007C\u0004\u0002p\u0001!\t%!\u001d\t\u000f\u0005U\u0004\u0001\"\u0003\u0002x!1\u0011Q\u0010\u0001\u0005B\u001dCq!a \u0001\t\u0003\n\t\tC\u0004\u0002\u0004\u0002!\t%!\"\b\u0011\u0005\u001d5\u0005#\u0001&\u0003\u00133qAI\u0012\t\u0002\u0015\nY\t\u0003\u0004U5\u0011\u0005\u0011Q\u0012\u0005\n\u0003\u001fS\"\u0019!C\u0001\u0003#C\u0001\"a)\u001bA\u0003%\u00111\u0013\u0005\b\u0003KSB\u0011AAT\u0011\u001d\tYN\u0007C\u0001\u0003;Dq!a9\u001b\t\u0003\t)\u000fC\u0005\u0002jj\t\n\u0011\"\u0001\u0002l\ni2\t[3dWN,Xn\u00115fG.\u0004x.\u001b8u\r&dW-T1oC\u001e,'O\u0003\u0002%K\u0005i1\r[3dWB|\u0017N\u001c;j]\u001eT!AJ\u0014\u0002\u0013M$(/Z1nS:<'B\u0001\u0015*\u0003%)\u00070Z2vi&|gN\u0003\u0002+W\u0005\u00191/\u001d7\u000b\u00051j\u0013!B:qCJ\\'B\u0001\u00180\u0003\u0019\t\u0007/Y2iK*\t\u0001'A\u0002pe\u001e\u001c\u0001a\u0005\u0003\u0001gej\u0004C\u0001\u001b8\u001b\u0005)$\"\u0001\u001c\u0002\u000bM\u001c\u0017\r\\1\n\u0005a*$AB!osJ+g\r\u0005\u0002;w5\t1%\u0003\u0002=G\t)2\t[3dWB|\u0017N\u001c;GS2,W*\u00198bO\u0016\u0014\bC\u0001 B\u001b\u0005y$B\u0001!,\u0003!Ig\u000e^3s]\u0006d\u0017B\u0001\"@\u0005\u001daunZ4j]\u001e\f\u0011#\u001e8eKJd\u00170\u001b8h\r&dW-T4s+\u0005I\u0014AE;oI\u0016\u0014H._5oO\u001aKG.Z'he\u0002\nQ#\u00197m_^\u001cuN\\2veJ,g\u000e\u001e#fY\u0016$X-F\u0001I!\t!\u0014*\u0003\u0002Kk\t9!i\\8mK\u0006t\u0017AF1mY><8i\u001c8dkJ\u0014XM\u001c;EK2,G/\u001a\u0011\u0002\u00159,X\u000e\u00165sK\u0006$7/F\u0001O!\t!t*\u0003\u0002Qk\t\u0019\u0011J\u001c;\u0002\u00179,X\u000e\u00165sK\u0006$7\u000fI\u0001\"g.L\u0007o\u0011:fCRLwN\\%g\r&dW-T5tg&twm\u00115fG.\u001cX/\\\u0001#g.L\u0007o\u0011:fCRLwN\\%g\r&dW-T5tg&twm\u00115fG.\u001cX/\u001c\u0011\u0002\rqJg.\u001b;?)\u00151v\u000bW-[!\tQ\u0004\u0001C\u0003D\u0013\u0001\u0007\u0011\bC\u0004G\u0013A\u0005\t\u0019\u0001%\t\u000b1K\u0001\u0019\u0001(\t\u000bIK\u0001\u0019\u0001%\u0002\u0015QD'/Z1e!>|G.F\u0001^!\tq\u0016-D\u0001`\u0015\t\u0001W'\u0001\u0006d_:\u001cWO\u001d:f]RL!AY0\u0003?\u0015CXmY;uS>t7i\u001c8uKb$X\t_3dkR|'oU3sm&\u001cW-A\u0006uQJ,\u0017\r\u001a)p_2\u0004\u0013\u0001\u00027jgR$2AZ9w!\r!t-[\u0005\u0003QV\u0012Q!\u0011:sCf\u0004\"A[8\u000e\u0003-T!\u0001\\7\u0002\u0005\u0019\u001c(B\u00018.\u0003\u0019A\u0017\rZ8pa&\u0011\u0001o\u001b\u0002\u000b\r&dWm\u0015;biV\u001c\b\"\u0002:\r\u0001\u0004\u0019\u0018\u0001\u00029bi\"\u0004\"A\u001b;\n\u0005U\\'\u0001\u0002)bi\"DQa\u001e\u0007A\u0002a\faAZ5mi\u0016\u0014\bC\u00016z\u0013\tQ8N\u0001\u0006QCRDg)\u001b7uKJ$\"A\u001a?\t\u000bIl\u0001\u0019A:\u0002\r5\\G-\u001b:t)\ry\u0018Q\u0001\t\u0004i\u0005\u0005\u0011bAA\u0002k\t!QK\\5u\u0011\u0015\u0011h\u00021\u0001t\u0003i\u0019\bn\\;mIN[\u0017\u000e]\"iK\u000e\\7/^7De\u0016\fG/[8o)\rA\u00151\u0002\u0005\u0006e>\u0001\ra]\u0001\rGJ,\u0017\r^3Bi>l\u0017n\u0019\u000b\u0007\u0003#\t\t%a\u0011\u0011\t\u0005M\u00111\b\b\u0005\u0003+\t9D\u0004\u0003\u0002\u0018\u0005Ub\u0002BA\r\u0003gqA!a\u0007\u000229!\u0011QDA\u0018\u001d\u0011\ty\"!\f\u000f\t\u0005\u0005\u00121\u0006\b\u0005\u0003G\tI#\u0004\u0002\u0002&)\u0019\u0011qE\u0019\u0002\rq\u0012xn\u001c;?\u0013\u0005\u0001\u0014B\u0001\u00180\u0013\taS&\u0003\u0002+W%\u0011\u0001&K\u0005\u0003M\u001dJ!\u0001J\u0013\n\u0007\u0005e2%A\u000bDQ\u0016\u001c7\u000e]8j]R4\u0015\u000e\\3NC:\fw-\u001a:\n\t\u0005u\u0012q\b\u0002\u001e\u0007\u0006t7-\u001a7mC\ndWMR*ECR\fw*\u001e;qkR\u001cFO]3b[*\u0019\u0011\u0011H\u0012\t\u000bI\u0004\u0002\u0019A:\t\r\u0005\u0015\u0003\u00031\u0001I\u0003Myg/\u001a:xe&$X-\u00134Q_N\u001c\u0018N\u00197f\u0003I\u0019'/Z1uK^KG\u000f[\"iK\u000e\\7/^7\u0015\r\u0005-\u0013\u0011KA*!\rQ\u0014QJ\u0005\u0004\u0003\u001f\u001a#!J\"iK\u000e\\7/^7DC:\u001cW\r\u001c7bE2,gi\u0015#bi\u0006|U\u000f\u001e9viN#(/Z1n\u0011\u0015\u0011\u0018\u00031\u0001t\u0011\u001d\t)&\u0005a\u0001\u0003/\n!b\u0019:fCR,g)\u001e8d!\u0019!\u0014\u0011L:\u0002\u0012%\u0019\u00111L\u001b\u0003\u0013\u0019+hn\u0019;j_:\f\u0014\u0001B8qK:$B!!\u0019\u0002hA\u0019!.a\u0019\n\u0007\u0005\u00154NA\tG'\u0012\u000bG/Y%oaV$8\u000b\u001e:fC6DQA\u001d\nA\u0002M\fa!\u001a=jgR\u001cHc\u0001%\u0002n!)!o\u0005a\u0001g\u00061A-\u001a7fi\u0016$2a`A:\u0011\u0015\u0011H\u00031\u0001t\u0003I!W\r\\3uK\u000eCWmY6tk64\u0015\u000e\\3\u0015\u0007}\fI\b\u0003\u0004\u0002|U\u0001\ra]\u0001\rG\",7m[:v[B\u000bG\u000f[\u0001\bSNdunY1m\u0003e\u0019'/Z1uK\u000eCWmY6q_&tG\u000fR5sK\u000e$xN]=\u0015\u0003M\fQa\u00197pg\u0016$\u0012a`\u0001\u001e\u0007\",7m[:v[\u000eCWmY6q_&tGOR5mK6\u000bg.Y4feB\u0011!HG\n\u00035M\"\"!!#\u0002)\rCUiQ&T+6{f)\u0013'F?N+fIR%Y+\t\t\u0019\n\u0005\u0003\u0002\u0016\u0006}UBAAL\u0015\u0011\tI*a'\u0002\t1\fgn\u001a\u0006\u0003\u0003;\u000bAA[1wC&!\u0011\u0011UAL\u0005\u0019\u0019FO]5oO\u0006)2\tS#D\u0017N+Vj\u0018$J\u0019\u0016{6+\u0016$G\u0013b\u0003\u0013aC1xC&$(+Z:vYR,B!!+\u00020R1\u00111VAa\u0003\u0017\u0004B!!,\u000202\u0001AaBAY=\t\u0007\u00111\u0017\u0002\u0002)F!\u0011QWA^!\r!\u0014qW\u0005\u0004\u0003s+$a\u0002(pi\"Lgn\u001a\t\u0004i\u0005u\u0016bAA`k\t\u0019\u0011I\\=\t\u000f\u0005\rg\u00041\u0001\u0002F\u00061a-\u001e;ve\u0016\u0004RAXAd\u0003WK1!!3`\u0005\u00191U\u000f^;sK\"9\u0011Q\u001a\u0010A\u0002\u0005=\u0017AB1u\u001b>\u001cH\u000f\u0005\u0003\u0002R\u0006]WBAAj\u0015\r\t)nX\u0001\tIV\u0014\u0018\r^5p]&!\u0011\u0011\\Aj\u0005!!UO]1uS>t\u0017aD4fi\u000eCWmY6tk6\u0004\u0016\r\u001e5\u0015\u0007M\fy\u000e\u0003\u0004\u0002b~\u0001\ra]\u0001\r[\u0006LgNR5mKB\u000bG\u000f[\u0001\u000fSN\u001c\u0005.Z2lgVlg)\u001b7f)\rA\u0015q\u001d\u0005\u0006e\u0002\u0002\ra]\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\u00055(f\u0001%\u0002p.\u0012\u0011\u0011\u001f\t\u0005\u0003g\fi0\u0004\u0002\u0002v*!\u0011q_A}\u0003%)hn\u00195fG.,GMC\u0002\u0002|V\n!\"\u00198o_R\fG/[8o\u0013\u0011\ty0!>\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW\r")
public class ChecksumCheckpointFileManager
implements CheckpointFileManager,
Logging {
    private final CheckpointFileManager underlyingFileMgr;
    private final boolean allowConcurrentDelete;
    private final int numThreads;
    private final boolean skipCreationIfFileMissingChecksum;
    private final ExecutionContextExecutorService threadPool;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static boolean $lessinit$greater$default$2() {
        return ChecksumCheckpointFileManager$.MODULE$.$lessinit$greater$default$2();
    }

    public static boolean isChecksumFile(Path path) {
        return ChecksumCheckpointFileManager$.MODULE$.isChecksumFile(path);
    }

    public static Path getChecksumPath(Path mainFilePath) {
        return ChecksumCheckpointFileManager$.MODULE$.getChecksumPath(mainFilePath);
    }

    public static <T> T awaitResult(Future<T> future, Duration atMost) {
        return ChecksumCheckpointFileManager$.MODULE$.awaitResult(future, atMost);
    }

    public static String CHECKSUM_FILE_SUFFIX() {
        return ChecksumCheckpointFileManager$.MODULE$.CHECKSUM_FILE_SUFFIX();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    @Override
    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(Map<String, String> context, Function0<BoxedUnit> body2) {
        Logging.withLogContext$((Logging)this, context, body2);
    }

    public MDC MDC(LogKey key, Object value) {
        return Logging.MDC$((Logging)this, (LogKey)key, (Object)value);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void logBasedOnLevel(Level level, Function0<MessageWithContext> f) {
        Logging.logBasedOnLevel$((Logging)this, (Level)level, f);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private CheckpointFileManager underlyingFileMgr() {
        return this.underlyingFileMgr;
    }

    public boolean allowConcurrentDelete() {
        return this.allowConcurrentDelete;
    }

    public int numThreads() {
        return this.numThreads;
    }

    public boolean skipCreationIfFileMissingChecksum() {
        return this.skipCreationIfFileMissingChecksum;
    }

    private ExecutionContextExecutorService threadPool() {
        return this.threadPool;
    }

    @Override
    public FileStatus[] list(Path path, PathFilter filter) {
        return this.underlyingFileMgr().list(path, filter);
    }

    @Override
    public FileStatus[] list(Path path) {
        return this.underlyingFileMgr().list(path);
    }

    @Override
    public void mkdirs(Path path) {
        this.underlyingFileMgr().mkdirs(path);
    }

    private boolean shouldSkipChecksumCreation(Path path) {
        return this.skipCreationIfFileMissingChecksum() && this.underlyingFileMgr().exists(path) && !this.underlyingFileMgr().exists(ChecksumCheckpointFileManager$.MODULE$.getChecksumPath(path));
    }

    @Override
    public CheckpointFileManager.CancellableFSDataOutputStream createAtomic(Path path, boolean overwriteIfPossible) {
        if (this.shouldSkipChecksumCreation(path)) {
            return this.underlyingFileMgr().createAtomic(path, overwriteIfPossible);
        }
        return this.createWithChecksum(path, (Function1<Path, CheckpointFileManager.CancellableFSDataOutputStream>)(Function1 & Serializable)x$2 -> this.underlyingFileMgr().createAtomic((Path)x$2, overwriteIfPossible));
    }

    private ChecksumCancellableFSDataOutputStream createWithChecksum(Path path, Function1<Path, CheckpointFileManager.CancellableFSDataOutputStream> createFunc) {
        Predef$.MODULE$.assert(!ChecksumCheckpointFileManager$.MODULE$.isChecksumFile(path), (Function0 & Serializable)() -> "Cannot directly create a checksum file");
        Future mainFileFuture = Future$.MODULE$.apply((Function0 & Serializable)() -> (CheckpointFileManager.CancellableFSDataOutputStream)((Object)((Object)createFunc.apply((Object)path))), (ExecutionContext)this.threadPool());
        Future checksumFileFuture = Future$.MODULE$.apply((Function0 & Serializable)() -> (CheckpointFileManager.CancellableFSDataOutputStream)((Object)((Object)createFunc.apply((Object)ChecksumCheckpointFileManager$.MODULE$.getChecksumPath(path)))), (ExecutionContext)this.threadPool());
        return new ChecksumCancellableFSDataOutputStream((CheckpointFileManager.CancellableFSDataOutputStream)((Object)ChecksumCheckpointFileManager$.MODULE$.awaitResult(mainFileFuture, (Duration)Duration$.MODULE$.Inf())), path, (CheckpointFileManager.CancellableFSDataOutputStream)((Object)ChecksumCheckpointFileManager$.MODULE$.awaitResult(checksumFileFuture, (Duration)Duration$.MODULE$.Inf())), (ExecutionContext)this.threadPool());
    }

    @Override
    public FSDataInputStream open(Path path) {
        Predef$.MODULE$.assert(!ChecksumCheckpointFileManager$.MODULE$.isChecksumFile(path), (Function0 & Serializable)() -> "Cannot directly open a checksum file");
        Future checksumInputStreamFuture = Future$.MODULE$.apply((Function0 & Serializable)() -> {
            Some some;
            try {
                some = new Some((Object)this.underlyingFileMgr().open(ChecksumCheckpointFileManager$.MODULE$.getChecksumPath(path)));
            }
            catch (FileNotFoundException fileNotFoundException) {
                this.logWarning(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"No checksum file found for ", ", "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{this.MDC((LogKey)LogKeys.PATH, path)})).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"hence no checksum verification."}))).log((Seq)Nil$.MODULE$))));
                some = None$.MODULE$;
            }
            return some;
        }, (ExecutionContext)this.threadPool());
        Future mainInputStreamFuture = Future$.MODULE$.apply((Function0 & Serializable)() -> this.underlyingFileMgr().open(path), (ExecutionContext)this.threadPool());
        FSDataInputStream mainStream = (FSDataInputStream)ChecksumCheckpointFileManager$.MODULE$.awaitResult(mainInputStreamFuture, (Duration)Duration$.MODULE$.Inf());
        Option checksumStream = (Option)ChecksumCheckpointFileManager$.MODULE$.awaitResult(checksumInputStreamFuture, (Duration)Duration$.MODULE$.Inf());
        return (FSDataInputStream)checksumStream.map((Function1 & Serializable)chkStream -> new ChecksumFSDataInputStream(mainStream, path, (FSDataInputStream)chkStream, (ExecutionContext)this.threadPool())).getOrElse((Function0 & Serializable)() -> mainStream);
    }

    @Override
    public boolean exists(Path path) {
        return this.underlyingFileMgr().exists(path);
    }

    @Override
    public void delete(Path path) {
        if (ChecksumCheckpointFileManager$.MODULE$.isChecksumFile(path)) {
            this.deleteChecksumFile(path);
            return;
        }
        if (this.allowConcurrentDelete()) {
            Future checksumInputStreamFuture = Future$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable)() -> this.deleteChecksumFile(ChecksumCheckpointFileManager$.MODULE$.getChecksumPath(path)), (ExecutionContext)this.threadPool());
            Future mainInputStreamFuture = Future$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable)() -> this.underlyingFileMgr().delete(path), (ExecutionContext)this.threadPool());
            ChecksumCheckpointFileManager$.MODULE$.awaitResult(mainInputStreamFuture, (Duration)Duration$.MODULE$.Inf());
            ChecksumCheckpointFileManager$.MODULE$.awaitResult(checksumInputStreamFuture, (Duration)Duration$.MODULE$.Inf());
            return;
        }
        this.deleteChecksumFile(ChecksumCheckpointFileManager$.MODULE$.getChecksumPath(path));
        this.underlyingFileMgr().delete(path);
    }

    private void deleteChecksumFile(Path checksumPath) {
        this.underlyingFileMgr().delete(checksumPath);
        this.logDebug(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Deleted checksum file ", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{this.MDC((LogKey)LogKeys.PATH, checksumPath)}))));
    }

    @Override
    public boolean isLocal() {
        return this.underlyingFileMgr().isLocal();
    }

    @Override
    public Path createCheckpointDirectory() {
        return this.underlyingFileMgr().createCheckpointDirectory();
    }

    @Override
    public void close() {
        this.threadPool().shutdown();
        int timeoutMs = 500;
        if (!this.threadPool().awaitTermination((long)timeoutMs, TimeUnit.MILLISECONDS)) {
            this.logWarning(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Thread pool did not shutdown after ", " ms,"}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{this.MDC((LogKey)LogKeys.TIMEOUT, BoxesRunTime.boxToInteger((int)timeoutMs))})).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{" forcing shutdown"}))).log((Seq)Nil$.MODULE$))));
            this.threadPool().shutdownNow();
            if (!this.threadPool().awaitTermination((long)timeoutMs, TimeUnit.MILLISECONDS)) {
                this.logError(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Thread pool did not terminate"}))).log((Seq)Nil$.MODULE$)));
                return;
            }
            return;
        }
    }

    public ChecksumCheckpointFileManager(CheckpointFileManager underlyingFileMgr, boolean allowConcurrentDelete, int numThreads, boolean skipCreationIfFileMissingChecksum) {
        this.underlyingFileMgr = underlyingFileMgr;
        this.allowConcurrentDelete = allowConcurrentDelete;
        this.numThreads = numThreads;
        this.skipCreationIfFileMissingChecksum = skipCreationIfFileMissingChecksum;
        CheckpointFileManager.$init$(this);
        Logging.$init$((Logging)this);
        Predef$.MODULE$.assert(numThreads % 2 == 0, (Function0 & Serializable)() -> "numThreads must be a multiple of 2, we need 1 for the main fileand another for the checksum file");
        this.threadPool = ExecutionContext$.MODULE$.fromExecutorService((ExecutorService)ThreadUtils$.MODULE$.newDaemonFixedThreadPool(numThreads, this.getClass().getSimpleName() + "-Thread"));
    }
}

