/*
 * Decompiled with CFR 0.152.
 */
package org.sparkproject.dmg.pmml.time_series;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonRootName;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlEnum;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.sparkproject.dmg.pmml.Extension;
import org.sparkproject.dmg.pmml.HasExtensions;
import org.sparkproject.dmg.pmml.PMMLObject;
import org.sparkproject.dmg.pmml.StringValue;
import org.sparkproject.dmg.pmml.Version;
import org.sparkproject.dmg.pmml.Visitable;
import org.sparkproject.dmg.pmml.Visitor;
import org.sparkproject.dmg.pmml.VisitorAction;
import org.sparkproject.dmg.pmml.adapters.RealNumberAdapter;
import org.sparkproject.dmg.pmml.time_series.Algorithm;
import org.sparkproject.dmg.pmml.time_series.DynamicRegressor;
import org.sparkproject.dmg.pmml.time_series.HasDynamicRegressors;
import org.sparkproject.dmg.pmml.time_series.MaximumLikelihoodStat;
import org.sparkproject.dmg.pmml.time_series.NonseasonalComponent;
import org.sparkproject.dmg.pmml.time_series.OutlierEffect;
import org.sparkproject.dmg.pmml.time_series.SeasonalComponent;
import org.sparkproject.jpmml.model.annotations.Added;
import org.sparkproject.jpmml.model.annotations.CollectionElementType;
import org.sparkproject.jpmml.model.annotations.Property;

@XmlRootElement(name="ARIMA", namespace="http://www.dmg.org/PMML-4_4")
@XmlType(name="", propOrder={"extensions", "nonseasonalComponent", "seasonalComponent", "dynamicRegressors", "maximumLikelihoodStat", "outlierEffects"})
@JsonRootName(value="ARIMA")
@JsonPropertyOrder(value={"rmse", "transformation", "constantTerm", "predictionMethod", "extensions", "nonseasonalComponent", "seasonalComponent", "dynamicRegressors", "maximumLikelihoodStat", "outlierEffects"})
@Added(value=Version.PMML_4_0)
public class ARIMA
extends Algorithm
implements HasExtensions<ARIMA>,
HasDynamicRegressors<ARIMA> {
    @XmlAttribute(name="RMSE")
    @XmlJavaTypeAdapter(value=RealNumberAdapter.class)
    @JsonProperty(value="RMSE")
    @Added(value=Version.PMML_4_4)
    private Number rmse;
    @XmlAttribute(name="transformation")
    @JsonProperty(value="transformation")
    @Added(value=Version.PMML_4_4)
    private Transformation transformation;
    @XmlAttribute(name="constantTerm")
    @XmlJavaTypeAdapter(value=RealNumberAdapter.class)
    @JsonProperty(value="constantTerm")
    @Added(value=Version.PMML_4_4)
    private Number constantTerm;
    @XmlAttribute(name="predictionMethod")
    @JsonProperty(value="predictionMethod")
    @Added(value=Version.PMML_4_4)
    private PredictionMethod predictionMethod;
    @XmlElement(name="Extension", namespace="http://www.dmg.org/PMML-4_4")
    @JsonProperty(value="Extension")
    @Added(value=Version.PMML_4_4, removable=true)
    @CollectionElementType(value=Extension.class)
    private List<Extension> extensions;
    @XmlElement(name="NonseasonalComponent", namespace="http://www.dmg.org/PMML-4_4")
    @JsonProperty(value="NonseasonalComponent")
    @Added(value=Version.PMML_4_4)
    private NonseasonalComponent nonseasonalComponent;
    @XmlElement(name="SeasonalComponent", namespace="http://www.dmg.org/PMML-4_4")
    @JsonProperty(value="SeasonalComponent")
    @Added(value=Version.PMML_4_4)
    private SeasonalComponent seasonalComponent;
    @XmlElement(name="DynamicRegressor", namespace="http://www.dmg.org/PMML-4_4")
    @JsonProperty(value="DynamicRegressor")
    @Added(value=Version.PMML_4_4)
    @CollectionElementType(value=DynamicRegressor.class)
    private List<DynamicRegressor> dynamicRegressors;
    @XmlElement(name="MaximumLikelihoodStat", namespace="http://www.dmg.org/PMML-4_4")
    @JsonProperty(value="MaximumLikelihoodStat")
    @Added(value=Version.PMML_4_4)
    private MaximumLikelihoodStat maximumLikelihoodStat;
    @XmlElement(name="OutlierEffect", namespace="http://www.dmg.org/PMML-4_4")
    @JsonProperty(value="OutlierEffect")
    @Added(value=Version.PMML_4_4)
    @CollectionElementType(value=OutlierEffect.class)
    private List<OutlierEffect> outlierEffects;
    private static final Number DEFAULT_CONSTANT_TERM = new RealNumberAdapter().unmarshal("0");
    private static final long serialVersionUID = 67371272L;

    public Number getRMSE() {
        return this.rmse;
    }

    public ARIMA setRMSE(@Property(value="rmse") Number rmse) {
        this.rmse = rmse;
        return this;
    }

    public Transformation getTransformation() {
        if (this.transformation == null) {
            return Transformation.NONE;
        }
        return this.transformation;
    }

    public ARIMA setTransformation(@Property(value="transformation") Transformation transformation) {
        this.transformation = transformation;
        return this;
    }

    public Number getConstantTerm() {
        if (this.constantTerm == null) {
            return DEFAULT_CONSTANT_TERM;
        }
        return this.constantTerm;
    }

    public ARIMA setConstantTerm(@Property(value="constantTerm") Number constantTerm) {
        this.constantTerm = constantTerm;
        return this;
    }

    public PredictionMethod getPredictionMethod() {
        if (this.predictionMethod == null) {
            return PredictionMethod.CONDITIONAL_LEAST_SQUARES;
        }
        return this.predictionMethod;
    }

    public ARIMA setPredictionMethod(@Property(value="predictionMethod") PredictionMethod predictionMethod) {
        this.predictionMethod = predictionMethod;
        return this;
    }

    @Override
    public boolean hasExtensions() {
        return this.extensions != null && !this.extensions.isEmpty();
    }

    @Override
    public List<Extension> getExtensions() {
        if (this.extensions == null) {
            this.extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    @Override
    public ARIMA addExtensions(Extension ... extensions) {
        this.getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    public NonseasonalComponent getNonseasonalComponent() {
        return this.nonseasonalComponent;
    }

    public ARIMA setNonseasonalComponent(@Property(value="nonseasonalComponent") NonseasonalComponent nonseasonalComponent) {
        this.nonseasonalComponent = nonseasonalComponent;
        return this;
    }

    public SeasonalComponent getSeasonalComponent() {
        return this.seasonalComponent;
    }

    public ARIMA setSeasonalComponent(@Property(value="seasonalComponent") SeasonalComponent seasonalComponent) {
        this.seasonalComponent = seasonalComponent;
        return this;
    }

    @Override
    public boolean hasDynamicRegressors() {
        return this.dynamicRegressors != null && !this.dynamicRegressors.isEmpty();
    }

    @Override
    public List<DynamicRegressor> getDynamicRegressors() {
        if (this.dynamicRegressors == null) {
            this.dynamicRegressors = new ArrayList<DynamicRegressor>();
        }
        return this.dynamicRegressors;
    }

    @Override
    public ARIMA addDynamicRegressors(DynamicRegressor ... dynamicRegressors) {
        this.getDynamicRegressors().addAll(Arrays.asList(dynamicRegressors));
        return this;
    }

    public MaximumLikelihoodStat getMaximumLikelihoodStat() {
        return this.maximumLikelihoodStat;
    }

    public ARIMA setMaximumLikelihoodStat(@Property(value="maximumLikelihoodStat") MaximumLikelihoodStat maximumLikelihoodStat) {
        this.maximumLikelihoodStat = maximumLikelihoodStat;
        return this;
    }

    public boolean hasOutlierEffects() {
        return this.outlierEffects != null && !this.outlierEffects.isEmpty();
    }

    public List<OutlierEffect> getOutlierEffects() {
        if (this.outlierEffects == null) {
            this.outlierEffects = new ArrayList<OutlierEffect>();
        }
        return this.outlierEffects;
    }

    public ARIMA addOutlierEffects(OutlierEffect ... outlierEffects) {
        this.getOutlierEffects().addAll(Arrays.asList(outlierEffects));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if (status == VisitorAction.CONTINUE && this.hasExtensions()) {
                status = PMMLObject.traverse(visitor, this.getExtensions());
            }
            if (status == VisitorAction.CONTINUE) {
                status = PMMLObject.traverse(visitor, (Visitable)this.getNonseasonalComponent(), (Visitable)this.getSeasonalComponent());
            }
            if (status == VisitorAction.CONTINUE && this.hasDynamicRegressors()) {
                status = PMMLObject.traverse(visitor, this.getDynamicRegressors());
            }
            if (status == VisitorAction.CONTINUE) {
                status = PMMLObject.traverse(visitor, (Visitable)this.getMaximumLikelihoodStat());
            }
            if (status == VisitorAction.CONTINUE && this.hasOutlierEffects()) {
                status = PMMLObject.traverse(visitor, this.getOutlierEffects());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

    @XmlType(name="")
    @XmlEnum
    public static enum Transformation implements StringValue<Transformation>
    {
        NONE("none"),
        LOGARITHMIC("logarithmic"),
        SQUAREROOT("squareroot");

        private final String value;

        private Transformation(String v) {
            this.value = v;
        }

        @Override
        public String value() {
            return this.value;
        }

        public static Transformation fromValue(String v) {
            for (Transformation c : Transformation.values()) {
                if (!c.value.equals(v)) continue;
                return c;
            }
            throw new IllegalArgumentException(v);
        }

        public String toString() {
            return this.value();
        }
    }

    @XmlType(name="")
    @XmlEnum
    public static enum PredictionMethod implements StringValue<PredictionMethod>
    {
        CONDITIONAL_LEAST_SQUARES("conditionalLeastSquares"),
        EXACT_LEAST_SQUARES("exactLeastSquares");

        private final String value;

        private PredictionMethod(String v) {
            this.value = v;
        }

        @Override
        public String value() {
            return this.value;
        }

        public static PredictionMethod fromValue(String v) {
            for (PredictionMethod c : PredictionMethod.values()) {
                if (!c.value.equals(v)) continue;
                return c;
            }
            throw new IllegalArgumentException(v);
        }

        public String toString() {
            return this.value();
        }
    }
}

