/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.pipelines.graph;

import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeoutException;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.LogEntry$;
import org.apache.spark.internal.LogKey;
import org.apache.spark.internal.LogKeys;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.MDC;
import org.apache.spark.internal.MessageWithContext;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.pipelines.graph.DataflowGraph;
import org.apache.spark.sql.pipelines.graph.ExecutionResult;
import org.apache.spark.sql.pipelines.graph.ExecutionResult$FINISHED$;
import org.apache.spark.sql.pipelines.graph.ExecutionResult$STOPPED$;
import org.apache.spark.sql.pipelines.graph.Flow;
import org.apache.spark.sql.pipelines.graph.FlowExecution;
import org.apache.spark.sql.pipelines.graph.FlowPlanner;
import org.apache.spark.sql.pipelines.graph.GraphExecution$;
import org.apache.spark.sql.pipelines.graph.PipelineUpdateContext;
import org.apache.spark.sql.pipelines.graph.QueryExecutionFailure;
import org.apache.spark.sql.pipelines.graph.ResolvedFlow;
import org.apache.spark.sql.pipelines.graph.RunTerminationReason;
import org.apache.spark.sql.pipelines.logging.FlowProgressEventLogger;
import org.apache.spark.sql.pipelines.logging.StreamListener;
import org.apache.spark.sql.streaming.StreamingQueryListener;
import org.apache.spark.sql.streaming.Trigger;
import org.slf4j.Logger;
import org.slf4j.event.Level;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.StringContext;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.collection.concurrent.TrieMap;
import scala.collection.immutable.Seq;
import scala.concurrent.ExecutionContext;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.hashing.MurmurHash3$;

@ScalaSignature(bytes="\u0006\u0005\rEe!\u00023f\u0003\u0003\u0011\b\"C@\u0001\u0005\u000b\u0007I\u0011AA\u0001\u0011)\tY\u0001\u0001B\u0001B\u0003%\u00111\u0001\u0005\u000b\u0003\u001b\u0001!\u0011!Q\u0001\n\u0005=\u0001bBA\u000b\u0001\u0011\u0005\u0011q\u0003\u0005\b\u0003?\u0001a\u0011AA\u0011\u0011%\tI\u0004\u0001b\u0001\n\u0013\tY\u0004\u0003\u0005\u0002`\u0001\u0001\u000b\u0011BA\u001f\u0011%\t\t\u0007\u0001b\u0001\n\u0013\t\u0019\u0007\u0003\u0005\u0002n\u0001\u0001\u000b\u0011BA3\u0011%\ty\u0007\u0001b\u0001\n\u0003\t\t\b\u0003\u0005\u0002\u0000\u0001\u0001\u000b\u0011BA:\u0011\u001d\t\t\t\u0001C\u0005\u0003\u0007C\u0011\"a$\u0001\u0005\u0004%I!!%\t\u0011\u0005e\u0005\u0001)A\u0005\u0003'C\u0011\"a'\u0001\u0005\u0004%I!!(\t\u0011\u0005-\u0006\u0001)A\u0005\u0003?Cq!!,\u0001\t\u0003\ty\u000bC\u0004\u0002@\u0002!\t!!1\t\u000f\u0005\r\u0007\u0001\"\u0001\u0002B\"9\u0011Q\u0019\u0001\u0005\u0002\u0005\u001d\u0007bBAg\u0001\u0019\u0005\u0011\u0011\u0019\u0005\b\u0003\u001f\u0004a\u0011AAi\u0011\u001d\tI\u000e\u0001C\u0001\u00037Dq!!9\u0001\t\u0003\t\u0019oB\u0004\u0002z\u0016D\t!a?\u0007\r\u0011,\u0007\u0012AA\u007f\u0011\u001d\t)B\u0007C\u0001\u0003\u007f4\u0011B!\u0001\u001b!\u0003\r\nCa\u0001\b\u000f\r\u0015\"\u0004#!\u00030\u00199!q\u0001\u000e\t\u0002\n%\u0001bBA\u000b=\u0011\u0005!Q\u0006\u0005\n\u0005cq\u0012\u0011!C!\u0005gA\u0011Ba\u000f\u001f\u0003\u0003%\tA!\u0010\t\u0013\t}b$!A\u0005\u0002\t\u0005\u0003\"\u0003B'=\u0005\u0005I\u0011\tB(\u0011%\u0011IFHA\u0001\n\u0003\u0011Y\u0006C\u0005\u0003fy\t\t\u0011\"\u0011\u0003h!I!\u0011\u000e\u0010\u0002\u0002\u0013\u0005#1\u000e\u0005\n\u0005[r\u0012\u0011!C\u0005\u0005_2aAa\u001e\u001b\u0001\ne\u0004B\u0003B>Q\tU\r\u0011\"\u0001\u0003~!Q1Q\u0001\u0015\u0003\u0012\u0003\u0006IAa \t\u000f\u0005U\u0001\u0006\"\u0001\u0004\b!I!1\u0019\u0015\u0002\u0002\u0013\u00051Q\u0002\u0005\n\u0005\u001bD\u0013\u0013!C\u0001\u0007#A\u0011B!\r)\u0003\u0003%\tEa\r\t\u0013\tm\u0002&!A\u0005\u0002\tu\u0002\"\u0003B Q\u0005\u0005I\u0011AB\u000b\u0011%\u0011i\u0005KA\u0001\n\u0003\u0012y\u0005C\u0005\u0003Z!\n\t\u0011\"\u0001\u0004\u001a!I!\u0011 \u0015\u0002\u0002\u0013\u00053Q\u0004\u0005\n\u0005KB\u0013\u0011!C!\u0005OB\u0011B!\u001b)\u0003\u0003%\tEa\u001b\t\u0013\t}\b&!A\u0005B\r\u0005r!CB\u00145\u0005\u0005\t\u0012AB\u0015\r%\u00119HGA\u0001\u0012\u0003\u0019Y\u0003C\u0004\u0002\u0016a\"\taa\u0011\t\u0013\t%\u0004(!A\u0005F\t-\u0004\"CB#q\u0005\u0005I\u0011QB$\u0011%\u0019Y\u0005OA\u0001\n\u0003\u001bi\u0005C\u0005\u0003na\n\t\u0011\"\u0003\u0003p\u0019I!\u0011\u0011\u000e\u0011\u0002\u0007\u0005\"1\u0011\u0005\b\u0005\u000bsD\u0011AAa\u0011\u001d\u00119I\u0010D\u0001\u0005\u0013CqA!%?\r\u0003\u0011\u0019\nC\u0004\u0003$z2\t!!5\t\u000f\t\u0015fH\"\u0001\u0003\u0014\"9!q\u0015 \u0005\u0002\t%fA\u0002BW5\u0011\u0013y\u000b\u0003\u0006\u0003\b\u0016\u0013)\u001a!C\u0001\u0005\u0013C!B!-F\u0005#\u0005\u000b\u0011\u0002BF\u0011)\u0011\t*\u0012BK\u0002\u0013\u0005!1\u0013\u0005\u000b\u0005g+%\u0011#Q\u0001\n\tU\u0005B\u0003B[\u000b\nU\r\u0011\"\u0001\u0003>!Q!qW#\u0003\u0012\u0003\u0006I!!\u0017\t\u000f\u0005UQ\t\"\u0001\u0003:\"Q!1U#\t\u0006\u0004%\t%!5\t\u0015\t\u0015V\t#b\u0001\n\u0003\u0012\u0019\nC\u0005\u0003D\u0016\u000b\t\u0011\"\u0001\u0003F\"I!QZ#\u0012\u0002\u0013\u0005!q\u001a\u0005\n\u0005K,\u0015\u0013!C\u0001\u0005OD\u0011Ba;F#\u0003%\tA!<\t\u0013\tER)!A\u0005B\tM\u0002\"\u0003B\u001e\u000b\u0006\u0005I\u0011\u0001B\u001f\u0011%\u0011y$RA\u0001\n\u0003\u0011\t\u0010C\u0005\u0003N\u0015\u000b\t\u0011\"\u0011\u0003P!I!\u0011L#\u0002\u0002\u0013\u0005!Q\u001f\u0005\n\u0005s,\u0015\u0011!C!\u0005wD\u0011B!\u001aF\u0003\u0003%\tEa\u001a\t\u0013\t%T)!A\u0005B\t-\u0004\"\u0003B\u0000\u000b\u0006\u0005I\u0011IB\u0001\u000f%\u0019)FGA\u0001\u0012\u0013\u00199FB\u0005\u0003.j\t\t\u0011#\u0003\u0004Z!9\u0011QC/\u0005\u0002\r\u0005\u0004\"\u0003B5;\u0006\u0005IQ\tB6\u0011%\u0019)%XA\u0001\n\u0003\u001b\u0019\u0007C\u0005\u0004Lu\u000b\t\u0011\"!\u0004l!I!QN/\u0002\u0002\u0013%!q\u000e\u0005\b\u0007oRB\u0011AB=\u000599%/\u00199i\u000bb,7-\u001e;j_:T!AZ4\u0002\u000b\u001d\u0014\u0018\r\u001d5\u000b\u0005!L\u0017!\u00039ja\u0016d\u0017N\\3t\u0015\tQ7.A\u0002tc2T!\u0001\\7\u0002\u000bM\u0004\u0018M]6\u000b\u00059|\u0017AB1qC\u000eDWMC\u0001q\u0003\ry'oZ\u0002\u0001'\r\u00011/\u001f\t\u0003i^l\u0011!\u001e\u0006\u0002m\u0006)1oY1mC&\u0011\u00010\u001e\u0002\u0007\u0003:L(+\u001a4\u0011\u0005ilX\"A>\u000b\u0005q\\\u0017\u0001C5oi\u0016\u0014h.\u00197\n\u0005y\\(a\u0002'pO\u001eLgnZ\u0001\u0012OJ\f\u0007\u000f\u001b$pe\u0016CXmY;uS>tWCAA\u0002!\u0011\t)!a\u0002\u000e\u0003\u0015L1!!\u0003f\u00055!\u0015\r^1gY><xI]1qQ\u0006\u0011rM]1qQ\u001a{'/\u0012=fGV$\u0018n\u001c8!\u0003\r)gN\u001e\t\u0005\u0003\u000b\t\t\"C\u0002\u0002\u0014\u0015\u0014Q\u0003U5qK2Lg.Z+qI\u0006$XmQ8oi\u0016DH/\u0001\u0004=S:LGO\u0010\u000b\u0007\u00033\tY\"!\b\u0011\u0007\u0005\u0015\u0001\u0001\u0003\u0004\u0000\t\u0001\u0007\u00111\u0001\u0005\b\u0003\u001b!\u0001\u0019AA\b\u00035\u0019HO]3b[R\u0013\u0018nZ4feR!\u00111EA\u0018!\u0011\t)#a\u000b\u000e\u0005\u0005\u001d\"bAA\u0015S\u0006I1\u000f\u001e:fC6LgnZ\u0005\u0005\u0003[\t9CA\u0004Ue&<w-\u001a:\t\u000f\u0005ER\u00011\u0001\u00024\u0005!a\r\\8x!\u0011\t)!!\u000e\n\u0007\u0005]RM\u0001\u0003GY><\u0018a\u00074m_^$vNT;n\u0007>t7/Z2vi&4XMR1jYV\u0014X-\u0006\u0002\u0002>AA\u0011qHA%\u0003\u001b\nI&\u0004\u0002\u0002B)!\u00111IA#\u0003)\u0019wN\\2veJ,g\u000e\u001e\u0006\u0004\u0003\u000f*\u0018AC2pY2,7\r^5p]&!\u00111JA!\u0005\ri\u0015\r\u001d\t\u0005\u0003\u001f\n)&\u0004\u0002\u0002R)\u0019\u00111K5\u0002\u0011\r\fG/\u00197zgRLA!a\u0016\u0002R\tyA+\u00192mK&#WM\u001c;jM&,'\u000fE\u0002u\u00037J1!!\u0018v\u0005\rIe\u000e^\u0001\u001dM2|w\u000fV8Ok6\u001cuN\\:fGV$\u0018N^3GC&dWO]3!\u0003A1Gn\\<U_:+XnU;dG\u0016\u001c8/\u0006\u0002\u0002fAA\u0011qHA%\u0003\u001b\n9\u0007E\u0002u\u0003SJ1!a\u001bv\u0005\u0011auN\\4\u0002#\u0019dwn\u001e+p\u001dVl7+^2dKN\u001c\b%\u0001\bgY><X\t_3dkRLwN\\:\u0016\u0005\u0005M\u0004\u0003CA \u0003k\ni%!\u001f\n\t\u0005]\u0014\u0011\t\u0002\b)JLW-T1q!\u0011\t)!a\u001f\n\u0007\u0005uTMA\u0007GY><X\t_3dkRLwN\\\u0001\u0010M2|w/\u0012=fGV$\u0018n\u001c8tA\u0005!\u0013N\\2sK6,g\u000e\u001e$m_^$vNT;n\u0007>t7/Z2vi&4XMR1jYV\u0014X\r\u0006\u0003\u0002\u0006\u0006-\u0005c\u0001;\u0002\b&\u0019\u0011\u0011R;\u0003\tUs\u0017\u000e\u001e\u0005\b\u0003\u001bc\u0001\u0019AA'\u000391Gn\\<JI\u0016tG/\u001b4jKJ\f1B\u001a7poBc\u0017M\u001c8feV\u0011\u00111\u0013\t\u0005\u0003\u000b\t)*C\u0002\u0002\u0018\u0016\u00141B\u00127poBc\u0017M\u001c8fe\u0006aa\r\\8x!2\fgN\\3sA\u0005q1\u000f\u001e:fC6d\u0015n\u001d;f]\u0016\u0014XCAAP!\u0011\t\t+a*\u000e\u0005\u0005\r&bAASO\u00069An\\4hS:<\u0017\u0002BAU\u0003G\u0013ab\u0015;sK\u0006lG*[:uK:,'/A\btiJ,\u0017-\u001c'jgR,g.\u001a:!\u0003A\u0001H.\u00198B]\u0012\u001cF/\u0019:u\r2|w\u000f\u0006\u0003\u00022\u0006]\u0006#\u0002;\u00024\u0006e\u0014bAA[k\n1q\n\u001d;j_:Dq!!\r\u0012\u0001\u0004\tI\f\u0005\u0003\u0002\u0006\u0005m\u0016bAA_K\na!+Z:pYZ,GM\u00127po\u0006)1\u000f^1siR\u0011\u0011QQ\u0001\u0005gR|\u0007/\u0001\u0005ti>\u0004h\t\\8x)\u0011\t))!3\t\u000f\u0005-G\u00031\u0001\u0002z\u0005\u0011\u0001OZ\u0001\u0010C^\f\u0017\u000e^\"p[BdW\r^5p]\u00069r-\u001a;Sk:$VM]7j]\u0006$\u0018n\u001c8SK\u0006\u001cxN\\\u000b\u0003\u0003'\u0004B!!\u0002\u0002V&\u0019\u0011q[3\u0003)I+h\u000eV3s[&t\u0017\r^5p]J+\u0017m]8o\u0003]i\u0017\r\u001f*fiJL\u0018\t\u001e;f[B$8OR8s\r2|w\u000f\u0006\u0003\u0002Z\u0005u\u0007bBAp/\u0001\u0007\u0011QJ\u0001\tM2|wOT1nK\u0006Q1\u000f^8q)\"\u0014X-\u00193\u0015\t\u0005\u0015\u0015Q\u001d\u0005\b\u0003OD\u0002\u0019AAu\u0003\u0019!\bN]3bIB!\u00111^A{\u001b\t\tiO\u0003\u0003\u0002p\u0006E\u0018\u0001\u00027b]\u001eT!!a=\u0002\t)\fg/Y\u0005\u0005\u0003o\fiO\u0001\u0004UQJ,\u0017\rZ\u0001\u000f\u000fJ\f\u0007\u000f[#yK\u000e,H/[8o!\r\t)AG\n\u00045MLHCAA~\u0005M1En\\<Fq\u0016\u001cW\u000f^5p]\u0006\u001bG/[8o'\ta2/K\u0002\u001d=!\u0012!CU3uef4En\\<Fq\u0016\u001cW\u000f^5p]NAad\u001dB\u0006\u0005\u001f\u0011)\u0002E\u0002\u0003\u000eqi\u0011A\u0007\t\u0004i\nE\u0011b\u0001B\nk\n9\u0001K]8ek\u000e$\b\u0003\u0002B\f\u0005OqAA!\u0007\u0003$9!!1\u0004B\u0011\u001b\t\u0011iBC\u0002\u0003 E\fa\u0001\u0010:p_Rt\u0014\"\u0001<\n\u0007\t\u0015R/A\u0004qC\u000e\\\u0017mZ3\n\t\t%\"1\u0006\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u0006\u0004\u0005K)HC\u0001B\u0018!\r\u0011iAH\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0005\tU\u0002\u0003BAv\u0005oIAA!\u000f\u0002n\n11\u000b\u001e:j]\u001e\fA\u0002\u001d:pIV\u001cG/\u0011:jif,\"!!\u0017\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR!!1\tB%!\r!(QI\u0005\u0004\u0005\u000f*(aA!os\"I!1\n\u0012\u0002\u0002\u0003\u0007\u0011\u0011L\u0001\u0004q\u0012\n\u0014a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\tE\u0003C\u0002B*\u0005+\u0012\u0019%\u0004\u0002\u0002F%!!qKA#\u0005!IE/\u001a:bi>\u0014\u0018\u0001C2b]\u0016\u000bX/\u00197\u0015\t\tu#1\r\t\u0004i\n}\u0013b\u0001B1k\n9!i\\8mK\u0006t\u0007\"\u0003B&I\u0005\u0005\t\u0019\u0001B\"\u0003!A\u0017m\u001d5D_\u0012,GCAA-\u0003!!xn\u0015;sS:<GC\u0001B\u001b\u000319(/\u001b;f%\u0016\u0004H.Y2f)\t\u0011\t\b\u0005\u0003\u0002l\nM\u0014\u0002\u0002B;\u0003[\u0014aa\u00142kK\u000e$(!E*u_B4En\\<Fq\u0016\u001cW\u000f^5p]NA\u0001f\u001dB\u0006\u0005\u001f\u0011)\"\u0001\u0004sK\u0006\u001cxN\\\u000b\u0003\u0005\u007f\u00022A!\u0004?\u0005]1En\\<Fq\u0016\u001cW\u000f^5p]N#x\u000e\u001d*fCN|gn\u0005\u0002?g\u00061A%\u001b8ji\u0012\nQaY1vg\u0016,\"Aa#\u0011\t\t]!QR\u0005\u0005\u0005\u001f\u0013YCA\u0005UQJ|w/\u00192mK\u0006ya\r\\8x\t&\u001c\b\u000f\\1z\u001d\u0006lW-\u0006\u0002\u0003\u0016B!!q\u0013BP\u001d\u0011\u0011IJa'\u0011\u0007\tmQ/C\u0002\u0003\u001eV\fa\u0001\u0015:fI\u00164\u0017\u0002\u0002B\u001d\u0005CS1A!(v\u0003Q\u0011XO\u001c+fe6Lg.\u0019;j_:\u0014V-Y:p]\u0006qa-Y5mkJ,W*Z:tC\u001e,\u0017AE<be:Len\u001d;fC\u0012|e-\u0012:s_J,\"A!\u0018*\u0005y*%\u0001E'bqJ+GO]=Fq\u000e,W\rZ3e'!)5Oa \u0003\u0010\tU\u0011AB2bkN,\u0007%\u0001\tgY><H)[:qY\u0006Lh*Y7fA\u0005\tR.\u0019=BY2|w/\u001a3SKR\u0014\u0018.Z:\u0002%5\f\u00070\u00117m_^,GMU3ue&,7\u000f\t\u000b\t\u0005w\u0013iLa0\u0003BB\u0019!QB#\t\u000f\t\u001dE\n1\u0001\u0003\f\"9!\u0011\u0013'A\u0002\tU\u0005b\u0002B[\u0019\u0002\u0007\u0011\u0011L\u0001\u0005G>\u0004\u0018\u0010\u0006\u0005\u0003<\n\u001d'\u0011\u001aBf\u0011%\u00119i\u0014I\u0001\u0002\u0004\u0011Y\tC\u0005\u0003\u0012>\u0003\n\u00111\u0001\u0003\u0016\"I!QW(\u0011\u0002\u0003\u0007\u0011\u0011L\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\u0011\tN\u000b\u0003\u0003\f\nM7F\u0001Bk!\u0011\u00119N!9\u000e\u0005\te'\u0002\u0002Bn\u0005;\f\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\t}W/\u0001\u0006b]:|G/\u0019;j_:LAAa9\u0003Z\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%eU\u0011!\u0011\u001e\u0016\u0005\u0005+\u0013\u0019.\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u001a\u0016\u0005\t=(\u0006BA-\u0005'$BAa\u0011\u0003t\"I!1J+\u0002\u0002\u0003\u0007\u0011\u0011\f\u000b\u0005\u0005;\u00129\u0010C\u0005\u0003L]\u000b\t\u00111\u0001\u0003D\u0005\u0011\u0002O]8ek\u000e$X\t\\3nK:$h*Y7f)\u0011\u0011)D!@\t\u0013\t-\u0003,!AA\u0002\u0005e\u0013AB3rk\u0006d7\u000f\u0006\u0003\u0003^\r\r\u0001\"\u0003B&7\u0006\u0005\t\u0019\u0001B\"\u0003\u001d\u0011X-Y:p]\u0002\"Ba!\u0003\u0004\fA\u0019!Q\u0002\u0015\t\u000f\tm4\u00061\u0001\u0003\u0000Q!1\u0011BB\b\u0011%\u0011Y\b\fI\u0001\u0002\u0004\u0011y(\u0006\u0002\u0004\u0014)\"!q\u0010Bj)\u0011\u0011\u0019ea\u0006\t\u0013\t-\u0003'!AA\u0002\u0005eC\u0003\u0002B/\u00077A\u0011Ba\u00133\u0003\u0003\u0005\rAa\u0011\u0015\t\tU2q\u0004\u0005\n\u0005\u0017\u001a\u0014\u0011!a\u0001\u00033\"BA!\u0018\u0004$!I!1\n\u001c\u0002\u0002\u0003\u0007!1I\u0001\u0013%\u0016$(/\u001f$m_^,\u00050Z2vi&|g.A\tTi>\u0004h\t\\8x\u000bb,7-\u001e;j_:\u00042A!\u00049'\u0015A4QFB\u001d!!\u0019yc!\u000e\u0003\u0000\r%QBAB\u0019\u0015\r\u0019\u0019$^\u0001\beVtG/[7f\u0013\u0011\u00199d!\r\u0003#\u0005\u00137\u000f\u001e:bGR4UO\\2uS>t\u0017\u0007\u0005\u0003\u0004<\r\u0005SBAB\u001f\u0015\u0011\u0019y$!=\u0002\u0005%|\u0017\u0002\u0002B\u0015\u0007{!\"a!\u000b\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\t\r%1\u0011\n\u0005\b\u0005wZ\u0004\u0019\u0001B@\u0003\u001d)h.\u00199qYf$Baa\u0014\u0004RA)A/a-\u0003\u0000!I11\u000b\u001f\u0002\u0002\u0003\u00071\u0011B\u0001\u0004q\u0012\u0002\u0014\u0001E'bqJ+GO]=Fq\u000e,W\rZ3e!\r\u0011i!X\n\u0006;\u000em3\u0011\b\t\r\u0007_\u0019iFa#\u0003\u0016\u0006e#1X\u0005\u0005\u0007?\u001a\tDA\tBEN$(/Y2u\rVt7\r^5p]N\"\"aa\u0016\u0015\u0011\tm6QMB4\u0007SBqAa\"a\u0001\u0004\u0011Y\tC\u0004\u0003\u0012\u0002\u0004\rA!&\t\u000f\tU\u0006\r1\u0001\u0002ZQ!1QNB;!\u0015!\u00181WB8!%!8\u0011\u000fBF\u0005+\u000bI&C\u0002\u0004tU\u0014a\u0001V;qY\u0016\u001c\u0004\"CB*C\u0006\u0005\t\u0019\u0001B^\u0003\u0015\"W\r^3s[&tWM\u00127po\u0016CXmY;uS>t\u0017i\u0019;j_:4%o\\7FeJ|'\u000f\u0006\u0006\u0003\f\rm4QQBE\u0007\u001fC\u0001b! d\t\u0003\u00071qP\u0001\u0003Kb\u0004R\u0001^BA\u0005\u0017K1aa!v\u0005!a$-\u001f8b[\u0016t\u0004\u0002\u0003BIG\u0012\u0005\raa\"\u0011\u000bQ\u001c\tI!&\t\u0011\r-5\r\"a\u0001\u0007\u001b\u000bqbY;se\u0016tGOT;n)JLWm\u001d\t\u0006i\u000e\u0005\u0015\u0011\f\u0005\t\u0005k\u001bG\u00111\u0001\u0004\u000e\u0002")
public abstract class GraphExecution
implements Logging {
    private final DataflowGraph graphForExecution;
    private final PipelineUpdateContext env;
    private final scala.collection.concurrent.Map<TableIdentifier, Object> flowToNumConsecutiveFailure;
    private final scala.collection.concurrent.Map<TableIdentifier, Object> flowToNumSuccess;
    private final TrieMap<TableIdentifier, FlowExecution> flowExecutions;
    private final FlowPlanner flowPlanner;
    private final StreamListener streamListener;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static FlowExecutionAction determineFlowExecutionActionFromError(Function0<Throwable> ex, Function0<String> flowDisplayName, Function0<Object> currentNumTries, Function0<Object> maxAllowedRetries) {
        return GraphExecution$.MODULE$.determineFlowExecutionActionFromError(ex, flowDisplayName, currentNumTries, maxAllowedRetries);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(Map<String, String> context, Function0<BoxedUnit> body) {
        Logging.withLogContext$((Logging)this, context, body);
    }

    public MDC MDC(LogKey key, Object value) {
        return Logging.MDC$((Logging)this, (LogKey)key, (Object)value);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void logBasedOnLevel(Level level, Function0<MessageWithContext> f) {
        Logging.logBasedOnLevel$((Logging)this, (Level)level, f);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public DataflowGraph graphForExecution() {
        return this.graphForExecution;
    }

    public abstract Trigger streamTrigger(Flow var1);

    private scala.collection.concurrent.Map<TableIdentifier, Object> flowToNumConsecutiveFailure() {
        return this.flowToNumConsecutiveFailure;
    }

    private scala.collection.concurrent.Map<TableIdentifier, Object> flowToNumSuccess() {
        return this.flowToNumSuccess;
    }

    public TrieMap<TableIdentifier, FlowExecution> flowExecutions() {
        return this.flowExecutions;
    }

    private void incrementFlowToNumConsecutiveFailure(TableIdentifier flowIdentifier) {
        this.flowToNumConsecutiveFailure().updateWith((Object)flowIdentifier, (Function1 & Serializable)x0$1 -> {
            Option option = x0$1;
            if (option instanceof Some) {
                Some some = (Some)option;
                int count = BoxesRunTime.unboxToInt((Object)some.value());
                return new Some((Object)BoxesRunTime.boxToInteger((int)(count + 1)));
            }
            if (None$.MODULE$.equals(option)) {
                return new Some((Object)BoxesRunTime.boxToInteger((int)1));
            }
            throw new MatchError((Object)option);
        });
    }

    private FlowPlanner flowPlanner() {
        return this.flowPlanner;
    }

    private StreamListener streamListener() {
        return this.streamListener;
    }

    public Option<FlowExecution> planAndStartFlow(ResolvedFlow flow) {
        Option option;
        try {
            FlowExecution flowExecution = this.flowPlanner().plan((ResolvedFlow)this.graphForExecution().resolvedFlow().apply((Object)flow.identifier()));
            this.env.flowProgressEventLogger().recordStart(flowExecution);
            flowExecution.executeAsync();
            this.flowExecutions().put((Object)flow.identifier(), (Object)flowExecution);
            ExecutionContext ec = flowExecution.executionContext();
            flowExecution.getFuture().onComplete((Function1 & Serializable)x0$1 -> {
                GraphExecution.$anonfun$planAndStartFlow$1(this, flowExecution, flow, x0$1);
                return BoxedUnit.UNIT;
            }, ec);
            option = Option$.MODULE$.apply((Object)flowExecution);
        }
        catch (Throwable ex) {
            this.logError(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Unhandled exception while starting flow:", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{this.MDC((LogKey)LogKeys.FLOW_NAME, flow.displayName())}))), ex);
            if (ex instanceof InterruptedException) {
                FlowProgressEventLogger qual$2 = this.env.flowProgressEventLogger();
                ResolvedFlow x$5 = flow;
                Option<String> x$6 = qual$2.recordStop$default$2();
                Option<Throwable> x$7 = qual$2.recordStop$default$3();
                qual$2.recordStop(x$5, x$6, x$7);
            } else {
                FlowProgressEventLogger qual$3 = this.env.flowProgressEventLogger();
                ResolvedFlow x$8 = flow;
                Throwable x$9 = ex;
                boolean x$10 = false;
                Option<String> x$11 = qual$3.recordFailed$default$4();
                qual$3.recordFailed(x$8, x$9, false, x$11);
            }
            throw ex;
        }
        return option;
    }

    public void start() {
        this.env.spark().listenerManager().clear();
        this.env.spark().streams().addListener((StreamingQueryListener)this.streamListener());
    }

    public void stop() {
        this.env.spark().streams().removeListener((StreamingQueryListener)this.streamListener());
    }

    public void stopFlow(FlowExecution pf) {
        if (!pf.isCompleted()) {
            ResolvedFlow flow = (ResolvedFlow)this.graphForExecution().resolvedFlow().apply((Object)pf.identifier());
            try {
                this.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Stopping ", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{this.MDC((LogKey)LogKeys.FLOW_NAME, pf.identifier())}))));
                pf.stop();
            }
            catch (Throwable e) {
                String message = "Error stopping flow " + pf.identifier();
                this.logError((Function0<String>)(Function0 & Serializable)() -> message, e);
                this.env.flowProgressEventLogger().recordFailed(flow, e, false, (Option<String>)Option$.MODULE$.apply((Object)("Flow '" + pf.displayName() + "' has failed to stop.")));
                throw e;
            }
            FlowProgressEventLogger qual$1 = this.env.flowProgressEventLogger();
            ResolvedFlow x$1 = flow;
            Option<String> x$2 = qual$1.recordStop$default$2();
            Option<Throwable> x$3 = qual$1.recordStop$default$3();
            qual$1.recordStop(x$1, x$2, x$3);
            this.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Stopped ", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{this.MDC((LogKey)LogKeys.FLOW_NAME, pf.identifier())}))));
            return;
        }
        this.logWarning(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Flow ", " was not stopped because it "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{this.MDC((LogKey)LogKeys.FLOW_NAME, pf.identifier())})).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"was already completed. Exception: ", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{this.MDC((LogKey)LogKeys.EXCEPTION, pf.exception())})))));
    }

    public abstract void awaitCompletion();

    public abstract RunTerminationReason getRunTerminationReason();

    public int maxRetryAttemptsForFlow(TableIdentifier flowName) {
        Flow flow = (Flow)this.graphForExecution().flow().apply((Object)flowName);
        return BoxesRunTime.unboxToInt((Object)flow.sqlConf().get((Object)SQLConf$.MODULE$.PIPELINES_MAX_FLOW_RETRY_ATTEMPTS().key()).map((Function1 & Serializable)x$1 -> BoxesRunTime.boxToInteger((int)StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(x$1)))).getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> $this.env.spark().sessionState().conf().maxFlowRetryAttempts()));
    }

    public void stopThread(Thread thread) {
        if (thread.getId() != Thread.currentThread().getId()) {
            thread.join(this.env.spark().sessionState().conf().timeoutMsForTerminationJoinAndLock());
            if (thread.isAlive()) {
                throw new TimeoutException("Failed to stop the update due to a hanging control thread.");
            }
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$planAndStartFlow$1(GraphExecution $this, FlowExecution flowExecution$1, ResolvedFlow flow$1, Try x0$1) {
        ExecutionResult executionResult;
        boolean bl = false;
        Success success = null;
        Try try_ = x0$1;
        if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable ex = failure.exception();
            if (!flowExecution$1.isStreaming()) {
                $this.incrementFlowToNumConsecutiveFailure(flow$1.identifier());
                FlowProgressEventLogger qual$1 = $this.env.flowProgressEventLogger();
                ResolvedFlow x$1 = flow$1;
                Throwable x$2 = ex;
                boolean x$3 = BoxesRunTime.unboxToInt((Object)$this.flowToNumConsecutiveFailure().apply((Object)flow$1.identifier())) < 1 + $this.maxRetryAttemptsForFlow(flow$1.identifier());
                Option<String> x$4 = qual$1.recordFailed$default$4();
                qual$1.recordFailed(x$1, x$2, x$3, x$4);
                return;
            }
        }
        if (try_ instanceof Success) {
            bl = true;
            success = (Success)try_;
            ExecutionResult executionResult2 = (ExecutionResult)success.value();
            if (ExecutionResult$STOPPED$.MODULE$.equals(executionResult2)) {
                return;
            }
        }
        if (bl && ExecutionResult$FINISHED$.MODULE$.equals(executionResult = (ExecutionResult)success.value()) && !flowExecution$1.isStreaming()) {
            $this.flowToNumConsecutiveFailure().put((Object)flow$1.identifier(), (Object)BoxesRunTime.boxToInteger((int)0));
            $this.flowToNumSuccess().put((Object)flow$1.identifier(), (Object)BoxesRunTime.boxToLong((long)(BoxesRunTime.unboxToLong((Object)$this.flowToNumSuccess().getOrElse((Object)flow$1.identifier(), (Function0)(JFunction0.mcJ.sp & Serializable)() -> 0L)) + 1L)));
            $this.env.flowProgressEventLogger().recordCompletion(flow$1);
            return;
        }
    }

    public GraphExecution(DataflowGraph graphForExecution, PipelineUpdateContext env) {
        this.graphForExecution = graphForExecution;
        this.env = env;
        Logging.$init$((Logging)this);
        this.flowToNumConsecutiveFailure = CollectionConverters$.MODULE$.ConcurrentMapHasAsScala(new ConcurrentHashMap()).asScala();
        this.flowToNumSuccess = CollectionConverters$.MODULE$.ConcurrentMapHasAsScala(new ConcurrentHashMap()).asScala();
        this.flowExecutions = new TrieMap();
        this.flowPlanner = new FlowPlanner(graphForExecution, env, (Function1<Flow, Trigger>)(Function1 & Serializable)flow -> this.streamTrigger((Flow)flow));
        this.streamListener = new StreamListener(env, graphForExecution);
    }

    public static interface FlowExecutionAction {
    }

    public static interface FlowExecutionStopReason {
        public Throwable cause();

        public String flowDisplayName();

        public RunTerminationReason runTerminationReason();

        public String failureMessage();

        default public boolean warnInsteadOfError() {
            return false;
        }

        public static void $init$(FlowExecutionStopReason $this) {
        }
    }

    private static class MaxRetryExceeded
    implements FlowExecutionStopReason,
    Product,
    Serializable {
        private RunTerminationReason runTerminationReason;
        private String failureMessage;
        private final Throwable cause;
        private final String flowDisplayName;
        private final int maxAllowedRetries;
        private volatile byte bitmap$0;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        @Override
        public boolean warnInsteadOfError() {
            return ((FlowExecutionStopReason)this).warnInsteadOfError();
        }

        @Override
        public Throwable cause() {
            return this.cause;
        }

        @Override
        public String flowDisplayName() {
            return this.flowDisplayName;
        }

        public int maxAllowedRetries() {
            return this.maxAllowedRetries;
        }

        private RunTerminationReason runTerminationReason$lzycompute() {
            MaxRetryExceeded maxRetryExceeded = this;
            synchronized (maxRetryExceeded) {
                if ((byte)(this.bitmap$0 & 1) == 0) {
                    this.runTerminationReason = new QueryExecutionFailure(this.flowDisplayName(), this.maxAllowedRetries(), (Option<Throwable>)Option$.MODULE$.apply((Object)this.cause()));
                    this.bitmap$0 = (byte)(this.bitmap$0 | 1);
                }
            }
            return this.runTerminationReason;
        }

        @Override
        public RunTerminationReason runTerminationReason() {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                return this.runTerminationReason$lzycompute();
            }
            return this.runTerminationReason;
        }

        private String failureMessage$lzycompute() {
            MaxRetryExceeded maxRetryExceeded = this;
            synchronized (maxRetryExceeded) {
                if ((byte)(this.bitmap$0 & 2) == 0) {
                    this.failureMessage = "Flow '" + this.flowDisplayName() + "' has FAILED more than " + this.maxAllowedRetries() + " times and will not be restarted.";
                    this.bitmap$0 = (byte)(this.bitmap$0 | 2);
                }
            }
            return this.failureMessage;
        }

        @Override
        public String failureMessage() {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                return this.failureMessage$lzycompute();
            }
            return this.failureMessage;
        }

        public MaxRetryExceeded copy(Throwable cause, String flowDisplayName, int maxAllowedRetries) {
            return new MaxRetryExceeded(cause, flowDisplayName, maxAllowedRetries);
        }

        public Throwable copy$default$1() {
            return this.cause();
        }

        public String copy$default$2() {
            return this.flowDisplayName();
        }

        public int copy$default$3() {
            return this.maxAllowedRetries();
        }

        public String productPrefix() {
            return "MaxRetryExceeded";
        }

        public int productArity() {
            return 3;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return this.cause();
                }
                case 1: {
                    return this.flowDisplayName();
                }
                case 2: {
                    return BoxesRunTime.boxToInteger((int)this.maxAllowedRetries());
                }
            }
            return Statics.ioobe((int)x$1);
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof MaxRetryExceeded;
        }

        public String productElementName(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return "cause";
                }
                case 1: {
                    return "flowDisplayName";
                }
                case 2: {
                    return "maxAllowedRetries";
                }
            }
            return (String)Statics.ioobe((int)x$1);
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)50398007);
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.cause()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.flowDisplayName()));
            n = Statics.mix((int)n, (int)this.maxAllowedRetries());
            return Statics.finalizeHash((int)n, (int)3);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof MaxRetryExceeded)) return false;
            boolean bl = true;
            if (!bl) return false;
            MaxRetryExceeded maxRetryExceeded = (MaxRetryExceeded)x$1;
            if (this.maxAllowedRetries() != maxRetryExceeded.maxAllowedRetries()) return false;
            Throwable throwable = this.cause();
            Throwable throwable2 = maxRetryExceeded.cause();
            if (throwable == null) {
                if (throwable2 != null) {
                    return false;
                }
            } else if (!throwable.equals(throwable2)) return false;
            String string = this.flowDisplayName();
            String string2 = maxRetryExceeded.flowDisplayName();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            if (!maxRetryExceeded.canEqual(this)) return false;
            return true;
        }

        public MaxRetryExceeded(Throwable cause, String flowDisplayName, int maxAllowedRetries) {
            this.cause = cause;
            this.flowDisplayName = flowDisplayName;
            this.maxAllowedRetries = maxAllowedRetries;
            FlowExecutionStopReason.$init$(this);
            Product.$init$((Product)this);
        }
    }

    public static class StopFlowExecution
    implements FlowExecutionAction,
    Product,
    Serializable {
        private final FlowExecutionStopReason reason;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public FlowExecutionStopReason reason() {
            return this.reason;
        }

        public StopFlowExecution copy(FlowExecutionStopReason reason) {
            return new StopFlowExecution(reason);
        }

        public FlowExecutionStopReason copy$default$1() {
            return this.reason();
        }

        public String productPrefix() {
            return "StopFlowExecution";
        }

        public int productArity() {
            return 1;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return this.reason();
                }
            }
            return Statics.ioobe((int)x$1);
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof StopFlowExecution;
        }

        public String productElementName(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return "reason";
                }
            }
            return (String)Statics.ioobe((int)x$1);
        }

        public int hashCode() {
            return MurmurHash3$.MODULE$.productHash((Product)this, -929850492, true);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof StopFlowExecution)) return false;
            boolean bl = true;
            if (!bl) return false;
            StopFlowExecution stopFlowExecution = (StopFlowExecution)x$1;
            FlowExecutionStopReason flowExecutionStopReason = this.reason();
            FlowExecutionStopReason flowExecutionStopReason2 = stopFlowExecution.reason();
            if (flowExecutionStopReason == null) {
                if (flowExecutionStopReason2 != null) {
                    return false;
                }
            } else if (!flowExecutionStopReason.equals(flowExecutionStopReason2)) return false;
            if (!stopFlowExecution.canEqual(this)) return false;
            return true;
        }

        public StopFlowExecution(FlowExecutionStopReason reason) {
            this.reason = reason;
            Product.$init$((Product)this);
        }
    }
}

