/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.connect;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.spark.connect.proto.Command;
import org.apache.spark.connect.proto.ExecutePlanResponse;
import org.apache.spark.connect.proto.Plan;
import org.apache.spark.connect.proto.StreamingQueryEventType;
import org.apache.spark.connect.proto.StreamingQueryListenerEvent;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.LogEntry$;
import org.apache.spark.internal.LogKey;
import org.apache.spark.internal.LogKeys;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.MDC;
import org.apache.spark.internal.MessageWithContext;
import org.apache.spark.sql.connect.SparkSession;
import org.apache.spark.sql.streaming.StreamingQueryListener;
import org.apache.spark.sql.streaming.StreamingQueryListener$QueryIdleEvent$;
import org.apache.spark.sql.streaming.StreamingQueryListener$QueryProgressEvent$;
import org.apache.spark.sql.streaming.StreamingQueryListener$QueryTerminatedEvent$;
import org.apache.spark.sql.util.CloseableIterator;
import org.slf4j.Logger;
import org.slf4j.event.Level;
import scala.Function0;
import scala.Option;
import scala.Option$;
import scala.Some;
import scala.StringContext;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\u0005=b\u0001B\t\u0013\u0001uA\u0001B\u000b\u0001\u0003\u0002\u0003\u0006Ia\u000b\u0005\u0006_\u0001!\t\u0001\r\u0005\bg\u0001\u0011\r\u0011\"\u00035\u0011\u0019)\u0005\u0001)A\u0005k!9a\t\u0001a\u0001\n\u00139\u0005bB)\u0001\u0001\u0004%IA\u0015\u0005\u00071\u0002\u0001\u000b\u0015\u0002%\t\u000fe\u0003!\u0019!C\u00015\"1a\f\u0001Q\u0001\nmCQa\u0018\u0001\u0005\u0002\u0001DQ!\u0019\u0001\u0005\u0002\tDQ!\u001a\u0001\u0005\u0002\u0019DQ\u0001\u001b\u0001\u0005\u0002%DQ!\u001c\u0001\u0005\u00029DQa\u001f\u0001\u0005\u0002qDaa \u0001\u0005\u0002\u0005\u0005!!G*ue\u0016\fW.\u001b8h#V,'/\u001f'jgR,g.\u001a:CkNT!a\u0005\u000b\u0002\u000f\r|gN\\3di*\u0011QCF\u0001\u0004gFd'BA\f\u0019\u0003\u0015\u0019\b/\u0019:l\u0015\tI\"$\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u00027\u0005\u0019qN]4\u0004\u0001M\u0019\u0001A\b\u0013\u0011\u0005}\u0011S\"\u0001\u0011\u000b\u0003\u0005\nQa]2bY\u0006L!a\t\u0011\u0003\r\u0005s\u0017PU3g!\t)\u0003&D\u0001'\u0015\t9c#\u0001\u0005j]R,'O\\1m\u0013\tIcEA\u0004M_\u001e<\u0017N\\4\u0002\u0019M\u0004\u0018M]6TKN\u001c\u0018n\u001c8\u0011\u00051jS\"\u0001\n\n\u00059\u0012\"\u0001D*qCJ\\7+Z:tS>t\u0017A\u0002\u001fj]&$h\b\u0006\u00022eA\u0011A\u0006\u0001\u0005\u0006U\t\u0001\raK\u0001\nY&\u001cH/\u001a8feN,\u0012!\u000e\t\u0004muzT\"A\u001c\u000b\u0005aJ\u0014AC2p]\u000e,(O]3oi*\u0011!hO\u0001\u0005kRLGNC\u0001=\u0003\u0011Q\u0017M^1\n\u0005y:$\u0001F\"paf|en\u0016:ji\u0016\f%O]1z\u0019&\u001cH\u000f\u0005\u0002A\u00076\t\u0011I\u0003\u0002C)\u0005I1\u000f\u001e:fC6LgnZ\u0005\u0003\t\u0006\u0013ac\u0015;sK\u0006l\u0017N\\4Rk\u0016\u0014\u0018\u0010T5ti\u0016tWM]\u0001\u000bY&\u001cH/\u001a8feN\u0004\u0013aD3yK\u000e,H/[8o)\"\u0014X-\u00193\u0016\u0003!\u00032aH%L\u0013\tQ\u0005E\u0001\u0004PaRLwN\u001c\t\u0003\u0019>k\u0011!\u0014\u0006\u0003\u001dn\nA\u0001\\1oO&\u0011\u0001+\u0014\u0002\u0007)\"\u0014X-\u00193\u0002'\u0015DXmY;uS>tG\u000b\u001b:fC\u0012|F%Z9\u0015\u0005M3\u0006CA\u0010U\u0013\t)\u0006E\u0001\u0003V]&$\bbB,\u0007\u0003\u0003\u0005\r\u0001S\u0001\u0004q\u0012\n\u0014\u0001E3yK\u000e,H/[8o)\"\u0014X-\u00193!\u0003\u0011awnY6\u0016\u0003m\u0003\"\u0001\u0014/\n\u0005uk%AB(cU\u0016\u001cG/A\u0003m_\u000e\\\u0007%A\u0003dY>\u001cX\rF\u0001T\u0003\u0019\t\u0007\u000f]3oIR\u00111k\u0019\u0005\u0006I.\u0001\raP\u0001\tY&\u001cH/\u001a8fe\u00061!/Z7pm\u0016$\"aU4\t\u000b\u0011d\u0001\u0019A \u0002\t1L7\u000f\u001e\u000b\u0002UB\u0019qd[ \n\u00051\u0004#!B!se\u0006L\u0018A\u0007:fO&\u001cH/\u001a:TKJ4XM]*jI\u0016d\u0015n\u001d;f]\u0016\u0014H#A8\u0011\u0007A\u0014H/D\u0001r\u0015\tQD#\u0003\u0002tc\n\t2\t\\8tK\u0006\u0014G.Z%uKJ\fGo\u001c:\u0011\u0005ULX\"\u0001<\u000b\u0005]D\u0018!\u00029s_R|'BA\n\u0017\u0013\tQhOA\nFq\u0016\u001cW\u000f^3QY\u0006t'+Z:q_:\u001cX-A\trk\u0016\u0014\u00180\u0012<f]RD\u0015M\u001c3mKJ$\"aU?\t\u000by|\u0001\u0019A8\u0002\t%$XM]\u0001\na>\u001cH\u000fV8BY2$2aUA\u0002\u0011\u001d\t)\u0001\u0005a\u0001\u0003\u000f\tQ!\u001a<f]R\u0004B!!\u0003\u0002*9!\u00111BA\u0013\u001d\u0011\ti!a\t\u000f\t\u0005=\u0011\u0011\u0005\b\u0005\u0003#\tyB\u0004\u0003\u0002\u0014\u0005ua\u0002BA\u000b\u00037i!!a\u0006\u000b\u0007\u0005eA$\u0001\u0004=e>|GOP\u0005\u00027%\u0011\u0011DG\u0005\u0003/aI!!\u0006\f\n\u0005\t#\u0012bAA\u0014\u0003\u000612\u000b\u001e:fC6LgnZ)vKJLH*[:uK:,'/\u0003\u0003\u0002,\u00055\"!B#wK:$(bAA\u0014\u0003\u0002")
public class StreamingQueryListenerBus
implements Logging {
    private final SparkSession sparkSession;
    private final CopyOnWriteArrayList<StreamingQueryListener> listeners;
    private Option<Thread> executionThread;
    private final Object lock;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(Map<String, String> context, Function0<BoxedUnit> body) {
        Logging.withLogContext$((Logging)this, context, body);
    }

    public MDC MDC(LogKey key, Object value) {
        return Logging.MDC$((Logging)this, (LogKey)key, (Object)value);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void logBasedOnLevel(Level level, Function0<MessageWithContext> f) {
        Logging.logBasedOnLevel$((Logging)this, (Level)level, f);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private CopyOnWriteArrayList<StreamingQueryListener> listeners() {
        return this.listeners;
    }

    private Option<Thread> executionThread() {
        return this.executionThread;
    }

    private void executionThread_$eq(Option<Thread> x$1) {
        this.executionThread = x$1;
    }

    public Object lock() {
        return this.lock;
    }

    public void close() {
        this.listeners().forEach(x$1 -> this.remove((StreamingQueryListener)x$1));
    }

    public void append(StreamingQueryListener listener) {
        Object object = new Object();
        try {
            Object object2 = this.lock();
            synchronized (object2) {
                this.listeners().add(listener);
                if (this.listeners().size() == 1) {
                    ObjectRef iter = ObjectRef.create((Object)Option$.MODULE$.empty());
                    this.liftedTree1$1(iter, listener, object);
                    this.executionThread_$eq((Option<Thread>)new Some((Object)new Thread(new Runnable(this, iter){
                        private final /* synthetic */ StreamingQueryListenerBus $outer;
                        private final ObjectRef iter$1;

                        public void run() {
                            this.$outer.queryEventHandler((CloseableIterator)((Option)this.iter$1.elem).get());
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.iter$1 = iter$1;
                        }
                    })));
                    ((Thread)this.executionThread().get()).start();
                }
            }
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                ex.value$mcV$sp();
            }
            throw ex;
        }
    }

    public void remove(StreamingQueryListener listener) {
        Object object = new Object();
        try {
            Object object2 = this.lock();
            synchronized (object2) {
                if (this.listeners().size() == 1) {
                    Command.Builder cmdBuilder = Command.newBuilder();
                    cmdBuilder.getStreamingQueryListenerBusCommandBuilder().setRemoveListenerBusListener(true);
                    this.liftedTree2$1(cmdBuilder, object);
                    if (this.executionThread().isDefined()) {
                        ((Thread)this.executionThread().get()).interrupt();
                        this.executionThread_$eq((Option<Thread>)Option$.MODULE$.empty());
                    }
                }
                this.listeners().remove(listener);
            }
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                ex.value$mcV$sp();
            }
            throw ex;
        }
    }

    public StreamingQueryListener[] list() {
        StreamingQueryListener[] streamingQueryListenerArray;
        Object object = this.lock();
        synchronized (object) {
            streamingQueryListenerArray = (StreamingQueryListener[])CollectionConverters$.MODULE$.ListHasAsScala(this.listeners()).asScala().toArray(ClassTag$.MODULE$.apply(StreamingQueryListener.class));
        }
        return streamingQueryListenerArray;
    }

    public CloseableIterator<ExecutePlanResponse> registerServerSideListener() {
        Command.Builder cmdBuilder = Command.newBuilder();
        cmdBuilder.getStreamingQueryListenerBusCommandBuilder().setAddListenerBusListener(true);
        Plan plan = Plan.newBuilder().setCommand(cmdBuilder.build()).build();
        CloseableIterator<ExecutePlanResponse> iterator = this.sparkSession.client().execute(plan, this.sparkSession.client().execute$default$2());
        while (iterator.hasNext()) {
            ExecutePlanResponse response = (ExecutePlanResponse)iterator.next();
            if (!response.getStreamingQueryListenerEventsResult().hasListenerBusListenerAdded() || !response.getStreamingQueryListenerEventsResult().getListenerBusListenerAdded()) continue;
            return iterator;
        }
        return iterator;
    }

    public void queryEventHandler(CloseableIterator<ExecutePlanResponse> iter) {
        try {
            while (iter.hasNext()) {
                ExecutePlanResponse response = (ExecutePlanResponse)iter.next();
                List<StreamingQueryListenerEvent> listenerEvents = response.getStreamingQueryListenerEventsResult().getEventsList();
                listenerEvents.forEach(event -> {
                    StreamingQueryEventType streamingQueryEventType = event.getEventType();
                    if (StreamingQueryEventType.QUERY_PROGRESS_EVENT.equals(streamingQueryEventType)) {
                        this.postToAll(StreamingQueryListener$QueryProgressEvent$.MODULE$.fromJson(event.getEventJson()));
                        return;
                    }
                    if (StreamingQueryEventType.QUERY_IDLE_EVENT.equals(streamingQueryEventType)) {
                        this.postToAll(StreamingQueryListener$QueryIdleEvent$.MODULE$.fromJson(event.getEventJson()));
                        return;
                    }
                    if (StreamingQueryEventType.QUERY_TERMINATED_EVENT.equals(streamingQueryEventType)) {
                        this.postToAll(StreamingQueryListener$QueryTerminatedEvent$.MODULE$.fromJson(event.getEventJson()));
                        return;
                    }
                    this.logWarning(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Unknown StreamingQueryListener event: ", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{this.MDC((LogKey)LogKeys.EVENT, event)}))));
                });
            }
        }
        catch (Exception e) {
            this.logWarning((Function0<String>)(Function0 & Serializable)() -> "StreamingQueryListenerBus Handler thread received exception, all client side listeners are removed and handler thread is terminated.", (Throwable)e);
            Object object = this.lock();
            synchronized (object) {
                this.executionThread_$eq((Option<Thread>)Option$.MODULE$.empty());
                this.listeners().forEach(x$2 -> this.remove((StreamingQueryListener)x$2));
            }
        }
    }

    public void postToAll(StreamingQueryListener.Event event) {
        Object object = this.lock();
        synchronized (object) {
            this.listeners().forEach(listener -> {
                block6: {
                    try {
                        StreamingQueryListener.Event event = event;
                        if (event instanceof StreamingQueryListener.QueryStartedEvent) {
                            StreamingQueryListener.QueryStartedEvent queryStartedEvent = (StreamingQueryListener.QueryStartedEvent)event;
                            listener.onQueryStarted(queryStartedEvent);
                            break block6;
                        }
                        if (event instanceof StreamingQueryListener.QueryProgressEvent) {
                            StreamingQueryListener.QueryProgressEvent queryProgressEvent = (StreamingQueryListener.QueryProgressEvent)event;
                            listener.onQueryProgress(queryProgressEvent);
                            break block6;
                        }
                        if (event instanceof StreamingQueryListener.QueryIdleEvent) {
                            StreamingQueryListener.QueryIdleEvent queryIdleEvent = (StreamingQueryListener.QueryIdleEvent)event;
                            listener.onQueryIdle(queryIdleEvent);
                            break block6;
                        }
                        if (event instanceof StreamingQueryListener.QueryTerminatedEvent) {
                            StreamingQueryListener.QueryTerminatedEvent queryTerminatedEvent = (StreamingQueryListener.QueryTerminatedEvent)event;
                            listener.onQueryTerminated(queryTerminatedEvent);
                            break block6;
                        }
                        this.logWarning(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Unknown StreamingQueryListener event: ", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{this.MDC((LogKey)LogKeys.EVENT, event)}))));
                    }
                    catch (Exception e) {
                        this.logWarning(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Listener ", " threw an exception"}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{this.MDC((LogKey)LogKeys.LISTENER, listener)}))), (Throwable)e);
                    }
                }
            });
        }
    }

    private final /* synthetic */ void liftedTree1$1(ObjectRef iter$1, StreamingQueryListener listener$1, Object nonLocalReturnKey1$1) {
        try {
            iter$1.elem = new Some(this.registerServerSideListener());
        }
        catch (Exception e) {
            this.logWarning((Function0<String>)(Function0 & Serializable)() -> "Failed to add the listener, please add it again.", (Throwable)e);
            this.listeners().remove(listener$1);
            throw new NonLocalReturnControl.mcV.sp(nonLocalReturnKey1$1, BoxedUnit.UNIT);
        }
    }

    private final /* synthetic */ Seq liftedTree2$1(Command.Builder cmdBuilder$1, Object nonLocalReturnKey2$1) {
        Seq<ExecutePlanResponse> seq;
        try {
            seq = this.sparkSession.execute(cmdBuilder$1.build());
        }
        catch (Exception e) {
            this.logWarning((Function0<String>)(Function0 & Serializable)() -> "Failed to remove the listener, please remove it again.", (Throwable)e);
            throw new NonLocalReturnControl.mcV.sp(nonLocalReturnKey2$1, BoxedUnit.UNIT);
        }
        return seq;
    }

    public StreamingQueryListenerBus(SparkSession sparkSession) {
        this.sparkSession = sparkSession;
        Logging.$init$((Logging)this);
        this.listeners = new CopyOnWriteArrayList();
        this.executionThread = Option$.MODULE$.empty();
        this.lock = new Object();
    }
}

