/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions.gen;

import java.sql.Date;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FilterLongColumnBetween;
import org.apache.hadoop.hive.ql.plan.DynamicValue;
import org.apache.hadoop.hive.serde2.io.DateWritable;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilterDateColumnBetweenDynamicValue
extends FilterLongColumnBetween {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(FilterDateColumnBetweenDynamicValue.class);
    protected DynamicValue leftDynamicValue;
    protected DynamicValue rightDynamicValue;
    protected transient boolean initialized = false;
    protected transient boolean isLeftOrRightNull = false;

    public FilterDateColumnBetweenDynamicValue(int colNum, DynamicValue leftValue, DynamicValue rightValue) {
        super(colNum, 0L, 0L);
        this.leftDynamicValue = leftValue;
        this.rightDynamicValue = rightValue;
    }

    public FilterDateColumnBetweenDynamicValue() {
    }

    public DynamicValue getLeftDynamicValue() {
        return this.leftDynamicValue;
    }

    public void setLeftDynamicValue(DynamicValue leftValue) {
        this.leftDynamicValue = leftValue;
    }

    public DynamicValue getRightDynamicValue() {
        return this.rightDynamicValue;
    }

    public void getRightDynamicValue(DynamicValue rightValue) {
        this.rightDynamicValue = rightValue;
    }

    @Override
    public void init(Configuration conf) {
        super.init(conf);
        this.leftDynamicValue.setConf(conf);
        this.rightDynamicValue.setConf(conf);
    }

    @Override
    public void evaluate(VectorizedRowBatch batch) {
        if (!this.initialized) {
            Object lVal = this.leftDynamicValue.getValue();
            Object rVal = this.rightDynamicValue.getValue();
            if (lVal == null || rVal == null) {
                this.isLeftOrRightNull = true;
            } else {
                long min = DateWritable.dateToDays((Date)PrimitiveObjectInspectorUtils.getDate((Object)lVal, (PrimitiveObjectInspector)this.leftDynamicValue.getObjectInspector()));
                this.setLeftValue(min);
                long max = DateWritable.dateToDays((Date)PrimitiveObjectInspectorUtils.getDate((Object)rVal, (PrimitiveObjectInspector)this.rightDynamicValue.getObjectInspector()));
                this.setRightValue(max);
            }
            this.initialized = true;
        }
        if (this.isLeftOrRightNull) {
            batch.size = 0;
        }
        super.evaluate(batch);
    }
}

