/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.network.shuffle.protocol;

import io.netty.buffer.ByteBuf;
import java.util.Objects;
import org.apache.spark.network.protocol.Encoders;
import org.apache.spark.network.shuffle.protocol.BlockTransferMessage;

public abstract class AbstractFetchShuffleBlocks
extends BlockTransferMessage {
    public final String appId;
    public final String execId;
    public final int shuffleId;

    protected AbstractFetchShuffleBlocks(String appId, String execId, int shuffleId) {
        this.appId = appId;
        this.execId = execId;
        this.shuffleId = shuffleId;
    }

    public abstract int getNumBlocks();

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractFetchShuffleBlocks that = (AbstractFetchShuffleBlocks)o;
        return this.shuffleId == that.shuffleId && Objects.equals(this.appId, that.appId) && Objects.equals(this.execId, that.execId);
    }

    public int hashCode() {
        int result = this.appId.hashCode();
        result = 31 * result + this.execId.hashCode();
        result = 31 * result + this.shuffleId;
        return result;
    }

    public int encodedLength() {
        return Encoders.Strings.encodedLength((String)this.appId) + Encoders.Strings.encodedLength((String)this.execId) + 4;
    }

    public void encode(ByteBuf buf) {
        Encoders.Strings.encode((ByteBuf)buf, (String)this.appId);
        Encoders.Strings.encode((ByteBuf)buf, (String)this.execId);
        buf.writeInt(this.shuffleId);
    }
}

