/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.core.toolkit.sql;

import com.baomidou.mybatisplus.core.toolkit.Constants;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import org.apache.ibatis.type.JdbcType;
import org.apache.ibatis.type.TypeHandler;

public abstract class SqlScriptUtils
implements Constants {
    public static String convertIf(String sqlScript, String ifTest, boolean newLine) {
        String newSqlScript = sqlScript;
        if (newLine) {
            newSqlScript = "\n" + newSqlScript + "\n";
        }
        return String.format("<if test=\"%s\">%s</if>", ifTest, newSqlScript);
    }

    public static String convertTrim(String sqlScript, String prefix, String suffix, String prefixOverrides, String suffixOverrides) {
        StringBuilder sb = new StringBuilder("<trim");
        if (StringUtils.isNotBlank(prefix)) {
            sb.append(" prefix=\"").append(prefix).append("\"");
        }
        if (StringUtils.isNotBlank(suffix)) {
            sb.append(" suffix=\"").append(suffix).append("\"");
        }
        if (StringUtils.isNotBlank(prefixOverrides)) {
            sb.append(" prefixOverrides=\"").append(prefixOverrides).append("\"");
        }
        if (StringUtils.isNotBlank(suffixOverrides)) {
            sb.append(" suffixOverrides=\"").append(suffixOverrides).append("\"");
        }
        return sb.append(">").append("\n").append(sqlScript).append("\n").append("</trim>").toString();
    }

    public static String convertChoose(String whenTest, String whenSqlScript, String otherwise) {
        return "<choose>\n<when test=\"" + whenTest + "\"" + ">" + "\n" + whenSqlScript + "\n" + "</when>" + "\n" + "<otherwise>" + otherwise + "</otherwise>" + "\n" + "</choose>";
    }

    public static String convertForeach(String sqlScript, String collection, String index, String item, String separator) {
        StringBuilder sb = new StringBuilder("<foreach");
        if (StringUtils.isNotBlank(collection)) {
            sb.append(" collection=\"").append(collection).append("\"");
        }
        if (StringUtils.isNotBlank(index)) {
            sb.append(" index=\"").append(index).append("\"");
        }
        if (StringUtils.isNotBlank(item)) {
            sb.append(" item=\"").append(item).append("\"");
        }
        if (StringUtils.isNotBlank(separator)) {
            sb.append(" separator=\"").append(separator).append("\"");
        }
        return sb.append(">").append("\n").append(sqlScript).append("\n").append("</foreach>").toString();
    }

    public static String convertWhere(String sqlScript) {
        return "<where>\n" + sqlScript + "\n" + "</where>";
    }

    public static String convertSet(String sqlScript) {
        return "<set>\n" + sqlScript + "\n" + "</set>";
    }

    public static String safeParam(String param) {
        return SqlScriptUtils.safeParam(param, null);
    }

    public static String safeParam(String param, String mapping) {
        String target = "#{" + param;
        if (StringUtils.isBlank(mapping)) {
            return target + "}";
        }
        return target + "," + mapping + "}";
    }

    public static String unSafeParam(String param) {
        return "${" + param + "}";
    }

    public static String mappingTypeHandler(Class<? extends TypeHandler<?>> typeHandler) {
        if (typeHandler != null) {
            return "typeHandler=" + typeHandler.getName();
        }
        return null;
    }

    public static String mappingJdbcType(JdbcType jdbcType) {
        if (jdbcType != null) {
            return "jdbcType=" + jdbcType.name();
        }
        return null;
    }

    public static String mappingNumericScale(Integer numericScale) {
        if (numericScale != null) {
            return "numericScale=" + numericScale;
        }
        return null;
    }

    public static String convertParamMapping(Class<? extends TypeHandler<?>> typeHandler, JdbcType jdbcType, Integer numericScale) {
        if (typeHandler == null && jdbcType == null && numericScale == null) {
            return null;
        }
        String mapping = null;
        if (typeHandler != null) {
            mapping = SqlScriptUtils.mappingTypeHandler(typeHandler);
        }
        if (jdbcType != null) {
            mapping = SqlScriptUtils.appendMapping(mapping, SqlScriptUtils.mappingJdbcType(jdbcType));
        }
        if (numericScale != null) {
            mapping = SqlScriptUtils.appendMapping(mapping, SqlScriptUtils.mappingNumericScale(numericScale));
        }
        return mapping;
    }

    private static String appendMapping(String mapping, String other) {
        if (mapping != null) {
            return mapping + "," + other;
        }
        return other;
    }
}

