/*
 * Decompiled with CFR 0.152.
 */
package com.google.gxp.compiler.base;

import com.google.gxp.com.google.common.base.Objects;
import com.google.gxp.com.google.common.base.Preconditions;
import com.google.gxp.compiler.base.Expression;
import com.google.gxp.compiler.base.ExpressionVisitor;
import com.google.gxp.compiler.base.Node;
import com.google.gxp.compiler.base.Type;

public class AbbrExpression
extends Expression {
    private final Type type;
    private final String name;
    private final Expression value;
    private final Expression content;

    public AbbrExpression(Node fromNode, Type type, String name, Expression value, Expression content) {
        super(fromNode, content.getSchema());
        this.type = Preconditions.checkNotNull(type);
        this.name = Preconditions.checkNotNull(name);
        this.value = Preconditions.checkNotNull(value);
        this.content = Preconditions.checkNotNull(content);
    }

    public Type getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public Expression getValue() {
        return this.value;
    }

    public Expression getContent() {
        return this.content;
    }

    public AbbrExpression withValueAndContent(Expression newValue, Expression newContent) {
        return this.value.equals(newValue) && this.content.equals(newContent) ? this : new AbbrExpression(this, this.type, this.name, newValue, newContent);
    }

    @Override
    public <T> T acceptVisitor(ExpressionVisitor<T> visitor) {
        return visitor.visitAbbrExpression(this);
    }

    @Override
    public boolean equals(Object that) {
        return this == that || that instanceof AbbrExpression && this.equals((AbbrExpression)that);
    }

    public boolean equals(AbbrExpression that) {
        return this.equalsExpression(that) && Objects.equal(this.getType(), that.getType()) && Objects.equal(this.getName(), that.getName()) && Objects.equal(this.getValue(), that.getValue()) && Objects.equal(this.getContent(), that.getContent());
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(this.expressionHashCode(), this.getType(), this.getName(), this.getValue(), this.getContent());
    }
}

