/*
 * Decompiled with CFR 0.152.
 */
package com.google.gxp.compiler.base;

import com.google.gxp.com.google.common.base.Preconditions;
import com.google.gxp.compiler.base.Import;
import com.google.gxp.compiler.base.ImportVisitor;
import com.google.gxp.compiler.base.Node;

public class CppFileImport
extends Import {
    private final String fileName;

    public CppFileImport(Node fromNode, String fileName) {
        super(fromNode);
        this.fileName = Preconditions.checkNotNull(fileName);
    }

    public String getFileName() {
        return this.fileName;
    }

    @Override
    public <T> T acceptVisitor(ImportVisitor<T> visitor) {
        return visitor.visitCppFileImport(this);
    }

    @Override
    public String getTarget() {
        return String.format("\"%s.h\"", this.getFileName());
    }

    public boolean equals(Object that) {
        return that instanceof CppFileImport && this.equals((CppFileImport)that);
    }

    public boolean equals(CppFileImport that) {
        return this.getFileName().equals(that.getFileName());
    }
}

