/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.xml.print;

import java.util.StringTokenizer;
import java.util.function.Consumer;
import net.sf.jasperreports.engine.JRPrintText;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.base.JRBasePrintText;
import net.sf.jasperreports.engine.type.HorizontalTextAlignEnum;
import net.sf.jasperreports.engine.type.RotationEnum;
import net.sf.jasperreports.engine.type.RunDirectionEnum;
import net.sf.jasperreports.engine.type.VerticalTextAlignEnum;
import net.sf.jasperreports.engine.xml.print.BoxLoader;
import net.sf.jasperreports.engine.xml.print.HyperlinkLoader;
import net.sf.jasperreports.engine.xml.print.ParagraphsLoader;
import net.sf.jasperreports.engine.xml.print.ReportElementLoader;
import net.sf.jasperreports.engine.xml.print.XmlLoader;

public class TextLoader {
    private static final TextLoader INSTANCE = new TextLoader();

    public static TextLoader instance() {
        return INSTANCE;
    }

    public void loadText(XmlLoader xmlLoader, JasperPrint jasperPrint, Consumer<? super JRPrintText> consumer) {
        JRBasePrintText text = new JRBasePrintText(jasperPrint.getDefaultStyleProvider());
        xmlLoader.setEnumAttribute("textAlignment", HorizontalTextAlignEnum::getByName, text::setHorizontalTextAlign);
        xmlLoader.setEnumAttribute("verticalAlignment", VerticalTextAlignEnum::getByName, text::setVerticalTextAlign);
        xmlLoader.setEnumAttribute("rotation", RotationEnum::getByName, text::setRotation);
        xmlLoader.setEnumAttribute("runDirection", RunDirectionEnum::getByName, text::setRunDirection);
        xmlLoader.setFloatAttribute("textHeight", text::setTextHeight);
        xmlLoader.setAttribute("markup", text::setMarkup);
        xmlLoader.setFloatAttribute("lineSpacingFactor", text::setLineSpacingFactor);
        xmlLoader.setFloatAttribute("leadingOffset", text::setLeadingOffset);
        xmlLoader.setFloatAttribute("averageCharWidth", text::setAverageCharWidth);
        xmlLoader.setAttribute("hyperlinkType", text::setLinkType);
        xmlLoader.setAttribute("hyperlinkTarget", text::setLinkTarget);
        xmlLoader.setAttribute("anchorName", text::setAnchorName);
        xmlLoader.setAttribute("hyperlinkReference", text::setHyperlinkReference);
        xmlLoader.setAttribute("hyperlinkAnchor", text::setHyperlinkAnchor);
        xmlLoader.setIntAttribute("hyperlinkPage", text::setHyperlinkPage);
        xmlLoader.setAttribute("hyperlinkTooltip", text::setHyperlinkTooltip);
        xmlLoader.setIntAttribute("bookmarkLevel", text::setBookmarkLevel);
        xmlLoader.setAttribute("valueClass", text::setValueClassName);
        xmlLoader.setAttribute("pattern", text::setPattern);
        xmlLoader.setAttribute("formatFactoryClass", text::setFormatFactoryClass);
        xmlLoader.setAttribute("locale", text::setLocaleCode);
        xmlLoader.setAttribute("timezone", text::setTimeZoneId);
        xmlLoader.loadElements(element -> {
            switch (element) {
                case "reportElement": {
                    ReportElementLoader.instance().loadReportElement(xmlLoader, jasperPrint, text);
                    break;
                }
                case "box": {
                    BoxLoader.instance().loadBox(xmlLoader, text.getLineBox());
                    break;
                }
                case "font": {
                    this.loadFont(xmlLoader, text);
                    break;
                }
                case "paragraph": {
                    ParagraphsLoader.instance().loadParagraph(xmlLoader, text.getParagraph());
                    break;
                }
                case "textContent": {
                    xmlLoader.setIntAttribute("truncateIndex", text::setTextTruncateIndex);
                    String textContent = xmlLoader.loadText(false);
                    text.setText(textContent);
                    break;
                }
                case "textTruncateSuffix": {
                    String textTruncateSuffix = xmlLoader.loadText(false);
                    text.setTextTruncateSuffix(textTruncateSuffix);
                    break;
                }
                case "lineBreakOffsets": {
                    this.loadLineBreakOffsets(xmlLoader, text);
                    break;
                }
                case "hyperlinkParameter": {
                    HyperlinkLoader.instance().loadHyperlinkParameter(xmlLoader, text::addHyperlinkParameter);
                    break;
                }
                default: {
                    xmlLoader.unexpectedElement((String)element);
                }
            }
        });
        consumer.accept(text);
    }

    protected void loadLineBreakOffsets(XmlLoader xmlLoader, JRBasePrintText text) {
        String lineBreakOffsets = xmlLoader.loadText(true);
        if (lineBreakOffsets != null) {
            short[] offsets;
            StringTokenizer tokenizer = new StringTokenizer(lineBreakOffsets, ",");
            int tokenCount = tokenizer.countTokens();
            if (tokenCount == 0) {
                offsets = JRPrintText.ZERO_LINE_BREAK_OFFSETS;
            } else {
                offsets = new short[tokenCount];
                for (int i = 0; i < offsets.length; ++i) {
                    String token = tokenizer.nextToken();
                    offsets[i] = Short.parseShort(token);
                }
            }
            text.setLineBreakOffsets(offsets);
        }
    }

    protected void loadFont(XmlLoader xmlLoader, JRBasePrintText text) {
        xmlLoader.setAttribute("fontName", text::setFontName);
        xmlLoader.setBooleanAttribute("isBold", text::setBold);
        xmlLoader.setBooleanAttribute("isItalic", text::setItalic);
        xmlLoader.setBooleanAttribute("isUnderline", text::setUnderline);
        xmlLoader.setBooleanAttribute("isStrikeThrough", text::setStrikeThrough);
        xmlLoader.setFloatAttribute("size", text::setFontSize);
        xmlLoader.setAttribute("pdfFontName", text::setPdfFontName);
        xmlLoader.setAttribute("pdfEncoding", text::setPdfEncoding);
        xmlLoader.setBooleanAttribute("isPdfEmbedded", text::setPdfEmbedded);
        xmlLoader.endElement();
    }
}

