/*
 * Decompiled with CFR 0.152.
 */
package com.yubico.fido.metadata;

import com.fasterxml.jackson.core.Base64Variants;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.yubico.fido.metadata.FidoMetadataDownloaderException;
import com.yubico.fido.metadata.JacksonCodecs;
import com.yubico.fido.metadata.MetadataBLOB;
import com.yubico.fido.metadata.MetadataBLOBHeader;
import com.yubico.fido.metadata.MetadataBLOBPayload;
import com.yubico.fido.metadata.UnexpectedLegalHeader;
import com.yubico.internal.util.BinaryUtil;
import com.yubico.internal.util.CertificateParser;
import com.yubico.webauthn.data.ByteArray;
import com.yubico.webauthn.data.exception.Base64UrlException;
import com.yubico.webauthn.data.exception.HexException;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.security.DigestException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CRL;
import java.security.cert.CertPath;
import java.security.cert.CertPathValidator;
import java.security.cert.CertPathValidatorException;
import java.security.cert.CertStore;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.PKIXParameters;
import java.security.cert.TrustAnchor;
import java.security.cert.X509Certificate;
import java.time.Clock;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.Scanner;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FidoMetadataDownloader {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FidoMetadataDownloader.class);
    @NonNull
    private final Set<String> expectedLegalHeaders;
    private final X509Certificate trustRootCertificate;
    private final URL trustRootUrl;
    private final Set<ByteArray> trustRootSha256;
    private final File trustRootCacheFile;
    private final Supplier<Optional<ByteArray>> trustRootCacheSupplier;
    private final Consumer<ByteArray> trustRootCacheConsumer;
    private final String blobJwt;
    private final URL blobUrl;
    private final File blobCacheFile;
    private final Supplier<Optional<ByteArray>> blobCacheSupplier;
    private final Consumer<ByteArray> blobCacheConsumer;
    private final CertStore certStore;
    @NonNull
    private final Clock clock;
    private final KeyStore httpsTrustStore;

    public static FidoMetadataDownloaderBuilder.Step1 builder() {
        return new FidoMetadataDownloaderBuilder.Step1();
    }

    public MetadataBLOB loadCachedBlob() throws CertPathValidatorException, InvalidAlgorithmParameterException, Base64UrlException, CertificateException, IOException, NoSuchAlgorithmException, SignatureException, InvalidKeyException, UnexpectedLegalHeader, DigestException, FidoMetadataDownloaderException {
        X509Certificate trustRoot = this.retrieveTrustRootCert();
        return this.retrieveBlob(trustRoot);
    }

    private X509Certificate retrieveTrustRootCert() throws CertificateException, DigestException, IOException, NoSuchAlgorithmException {
        if (this.trustRootCertificate != null) {
            return this.trustRootCertificate;
        }
        Optional<ByteArray> cachedContents = this.trustRootCacheFile != null ? this.readCacheFile(this.trustRootCacheFile) : this.trustRootCacheSupplier.get();
        X509Certificate cert = null;
        if (cachedContents.isPresent()) {
            try {
                X509Certificate cachedCert = CertificateParser.parseDer((byte[])cachedContents.get().getBytes());
                cachedCert.checkValidity(Date.from(this.clock.instant()));
                cert = cachedCert;
            }
            catch (CertificateException cachedCert) {
                // empty catch block
            }
        }
        if (cert == null) {
            ByteArray downloaded = FidoMetadataDownloader.verifyHash(this.download(this.trustRootUrl), this.trustRootSha256);
            if (downloaded == null) {
                throw new DigestException("Downloaded trust root certificate matches none of the acceptable hashes.");
            }
            cert = CertificateParser.parseDer((byte[])downloaded.getBytes());
            cert.checkValidity(Date.from(this.clock.instant()));
            if (this.trustRootCacheFile != null) {
                new FileOutputStream(this.trustRootCacheFile).write(downloaded.getBytes());
            }
            if (this.trustRootCacheConsumer != null) {
                this.trustRootCacheConsumer.accept(downloaded);
            }
        }
        return cert;
    }

    private MetadataBLOB retrieveBlob(X509Certificate trustRootCertificate) throws Base64UrlException, CertPathValidatorException, CertificateException, IOException, InvalidAlgorithmParameterException, InvalidKeyException, UnexpectedLegalHeader, NoSuchAlgorithmException, SignatureException, FidoMetadataDownloaderException {
        if (this.blobJwt != null) {
            return this.parseAndVerifyBlob(new ByteArray(this.blobJwt.getBytes(StandardCharsets.UTF_8)), trustRootCertificate);
        }
        Optional<ByteArray> cachedContents = this.blobCacheFile != null ? this.readCacheFile(this.blobCacheFile) : this.blobCacheSupplier.get();
        MetadataBLOB cachedBlob = cachedContents.map(cached -> {
            try {
                return this.parseAndVerifyBlob((ByteArray)cached, trustRootCertificate);
            }
            catch (Exception e) {
                return null;
            }
        }).orElse(null);
        if (cachedBlob != null && cachedBlob.getPayload().getNextUpdate().atStartOfDay().atZone(this.clock.getZone()).isAfter(this.clock.instant().atZone(this.clock.getZone()))) {
            return cachedBlob;
        }
        ByteArray downloaded = this.download(this.blobUrl);
        try {
            MetadataBLOB downloadedBlob = this.parseAndVerifyBlob(downloaded, trustRootCertificate);
            if (cachedBlob == null || downloadedBlob.getPayload().getNo() > cachedBlob.getPayload().getNo()) {
                if (this.expectedLegalHeaders.contains(downloadedBlob.getPayload().getLegalHeader())) {
                    if (this.blobCacheFile != null) {
                        new FileOutputStream(this.blobCacheFile).write(downloaded.getBytes());
                    }
                    if (this.blobCacheConsumer != null) {
                        this.blobCacheConsumer.accept(downloaded);
                    }
                    return downloadedBlob;
                }
                throw new UnexpectedLegalHeader(cachedBlob, downloadedBlob);
            }
            return cachedBlob;
        }
        catch (FidoMetadataDownloaderException e) {
            if (e.getReason() == FidoMetadataDownloaderException.Reason.BAD_SIGNATURE && cachedBlob != null) {
                return cachedBlob;
            }
            throw e;
        }
    }

    private Optional<ByteArray> readCacheFile(File cacheFile) throws IOException {
        if (cacheFile.exists() && cacheFile.canRead() && cacheFile.isFile()) {
            try {
                return Optional.of(FidoMetadataDownloader.readAll(new FileInputStream(cacheFile)));
            }
            catch (FileNotFoundException e) {
                throw new RuntimeException("This exception should be impossible, please file a bug report.", e);
            }
        }
        return Optional.empty();
    }

    private ByteArray download(URL url) throws IOException {
        URLConnection conn = url.openConnection();
        if (conn instanceof HttpsURLConnection) {
            HttpsURLConnection httpsConn = (HttpsURLConnection)conn;
            if (this.httpsTrustStore != null) {
                try {
                    TrustManagerFactory trustMan = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                    trustMan.init(this.httpsTrustStore);
                    SSLContext sslContext = SSLContext.getInstance("TLS");
                    sslContext.init(null, trustMan.getTrustManagers(), null);
                    httpsConn.setSSLSocketFactory(sslContext.getSocketFactory());
                }
                catch (KeyManagementException | KeyStoreException | NoSuchAlgorithmException e) {
                    throw new RuntimeException("Failed to initialize HTTPS trust store. This should be impossible, please file a bug report.", e);
                }
            }
            httpsConn.setRequestMethod("GET");
        }
        return FidoMetadataDownloader.readAll(conn.getInputStream());
    }

    private MetadataBLOB parseAndVerifyBlob(ByteArray jwt, X509Certificate trustRootCertificate) throws CertPathValidatorException, InvalidAlgorithmParameterException, CertificateException, IOException, NoSuchAlgorithmException, SignatureException, InvalidKeyException, Base64UrlException, FidoMetadataDownloaderException {
        Scanner s = new Scanner(new ByteArrayInputStream(jwt.getBytes())).useDelimiter("\\.");
        ByteArray header = ByteArray.fromBase64Url((String)s.next());
        ByteArray payload = ByteArray.fromBase64Url((String)s.next());
        ByteArray signature = ByteArray.fromBase64Url((String)s.next());
        return this.verifyBlob(header, payload, signature, trustRootCertificate);
    }

    private MetadataBLOB verifyBlob(ByteArray jwtHeader, ByteArray jwtPayload, ByteArray jwtSignature, X509Certificate trustRootCertificate) throws IOException, CertificateException, NoSuchAlgorithmException, InvalidKeyException, SignatureException, CertPathValidatorException, InvalidAlgorithmParameterException, FidoMetadataDownloaderException {
        Signature signature;
        List<X509Certificate> certChain;
        ObjectMapper headerJsonMapper = com.yubico.internal.util.JacksonCodecs.json().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, true).setBase64Variant(Base64Variants.MIME_NO_LINEFEEDS);
        MetadataBLOBHeader header = (MetadataBLOBHeader)headerJsonMapper.readValue(jwtHeader.getBytes(), MetadataBLOBHeader.class);
        if (header.getX5u().isPresent()) {
            URL x5u = header.getX5u().get();
            if (!(this.blobUrl == null || x5u.getHost().equals(this.blobUrl.getHost()) && x5u.getProtocol().equals(this.blobUrl.getProtocol()) && x5u.getPort() == this.blobUrl.getPort())) {
                throw new IllegalArgumentException(String.format("x5u in BLOB header must have same origin as the URL the BLOB was downloaded from. Expected origin of: %s ; found: %s", this.blobUrl, x5u));
            }
            ArrayList<X509Certificate> certs = new ArrayList<X509Certificate>();
            for (String pem : new String(this.download(x5u).getBytes(), StandardCharsets.UTF_8).trim().split("\\n+-----END CERTIFICATE-----\\n+-----BEGIN CERTIFICATE-----\\n+")) {
                X509Certificate x509Certificate = CertificateParser.parsePem((String)pem);
                certs.add(x509Certificate);
            }
            certChain = certs;
        } else {
            certChain = header.getX5c().isPresent() ? header.getX5c().get() : Collections.singletonList(trustRootCertificate);
        }
        X509Certificate leafCert = certChain.get(0);
        switch (header.getAlg()) {
            case "RS256": {
                signature = Signature.getInstance("SHA256withRSA");
                break;
            }
            case "ES256": {
                signature = Signature.getInstance("SHA256withECDSA");
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unimplemented JWT verification algorithm: " + header.getAlg());
            }
        }
        signature.initVerify(leafCert.getPublicKey());
        signature.update((jwtHeader.getBase64Url() + "." + jwtPayload.getBase64Url()).getBytes(StandardCharsets.UTF_8));
        if (!signature.verify(jwtSignature.getBytes())) {
            throw new FidoMetadataDownloaderException(FidoMetadataDownloaderException.Reason.BAD_SIGNATURE);
        }
        CertificateFactory certFactory = CertificateFactory.getInstance("X.509");
        CertPathValidator cpv = CertPathValidator.getInstance("PKIX");
        CertPath blobCertPath = certFactory.generateCertPath(certChain);
        PKIXParameters pathParams = new PKIXParameters(Collections.singleton(new TrustAnchor(trustRootCertificate, null)));
        if (this.certStore != null) {
            pathParams.addCertStore(this.certStore);
        }
        pathParams.setDate(Date.from(this.clock.instant()));
        cpv.validate(blobCertPath, pathParams);
        return new MetadataBLOB(header, (MetadataBLOBPayload)JacksonCodecs.jsonWithDefaultEnums().readValue(jwtPayload.getBytes(), MetadataBLOBPayload.class));
    }

    private static ByteArray readAll(InputStream is) throws IOException {
        return new ByteArray(BinaryUtil.readAll((InputStream)is));
    }

    private static ByteArray verifyHash(ByteArray contents, Set<ByteArray> acceptedCertSha256) throws NoSuchAlgorithmException {
        MessageDigest digest = MessageDigest.getInstance("SHA-256");
        ByteArray hash = new ByteArray(digest.digest(contents.getBytes()));
        if (acceptedCertSha256.stream().anyMatch(acceptableHash -> acceptableHash.equals((Object)hash))) {
            return contents;
        }
        return null;
    }

    @Generated
    private FidoMetadataDownloader(@NonNull Set<String> expectedLegalHeaders, X509Certificate trustRootCertificate, URL trustRootUrl, Set<ByteArray> trustRootSha256, File trustRootCacheFile, Supplier<Optional<ByteArray>> trustRootCacheSupplier, Consumer<ByteArray> trustRootCacheConsumer, String blobJwt, URL blobUrl, File blobCacheFile, Supplier<Optional<ByteArray>> blobCacheSupplier, Consumer<ByteArray> blobCacheConsumer, CertStore certStore, @NonNull Clock clock, KeyStore httpsTrustStore) {
        if (expectedLegalHeaders == null) {
            throw new NullPointerException("expectedLegalHeaders is marked non-null but is null");
        }
        if (clock == null) {
            throw new NullPointerException("clock is marked non-null but is null");
        }
        this.expectedLegalHeaders = expectedLegalHeaders;
        this.trustRootCertificate = trustRootCertificate;
        this.trustRootUrl = trustRootUrl;
        this.trustRootSha256 = trustRootSha256;
        this.trustRootCacheFile = trustRootCacheFile;
        this.trustRootCacheSupplier = trustRootCacheSupplier;
        this.trustRootCacheConsumer = trustRootCacheConsumer;
        this.blobJwt = blobJwt;
        this.blobUrl = blobUrl;
        this.blobCacheFile = blobCacheFile;
        this.blobCacheSupplier = blobCacheSupplier;
        this.blobCacheConsumer = blobCacheConsumer;
        this.certStore = certStore;
        this.clock = clock;
        this.httpsTrustStore = httpsTrustStore;
    }

    public static class FidoMetadataDownloaderBuilder {
        @NonNull
        private final Set<String> expectedLegalHeaders;
        private final X509Certificate trustRootCertificate;
        private final URL trustRootUrl;
        private final Set<ByteArray> trustRootSha256;
        private final File trustRootCacheFile;
        private final Supplier<Optional<ByteArray>> trustRootCacheSupplier;
        private final Consumer<ByteArray> trustRootCacheConsumer;
        private final String blobJwt;
        private final URL blobUrl;
        private final File blobCacheFile;
        private final Supplier<Optional<ByteArray>> blobCacheSupplier;
        private final Consumer<ByteArray> blobCacheConsumer;
        private CertStore certStore = null;
        @NonNull
        private Clock clock = Clock.systemUTC();
        private KeyStore httpsTrustStore = null;

        public FidoMetadataDownloader build() {
            return new FidoMetadataDownloader(this.expectedLegalHeaders, this.trustRootCertificate, this.trustRootUrl, this.trustRootSha256, this.trustRootCacheFile, this.trustRootCacheSupplier, this.trustRootCacheConsumer, this.blobJwt, this.blobUrl, this.blobCacheFile, this.blobCacheSupplier, this.blobCacheConsumer, this.certStore, this.clock, this.httpsTrustStore);
        }

        private static FidoMetadataDownloaderBuilder finishRequiredSteps(Step5 step5, File blobCacheFile, Supplier<Optional<ByteArray>> blobCacheSupplier, Consumer<ByteArray> blobCacheConsumer) {
            return new FidoMetadataDownloaderBuilder(step5.step4.step3.step2.expectedLegalHeaders, step5.step4.step3.trustRootCertificate, step5.step4.step3.trustRootUrl, step5.step4.step3.trustRootSha256, step5.step4.trustRootCacheFile, step5.step4.trustRootCacheSupplier, step5.step4.trustRootCacheConsumer, step5.blobJwt, step5.blobUrl, blobCacheFile, blobCacheSupplier, blobCacheConsumer);
        }

        public FidoMetadataDownloaderBuilder clock(@NonNull Clock clock) {
            if (clock == null) {
                throw new NullPointerException("clock is marked non-null but is null");
            }
            this.clock = clock;
            return this;
        }

        public FidoMetadataDownloaderBuilder useCrls(@NonNull Collection<CRL> crls) throws InvalidAlgorithmParameterException, NoSuchAlgorithmException {
            if (crls == null) {
                throw new NullPointerException("crls is marked non-null but is null");
            }
            return this.useCrls(CertStore.getInstance("Collection", new CollectionCertStoreParameters(crls)));
        }

        public FidoMetadataDownloaderBuilder useCrls(CertStore certStore) {
            this.certStore = certStore;
            return this;
        }

        public FidoMetadataDownloaderBuilder trustHttpsCerts(X509Certificate ... certificates) {
            KeyStore trustStore;
            if (certificates == null) {
                throw new NullPointerException("certificates is marked non-null but is null");
            }
            try {
                trustStore = KeyStore.getInstance(KeyStore.getDefaultType());
                trustStore.load(null);
            }
            catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
                throw new RuntimeException("Failed to instantiate or initialize KeyStore. This should not be possible, please file a bug report.", e);
            }
            for (X509Certificate cert : certificates) {
                try {
                    trustStore.setCertificateEntry(UUID.randomUUID().toString(), cert);
                }
                catch (KeyStoreException e) {
                    throw new RuntimeException("Failed to import HTTPS cert into KeyStore. This should not be possible, please file a bug report.", e);
                }
            }
            this.httpsTrustStore = trustStore;
            return this;
        }

        @Generated
        private FidoMetadataDownloaderBuilder(@NonNull Set<String> expectedLegalHeaders, X509Certificate trustRootCertificate, URL trustRootUrl, Set<ByteArray> trustRootSha256, File trustRootCacheFile, Supplier<Optional<ByteArray>> trustRootCacheSupplier, Consumer<ByteArray> trustRootCacheConsumer, String blobJwt, URL blobUrl, File blobCacheFile, Supplier<Optional<ByteArray>> blobCacheSupplier, Consumer<ByteArray> blobCacheConsumer) {
            if (expectedLegalHeaders == null) {
                throw new NullPointerException("expectedLegalHeaders is marked non-null but is null");
            }
            this.expectedLegalHeaders = expectedLegalHeaders;
            this.trustRootCertificate = trustRootCertificate;
            this.trustRootUrl = trustRootUrl;
            this.trustRootSha256 = trustRootSha256;
            this.trustRootCacheFile = trustRootCacheFile;
            this.trustRootCacheSupplier = trustRootCacheSupplier;
            this.trustRootCacheConsumer = trustRootCacheConsumer;
            this.blobJwt = blobJwt;
            this.blobUrl = blobUrl;
            this.blobCacheFile = blobCacheFile;
            this.blobCacheSupplier = blobCacheSupplier;
            this.blobCacheConsumer = blobCacheConsumer;
        }

        public static class Step5 {
            @NonNull
            private final Step4 step4;
            private final String blobJwt;
            private final URL blobUrl;

            public FidoMetadataDownloaderBuilder useBlobCacheFile(@NonNull File cacheFile) {
                if (cacheFile == null) {
                    throw new NullPointerException("cacheFile is marked non-null but is null");
                }
                return FidoMetadataDownloaderBuilder.finishRequiredSteps(this, cacheFile, null, null);
            }

            public FidoMetadataDownloaderBuilder useBlobCache(@NonNull Supplier<Optional<ByteArray>> getCachedBlob, @NonNull Consumer<ByteArray> writeCachedBlob) {
                if (getCachedBlob == null) {
                    throw new NullPointerException("getCachedBlob is marked non-null but is null");
                }
                if (writeCachedBlob == null) {
                    throw new NullPointerException("writeCachedBlob is marked non-null but is null");
                }
                return FidoMetadataDownloaderBuilder.finishRequiredSteps(this, null, getCachedBlob, writeCachedBlob);
            }

            @Generated
            private Step5(@NonNull Step4 step4, String blobJwt, URL blobUrl) {
                if (step4 == null) {
                    throw new NullPointerException("step4 is marked non-null but is null");
                }
                this.step4 = step4;
                this.blobJwt = blobJwt;
                this.blobUrl = blobUrl;
            }
        }

        public static class Step4 {
            @NonNull
            private final Step3 step3;
            private final File trustRootCacheFile;
            private final Supplier<Optional<ByteArray>> trustRootCacheSupplier;
            private final Consumer<ByteArray> trustRootCacheConsumer;

            public Step5 useDefaultBlob() {
                try {
                    return this.downloadBlob(new URL("https://mds.fidoalliance.org/"));
                }
                catch (MalformedURLException e) {
                    throw new RuntimeException("Bad hard-coded trust root certificate URL. Please file a bug report.", e);
                }
            }

            public Step5 downloadBlob(@NonNull URL url) {
                if (url == null) {
                    throw new NullPointerException("url is marked non-null but is null");
                }
                return new Step5(this, null, url);
            }

            public FidoMetadataDownloaderBuilder useBlob(@NonNull String blobJwt) {
                if (blobJwt == null) {
                    throw new NullPointerException("blobJwt is marked non-null but is null");
                }
                return FidoMetadataDownloaderBuilder.finishRequiredSteps(new Step5(this, blobJwt, null), null, null, null);
            }

            @Generated
            private Step4(@NonNull Step3 step3, File trustRootCacheFile, Supplier<Optional<ByteArray>> trustRootCacheSupplier, Consumer<ByteArray> trustRootCacheConsumer) {
                if (step3 == null) {
                    throw new NullPointerException("step3 is marked non-null but is null");
                }
                this.step3 = step3;
                this.trustRootCacheFile = trustRootCacheFile;
                this.trustRootCacheSupplier = trustRootCacheSupplier;
                this.trustRootCacheConsumer = trustRootCacheConsumer;
            }
        }

        public static class Step3 {
            @NonNull
            private final Step2 step2;
            private final X509Certificate trustRootCertificate;
            private final URL trustRootUrl;
            private final Set<ByteArray> trustRootSha256;

            public Step4 useTrustRootCacheFile(@NonNull File cacheFile) {
                if (cacheFile == null) {
                    throw new NullPointerException("cacheFile is marked non-null but is null");
                }
                return new Step4(this, cacheFile, null, null);
            }

            public Step4 useTrustRootCache(@NonNull Supplier<Optional<ByteArray>> getCachedTrustRootCert, @NonNull Consumer<ByteArray> writeCachedTrustRootCert) {
                if (getCachedTrustRootCert == null) {
                    throw new NullPointerException("getCachedTrustRootCert is marked non-null but is null");
                }
                if (writeCachedTrustRootCert == null) {
                    throw new NullPointerException("writeCachedTrustRootCert is marked non-null but is null");
                }
                return new Step4(this, null, getCachedTrustRootCert, writeCachedTrustRootCert);
            }

            @Generated
            private Step3(@NonNull Step2 step2, X509Certificate trustRootCertificate, URL trustRootUrl, Set<ByteArray> trustRootSha256) {
                if (step2 == null) {
                    throw new NullPointerException("step2 is marked non-null but is null");
                }
                this.step2 = step2;
                this.trustRootCertificate = trustRootCertificate;
                this.trustRootUrl = trustRootUrl;
                this.trustRootSha256 = trustRootSha256;
            }
        }

        public static class Step2 {
            @NonNull
            private final Set<String> expectedLegalHeaders;

            public Step3 useDefaultTrustRoot() {
                try {
                    return this.downloadTrustRoot(new URL("https://secure.globalsign.com/cacert/root-r3.crt"), Collections.singleton(ByteArray.fromHex((String)"cbb522d7b7f127ad6a0113865bdf1cd4102e7d0759af635a7cf4720dc963c53b")));
                }
                catch (MalformedURLException e) {
                    throw new RuntimeException("Bad hard-coded trust root certificate URL. Please file a bug report.", e);
                }
                catch (HexException e) {
                    throw new RuntimeException("Bad hard-coded trust root certificate hash. Please file a bug report.", e);
                }
            }

            public Step3 downloadTrustRoot(@NonNull URL url, @NonNull Set<ByteArray> acceptedCertSha256) {
                if (url == null) {
                    throw new NullPointerException("url is marked non-null but is null");
                }
                if (acceptedCertSha256 == null) {
                    throw new NullPointerException("acceptedCertSha256 is marked non-null but is null");
                }
                if (!"https".equals(url.getProtocol())) {
                    throw new IllegalArgumentException("Trust certificate download URL must be a HTTPS URL.");
                }
                return new Step3(this, null, url, acceptedCertSha256);
            }

            public Step4 useTrustRoot(@NonNull X509Certificate trustRootCertificate) {
                if (trustRootCertificate == null) {
                    throw new NullPointerException("trustRootCertificate is marked non-null but is null");
                }
                return new Step4(new Step3(this, trustRootCertificate, null, null), null, null, null);
            }

            @Generated
            private Step2(@NonNull Set<String> expectedLegalHeaders) {
                if (expectedLegalHeaders == null) {
                    throw new NullPointerException("expectedLegalHeaders is marked non-null but is null");
                }
                this.expectedLegalHeaders = expectedLegalHeaders;
            }
        }

        public static class Step1 {
            public Step2 expectLegalHeader(String ... expectedLegalHeaders) {
                if (expectedLegalHeaders == null) {
                    throw new NullPointerException("expectedLegalHeaders is marked non-null but is null");
                }
                return new Step2(Stream.of(expectedLegalHeaders).collect(Collectors.toSet()));
            }

            @Generated
            private Step1() {
            }
        }
    }
}

