/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.wicket.kendo.ui.dataviz.diagram;

import com.github.openjson.JSONObject;
import com.googlecode.wicket.jquery.core.IJQueryWidget;
import com.googlecode.wicket.jquery.core.JQueryBehavior;
import com.googlecode.wicket.jquery.core.JQueryGenericContainer;
import com.googlecode.wicket.jquery.core.Options;
import com.googlecode.wicket.jquery.core.behavior.AjaxCallbackBehavior;
import com.googlecode.wicket.jquery.core.behavior.ListModelBehavior;
import com.googlecode.wicket.jquery.core.converter.IJsonConverter;
import com.googlecode.wicket.jquery.core.converter.JsonConverter;
import com.googlecode.wicket.kendo.ui.KendoDataSource;
import com.googlecode.wicket.kendo.ui.KendoUIBehavior;
import com.googlecode.wicket.kendo.ui.dataviz.diagram.DiagramBehavior;
import com.googlecode.wicket.kendo.ui.dataviz.diagram.IDiagramListener;
import com.googlecode.wicket.kendo.ui.dataviz.diagram.IDiagramNode;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.util.ListModel;

public class Diagram<T extends IDiagramNode<T>>
extends JQueryGenericContainer<List<T>>
implements IDiagramListener {
    private static final long serialVersionUID = 1L;
    protected final Options options;
    private final IJsonConverter<T> converter;
    private AjaxCallbackBehavior modelBehavior;

    public Diagram(String id) {
        this(id, new Options(), (IJsonConverter<T>)new JsonConverter());
    }

    public Diagram(String id, Options options) {
        this(id, options, (IJsonConverter<T>)new JsonConverter());
    }

    public Diagram(String id, IJsonConverter<T> converter) {
        this(id, new Options(), converter);
    }

    public Diagram(String id, Options options, IJsonConverter<T> converter) {
        super(id);
        this.options = options;
        this.converter = converter;
    }

    public Diagram(String id, List<T> data) {
        this(id, (IModel<List<T>>)new ListModel(data), new Options(), (IJsonConverter<T>)new JsonConverter());
    }

    public Diagram(String id, List<T> data, IJsonConverter<T> converter) {
        this(id, (IModel<List<T>>)new ListModel(data), new Options(), converter);
    }

    public Diagram(String id, List<T> data, Options options) {
        this(id, (IModel<List<T>>)new ListModel(data), options, (IJsonConverter<T>)new JsonConverter());
    }

    public Diagram(String id, List<T> data, Options options, IJsonConverter<T> converter) {
        this(id, (IModel<List<T>>)new ListModel(data), options, converter);
    }

    public Diagram(String id, IModel<List<T>> model) {
        this(id, model, new Options(), (IJsonConverter<T>)new JsonConverter());
    }

    public Diagram(String id, IModel<List<T>> model, IJsonConverter<T> converter) {
        this(id, model, new Options(), converter);
    }

    public Diagram(String id, IModel<List<T>> model, Options options) {
        this(id, model, options, (IJsonConverter<T>)new JsonConverter());
    }

    public Diagram(String id, IModel<List<T>> model, Options options, IJsonConverter<T> converter) {
        super(id, model);
        this.options = options;
        this.converter = converter;
    }

    public String widget() {
        return KendoUIBehavior.widget((Component)this, "kendoDiagram");
    }

    public void reload(AjaxRequestTarget target) {
        target.add(new Component[]{this});
    }

    public void refresh(AjaxRequestTarget target) {
        target.appendJavaScript((CharSequence)String.format("var $w = %s; if ($w) { $w.dataSource.read(); }", this.widget()));
    }

    protected final CharSequence getCallbackUrl() {
        return this.modelBehavior.getCallbackUrl();
    }

    protected final IJsonConverter<T> getConverter() {
        return this.converter;
    }

    @Override
    public boolean isClickEventEnabled() {
        return false;
    }

    protected void onInitialize() {
        super.onInitialize();
        this.modelBehavior = this.newListModelBehavior(this.getModel(), this.getConverter());
        this.add(new Behavior[]{this.modelBehavior});
        this.add(new Behavior[]{IJQueryWidget.JQueryWidget.newWidgetBehavior((Component)this)});
    }

    public void onConfigure(JQueryBehavior behavior) {
    }

    protected void onConfigure(KendoDataSource.HierarchicalDataSource dataSource) {
        dataSource.set("schema", "{ model: { children: 'nodes' } }");
        String selector = IJQueryWidget.JQueryWidget.getSelector((Component)this);
        dataSource.set("requestStart", String.format("function () { kendo.ui.progress(jQuery('%s'), true); }", selector));
        dataSource.set("requestEnd", String.format("function () { kendo.ui.progress(jQuery('%s'), false); }", selector));
    }

    public void onBeforeRender(JQueryBehavior behavior) {
    }

    @Override
    public void onClick(AjaxRequestTarget target, JSONObject object) {
        this.onClick(target, (IDiagramNode)this.getConverter().toObject(object));
    }

    public void onClick(AjaxRequestTarget target, T object) {
    }

    public JQueryBehavior newWidgetBehavior(String selector) {
        return new DiagramBehavior(selector, this.options, this){
            private static final long serialVersionUID = 1L;

            @Override
            protected CharSequence getProviderUrl() {
                return Diagram.this.getCallbackUrl();
            }

            @Override
            protected void onConfigure(KendoDataSource.HierarchicalDataSource dataSource) {
                Diagram.this.onConfigure(dataSource);
            }
        };
    }

    protected AjaxCallbackBehavior newListModelBehavior(IModel<List<T>> model, IJsonConverter<T> converter) {
        return new ListModelBehavior(model, converter);
    }
}

