/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket;

import java.lang.ref.WeakReference;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZonedDateTime;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.wicket.IConverterLocator;
import org.apache.wicket.util.convert.ConversionException;
import org.apache.wicket.util.convert.IConverter;
import org.apache.wicket.util.convert.converter.BigDecimalConverter;
import org.apache.wicket.util.convert.converter.BigIntegerConverter;
import org.apache.wicket.util.convert.converter.BooleanConverter;
import org.apache.wicket.util.convert.converter.ByteConverter;
import org.apache.wicket.util.convert.converter.CalendarConverter;
import org.apache.wicket.util.convert.converter.CharacterConverter;
import org.apache.wicket.util.convert.converter.DateConverter;
import org.apache.wicket.util.convert.converter.DoubleConverter;
import org.apache.wicket.util.convert.converter.FloatConverter;
import org.apache.wicket.util.convert.converter.IntegerConverter;
import org.apache.wicket.util.convert.converter.LocalDateConverter;
import org.apache.wicket.util.convert.converter.LocalDateTimeConverter;
import org.apache.wicket.util.convert.converter.LocalTimeConverter;
import org.apache.wicket.util.convert.converter.LongConverter;
import org.apache.wicket.util.convert.converter.ShortConverter;
import org.apache.wicket.util.convert.converter.SqlDateConverter;
import org.apache.wicket.util.convert.converter.SqlTimeConverter;
import org.apache.wicket.util.convert.converter.SqlTimestampConverter;
import org.apache.wicket.util.convert.converter.ZonedDateTimeConverter;
import org.apache.wicket.util.lang.Args;
import org.apache.wicket.util.lang.Objects;

public class ConverterLocator
implements IConverterLocator {
    private static final long serialVersionUID = 1L;
    private final Map<String, IConverter<?>> classToConverter = new HashMap();

    public ConverterLocator() {
        this.set(Boolean.TYPE, BooleanConverter.INSTANCE);
        this.set(Boolean.class, BooleanConverter.INSTANCE);
        this.set(Byte.TYPE, ByteConverter.INSTANCE);
        this.set(Byte.class, ByteConverter.INSTANCE);
        this.set(Character.TYPE, CharacterConverter.INSTANCE);
        this.set(Character.class, CharacterConverter.INSTANCE);
        this.set(Double.TYPE, DoubleConverter.INSTANCE);
        this.set(Double.class, DoubleConverter.INSTANCE);
        this.set(Float.TYPE, FloatConverter.INSTANCE);
        this.set(Float.class, FloatConverter.INSTANCE);
        this.set(Integer.TYPE, IntegerConverter.INSTANCE);
        this.set(Integer.class, IntegerConverter.INSTANCE);
        this.set(Long.TYPE, LongConverter.INSTANCE);
        this.set(Long.class, LongConverter.INSTANCE);
        this.set(Short.TYPE, ShortConverter.INSTANCE);
        this.set(Short.class, ShortConverter.INSTANCE);
        this.set(BigDecimal.class, (IConverter<?>)new BigDecimalConverter());
        this.set(BigInteger.class, (IConverter<?>)new BigIntegerConverter());
        this.set(java.util.Date.class, (IConverter<?>)new DateConverter());
        this.set(Date.class, (IConverter<?>)new SqlDateConverter());
        this.set(Time.class, (IConverter<?>)new SqlTimeConverter());
        this.set(Timestamp.class, (IConverter<?>)new SqlTimestampConverter());
        this.set(Calendar.class, (IConverter<?>)new CalendarConverter());
        this.set(LocalDate.class, (IConverter<?>)new LocalDateConverter());
        this.set(LocalDateTime.class, (IConverter<?>)new LocalDateTimeConverter());
        this.set(LocalTime.class, (IConverter<?>)new LocalTimeConverter());
        this.set(ZonedDateTime.class, (IConverter<?>)new ZonedDateTimeConverter());
    }

    public final <C> IConverter<C> get(Class<C> c) {
        return this.classToConverter.get(c.getName());
    }

    @Override
    public final <C> IConverter<C> getConverter(Class<C> type) {
        if (type == null) {
            DefaultConverter<String> converter = new DefaultConverter<String>(String.class);
            return converter;
        }
        IConverter<C> converter = this.get(type);
        if (converter == null) {
            return new DefaultConverter<C>(type);
        }
        return converter;
    }

    public final IConverter<?> remove(Class<?> c) {
        return this.classToConverter.remove(c.getName());
    }

    public final IConverter<?> set(Class<?> c, IConverter<?> converter) {
        Args.notNull(c, (String)"Class");
        Args.notNull(converter, (String)"converter");
        return this.classToConverter.put(c.getName(), converter);
    }

    private static class DefaultConverter<C>
    implements IConverter<C> {
        private static final long serialVersionUID = 1L;
        private final transient WeakReference<Class<C>> type;

        private DefaultConverter(Class<C> type) {
            this.type = new WeakReference<Class<C>>(type);
        }

        public C convertToObject(String value, Locale locale) {
            if (value == null) {
                return null;
            }
            Class theType = (Class)this.type.get();
            if (value.isEmpty()) {
                if (String.class.equals((Object)theType)) {
                    return (C)theType.cast("");
                }
                return null;
            }
            try {
                Object converted = Objects.convertValue((Object)value, (Class)theType);
                if (converted != null) {
                    return (C)converted;
                }
                if (theType != null && theType.isInstance(value)) {
                    return (C)theType.cast(value);
                }
            }
            catch (Exception e) {
                throw new ConversionException(e.getMessage(), (Throwable)e).setSourceValue((Object)value);
            }
            throw new ConversionException("Could not convert value: " + value + " to type: " + theType.getName() + ". Could not find compatible converter.").setSourceValue((Object)value);
        }

        public String convertToString(C value, Locale locale) {
            if (value == null || value instanceof String && ((String)value).isEmpty()) {
                return "";
            }
            try {
                return (String)Objects.convertValue(value, String.class);
            }
            catch (RuntimeException e) {
                throw new ConversionException("Could not convert object of type: " + value.getClass() + " to String. Possible its #toString() returned null. Either install a custom converter (see IConverterLocator) or override #toString() to return a non-null value.", (Throwable)e).setSourceValue(value).setConverter((IConverter)this);
            }
        }
    }
}

