/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.services.web;

import javax.annotation.Nonnull;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.authentication.AuthenticationServiceSelectionPlan;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.services.WebBasedRegisteredService;
import org.apereo.cas.services.web.CasThemeResourceBundleMessageSource;
import org.apereo.cas.util.ResourceUtils;
import org.apereo.cas.util.spring.SpringExpressionLanguageValueResolver;
import org.apereo.cas.web.support.WebUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.web.servlet.theme.AbstractThemeResolver;
import org.springframework.webflow.execution.RequestContext;
import org.springframework.webflow.execution.RequestContextHolder;

public class RegisteredServiceThemeResolver
extends AbstractThemeResolver {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(RegisteredServiceThemeResolver.class);
    protected final ObjectProvider<ServicesManager> servicesManager;
    protected final ObjectProvider<AuthenticationServiceSelectionPlan> authenticationRequestServiceSelectionStrategies;
    protected final ObjectProvider<CasConfigurationProperties> casProperties;

    @Nonnull
    public String resolveThemeName(@Nonnull HttpServletRequest request) {
        RequestContext context = RequestContextHolder.getRequestContext();
        WebApplicationService serviceContext = WebUtils.getService((RequestContext)context);
        Service service = ((AuthenticationServiceSelectionPlan)this.authenticationRequestServiceSelectionStrategies.getObject()).resolveService((Service)serviceContext);
        if (service == null) {
            LOGGER.trace("No service is found in the request context. Falling back to the default theme [{}]", (Object)this.getDefaultThemeName());
            return this.rememberThemeName(request);
        }
        WebBasedRegisteredService rService = (WebBasedRegisteredService)((ServicesManager)this.servicesManager.getObject()).findServiceBy(service);
        if (rService == null || !rService.getAccessStrategy().isServiceAccessAllowed()) {
            LOGGER.warn("No registered service is found to match [{}] or access is denied. Using default theme [{}]", (Object)service, (Object)this.getDefaultThemeName());
            return this.rememberThemeName(request);
        }
        if (StringUtils.isBlank((CharSequence)rService.getTheme())) {
            LOGGER.trace("No theme name is specified for service [{}]. Using default theme [{}]", (Object)rService, (Object)this.getDefaultThemeName());
            return this.rememberThemeName(request);
        }
        String themeName = this.determineThemeNameToChoose(request, service, rService);
        return this.rememberThemeName(request, themeName);
    }

    public void setThemeName(@Nonnull HttpServletRequest request, HttpServletResponse response, String themeName) {
    }

    /*
     * Exception decompiling
     */
    protected String determineThemeNameToChoose(HttpServletRequest request, Service service, WebBasedRegisteredService rService) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK], 7[CATCHBLOCK]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected String rememberThemeName(HttpServletRequest request) {
        return this.rememberThemeName(request, this.getDefaultThemeName());
    }

    protected String rememberThemeName(HttpServletRequest request, String themeName) {
        String attributeName = ((CasConfigurationProperties)this.casProperties.getObject()).getTheme().getParamName();
        LOGGER.trace("Storing theme [{}] as a request attribute under [{}]", (Object)themeName, (Object)attributeName);
        request.setAttribute(attributeName, (Object)themeName);
        return themeName;
    }

    protected String resolveThemeForService(WebBasedRegisteredService registeredService, HttpServletRequest request) {
        String theme = SpringExpressionLanguageValueResolver.getInstance().resolve(registeredService.getTheme());
        if (((CasConfigurationProperties)this.casProperties.getObject()).getView().getTemplatePrefixes().stream().map(prefix -> StringUtils.appendIfMissing((String)prefix, (CharSequence)"/", (CharSequence[])new CharSequence[0]).concat(theme).concat(".properties")).anyMatch(ResourceUtils::doesResourceExist)) {
            LOGGER.trace("Found custom external theme [{}] for service [{}]", (Object)theme, (Object)registeredService.getName());
            return theme;
        }
        CasThemeResourceBundleMessageSource messageSource = new CasThemeResourceBundleMessageSource();
        messageSource.setBasename(theme);
        if (messageSource.doGetBundle(theme, request.getLocale()) != null) {
            LOGGER.trace("Found custom theme [{}] for service [{}]", (Object)theme, (Object)registeredService.getName());
            return theme;
        }
        LOGGER.warn("Theme [{}] for service [{}] cannot be located", (Object)theme, (Object)registeredService.getName());
        return null;
    }

    @Generated
    public RegisteredServiceThemeResolver(ObjectProvider<ServicesManager> servicesManager, ObjectProvider<AuthenticationServiceSelectionPlan> authenticationRequestServiceSelectionStrategies, ObjectProvider<CasConfigurationProperties> casProperties) {
        this.servicesManager = servicesManager;
        this.authenticationRequestServiceSelectionStrategies = authenticationRequestServiceSelectionStrategies;
        this.casProperties = casProperties;
    }
}

