/*
 * Decompiled with CFR 0.152.
 */
package org.identityconnectors.framework.impl.api.local.operations;

import org.identityconnectors.common.logging.Log;
import org.identityconnectors.framework.api.ResultsHandlerConfiguration;
import org.identityconnectors.framework.impl.api.APIConfigurationImpl;
import org.identityconnectors.framework.impl.api.local.JavaClassProperties;
import org.identityconnectors.framework.impl.api.local.LocalConnectorInfoImpl;
import org.identityconnectors.framework.spi.Configuration;
import org.identityconnectors.framework.spi.StatefulConfiguration;

public class OperationalContext {
    private static final Log LOG = Log.getLog(OperationalContext.class);
    protected final LocalConnectorInfoImpl connectorInfo;
    protected final APIConfigurationImpl apiConfiguration;
    private volatile Configuration configuration;

    public OperationalContext(LocalConnectorInfoImpl connectorInfo, APIConfigurationImpl apiConfiguration) {
        this.connectorInfo = connectorInfo;
        this.apiConfiguration = apiConfiguration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Configuration getConfiguration() {
        if (null == this.configuration) {
            OperationalContext operationalContext = this;
            synchronized (operationalContext) {
                if (null == this.configuration) {
                    this.configuration = JavaClassProperties.createBean(this.apiConfiguration.getConfigurationProperties(), this.connectorInfo.getConnectorConfigurationClass());
                }
            }
        }
        return this.configuration;
    }

    protected LocalConnectorInfoImpl getConnectorInfo() {
        return this.connectorInfo;
    }

    public ResultsHandlerConfiguration getResultsHandlerConfiguration() {
        return new ResultsHandlerConfiguration(this.apiConfiguration.getResultsHandlerConfiguration());
    }

    public void dispose() {
        if (this.configuration instanceof StatefulConfiguration) {
            try {
                StatefulConfiguration config = (StatefulConfiguration)this.configuration;
                this.configuration = null;
                config.release();
            }
            catch (Exception e) {
                LOG.warn((Throwable)e, null, new Object[0]);
            }
        }
    }
}

