/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.flow.configurer;

import java.util.Map;
import javax.security.auth.login.AccountExpiredException;
import javax.security.auth.login.AccountLockedException;
import javax.security.auth.login.AccountNotFoundException;
import javax.security.auth.login.CredentialExpiredException;
import javax.security.auth.login.FailedLoginException;
import lombok.Generated;
import org.apereo.cas.authentication.PrincipalException;
import org.apereo.cas.authentication.adaptive.UnauthorizedAuthenticationException;
import org.apereo.cas.authentication.credential.RememberMeUsernamePasswordCredential;
import org.apereo.cas.authentication.credential.UsernamePasswordCredential;
import org.apereo.cas.authentication.exceptions.AccountDisabledException;
import org.apereo.cas.authentication.exceptions.AccountPasswordMustChangeException;
import org.apereo.cas.authentication.exceptions.InvalidLoginLocationException;
import org.apereo.cas.authentication.exceptions.InvalidLoginTimeException;
import org.apereo.cas.authentication.principal.Response;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.services.UnauthorizedServiceException;
import org.apereo.cas.services.UnauthorizedServiceForPrincipalException;
import org.apereo.cas.services.UnauthorizedSsoServiceException;
import org.apereo.cas.ticket.UnsatisfiedAuthenticationPolicyException;
import org.apereo.cas.util.LoggingUtils;
import org.apereo.cas.web.flow.StringToCharArrayConverter;
import org.apereo.cas.web.flow.actions.ConsumerExecutionAction;
import org.apereo.cas.web.flow.configurer.AbstractCasWebflowConfigurer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.webflow.action.SetAction;
import org.springframework.webflow.core.collection.MutableAttributeMap;
import org.springframework.webflow.definition.registry.FlowDefinitionRegistry;
import org.springframework.webflow.engine.ActionList;
import org.springframework.webflow.engine.ActionState;
import org.springframework.webflow.engine.DecisionState;
import org.springframework.webflow.engine.EndState;
import org.springframework.webflow.engine.Flow;
import org.springframework.webflow.engine.FlowExecutionExceptionHandler;
import org.springframework.webflow.engine.History;
import org.springframework.webflow.engine.NoMatchingTransitionException;
import org.springframework.webflow.engine.Transition;
import org.springframework.webflow.engine.TransitionableState;
import org.springframework.webflow.engine.ViewState;
import org.springframework.webflow.engine.builder.BinderConfiguration;
import org.springframework.webflow.engine.builder.support.FlowBuilderServices;
import org.springframework.webflow.engine.support.TransitionExecutingFlowExecutionExceptionHandler;
import org.springframework.webflow.execution.Action;
import org.springframework.webflow.execution.repository.NoSuchFlowExecutionException;

public class DefaultLoginWebflowConfigurer
extends AbstractCasWebflowConfigurer {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultLoginWebflowConfigurer.class);

    public DefaultLoginWebflowConfigurer(FlowBuilderServices flowBuilderServices, FlowDefinitionRegistry flowDefinitionRegistry, ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties) {
        super(flowBuilderServices, flowDefinitionRegistry, applicationContext, casProperties);
    }

    @Override
    protected void doInitialize() {
        Flow flow = this.getLoginFlow();
        if (flow != null) {
            this.createInitialFlowActions(flow);
            this.createDefaultGlobalExceptionHandlers(flow);
            this.createDefaultEndStates(flow);
            this.createDefaultDecisionStates(flow);
            this.createDefaultActionStates(flow);
            this.createDefaultViewStates(flow);
            this.createRememberMeAuthnWebflowConfig(flow);
            this.setStartState(flow, "initialAuthenticationRequestValidationCheck");
        }
    }

    protected void createInitialFlowActions(Flow flow) {
        ActionList startActionList = flow.getStartActionList();
        startActionList.add((Action)this.createEvaluateAction("initialFlowSetupAction"));
        startActionList.add((Action)this.createEvaluateAction("verifyRequiredServiceAction"));
    }

    protected void createDefaultViewStates(Flow flow) {
        this.createLoginFormView(flow);
        this.createAuthenticationWarningMessagesView(flow);
    }

    protected void createLoginFormView(Flow flow) {
        Map<String, Map<String, String>> propertiesToBind = Map.of("username", Map.of("required", "true"), "password", Map.of("converter", StringToCharArrayConverter.ID), "source", Map.of("required", "true"));
        BinderConfiguration binder = this.createStateBinderConfiguration(propertiesToBind);
        this.casProperties.getView().getCustomLoginFormFields().forEach((field, props) -> {
            String fieldName = String.format("customFields[%s]", field);
            binder.addBinding(new BinderConfiguration.Binding(fieldName, props.getConverter(), props.isRequired()));
        });
        ViewState state = this.createViewState(flow, "viewLoginForm", "login/casLoginView", binder);
        state.getRenderActionList().add((Action)this.createEvaluateAction("renderLoginFormAction"));
        this.createStateModelBinding((TransitionableState)state, "credential", UsernamePasswordCredential.class);
        Transition transition = this.createTransitionForState((TransitionableState)state, "submit", "realSubmit");
        MutableAttributeMap attributes = transition.getAttributes();
        attributes.put("bind", (Object)Boolean.TRUE);
        attributes.put("validate", (Object)Boolean.TRUE);
        attributes.put("history", (Object)History.INVALIDATE);
    }

    protected void createAuthenticationWarningMessagesView(Flow flow) {
        ViewState state = this.createViewState(flow, "showAuthenticationWarningMessages", "login/casLoginMessageView");
        SetAction setAction = this.createSetAction("requestScope.messages", "messageContext.allMessages");
        state.getEntryActionList().add((Action)setAction);
        this.createTransitionForState((TransitionableState)state, "proceed", "proceedFromAuthenticationWarningView");
        ActionState proceedAction = this.createActionState(flow, "proceedFromAuthenticationWarningView");
        proceedAction.getActionList().add((Action)this.createEvaluateAction("sendTicketGrantingTicketAction"));
        this.createStateDefaultTransition((TransitionableState)proceedAction, "serviceCheck");
    }

    protected void createRememberMeAuthnWebflowConfig(Flow flow) {
        if (this.casProperties.getTicket().getTgt().getRememberMe().isEnabled()) {
            this.createFlowVariable(flow, "credential", RememberMeUsernamePasswordCredential.class);
            ViewState state = this.getState(flow, "viewLoginForm", ViewState.class);
            BinderConfiguration cfg = this.getViewStateBinderConfiguration(state);
            cfg.addBinding(new BinderConfiguration.Binding("rememberMe", null, false));
        } else {
            this.createFlowVariable(flow, "credential", UsernamePasswordCredential.class);
        }
    }

    protected void createDefaultActionStates(Flow flow) {
        this.createInitialLoginAction(flow);
        this.createRealSubmitAction(flow);
        this.createInitialAuthenticationRequestValidationCheckAction(flow);
        this.createCreateTicketGrantingTicketAction(flow);
        this.createSendTicketGrantingTicketAction(flow);
        this.createGenerateServiceTicketAction(flow);
        this.createGatewayServicesMgmtAction(flow);
        this.createServiceAuthorizationCheckAction(flow);
        this.createRedirectToServiceActionState(flow);
        this.createHandleAuthenticationFailureAction(flow);
        this.createTerminateSessionAction(flow);
        this.createTicketGrantingTicketCheckAction(flow);
    }

    protected void createRealSubmitAction(Flow flow) {
        ActionState state = this.createActionState(flow, "realSubmit", "authenticationViaFormAction");
        this.createTransitionForState((TransitionableState)state, "warn", "warn");
        this.createTransitionForState((TransitionableState)state, "success", "createTicketGrantingTicket");
        this.createTransitionForState((TransitionableState)state, "successWithWarnings", "showAuthenticationWarningMessages");
        this.createTransitionForState((TransitionableState)state, "authenticationFailure", "handleAuthenticationFailure");
        this.createTransitionForState((TransitionableState)state, "error", "initializeLoginForm");
        this.createTransitionForState((TransitionableState)state, "valid", "serviceCheck");
        this.createTransitionForState((TransitionableState)state, "generateServiceTicket", "generateServiceTicket");
    }

    protected void createTicketGrantingTicketCheckAction(Flow flow) {
        ActionState action = this.createActionState(flow, "ticketGrantingTicketCheck", "ticketGrantingTicketCheckAction");
        this.createTransitionForState((TransitionableState)action, "notExists", "gatewayRequestCheck");
        this.createTransitionForState((TransitionableState)action, "invalid", "terminateSession");
        this.createTransitionForState((TransitionableState)action, "valid", "hasServiceCheck");
    }

    protected void createInitialAuthenticationRequestValidationCheckAction(Flow flow) {
        ActionState action = this.createActionState(flow, "initialAuthenticationRequestValidationCheck", "initialAuthenticationRequestValidationAction");
        action.getEntryActionList().add((Action)this.createEvaluateAction("verifyRequiredServiceAction"));
        this.createTransitionForState((TransitionableState)action, "authenticationFailure", "handleAuthenticationFailure");
        this.createTransitionForState((TransitionableState)action, "error", "initializeLoginForm");
        this.createTransitionForState((TransitionableState)action, "success", "ticketGrantingTicketCheck");
        this.createTransitionForState((TransitionableState)action, "successWithWarnings", "showAuthenticationWarningMessages");
    }

    protected void createTerminateSessionAction(Flow flow) {
        ActionState terminateSession = this.createActionState(flow, "terminateSession", (Action)this.createEvaluateAction("terminateSessionAction"));
        this.createStateDefaultTransition((TransitionableState)terminateSession, "gatewayRequestCheck");
    }

    protected void createSendTicketGrantingTicketAction(Flow flow) {
        ActionState action = this.createActionState(flow, "sendTicketGrantingTicket", "sendTicketGrantingTicketAction");
        action.getExitActionList().add((Action)this.createEvaluateAction("singleSignOnSessionCreated"));
        this.createTransitionForState((TransitionableState)action, "success", "serviceCheck");
        this.createTransitionForState((TransitionableState)action, "successWithWarnings", "showAuthenticationWarningMessages");
    }

    protected void createCreateTicketGrantingTicketAction(Flow flow) {
        ActionState action = this.createActionState(flow, "createTicketGrantingTicket", "createTicketGrantingTicketAction");
        this.createTransitionForState((TransitionableState)action, "successWithWarnings", "showAuthenticationWarningMessages");
        this.createTransitionForState((TransitionableState)action, "success", "sendTicketGrantingTicket");
    }

    protected void createGenerateServiceTicketAction(Flow flow) {
        ActionState handler = this.createActionState(flow, "generateServiceTicket", (Action)this.createEvaluateAction("generateServiceTicketAction"));
        this.createTransitionForState((TransitionableState)handler, "success", "redirect");
        this.createTransitionForState((TransitionableState)handler, "warn", "warn");
        this.createTransitionForState((TransitionableState)handler, "authenticationFailure", "handleAuthenticationFailure");
        this.createTransitionForState((TransitionableState)handler, "error", "initializeLoginForm");
        this.createTransitionForState((TransitionableState)handler, "gateway", "gatewayServicesManagementCheck");
    }

    protected void createHandleAuthenticationFailureAction(Flow flow) {
        ActionState handler = this.createActionState(flow, "handleAuthenticationFailure", "authenticationExceptionHandler");
        this.createTransitionForState((TransitionableState)handler, AccountDisabledException.class.getSimpleName(), "casAccountDisabledView");
        this.createTransitionForState((TransitionableState)handler, AccountLockedException.class.getSimpleName(), "casAccountLockedView");
        this.createTransitionForState((TransitionableState)handler, AccountExpiredException.class.getSimpleName(), "casExpiredPassView");
        this.createTransitionForState((TransitionableState)handler, AccountLockedException.class.getSimpleName(), "casAccountLockedView");
        this.createTransitionForState((TransitionableState)handler, AccountPasswordMustChangeException.class.getSimpleName(), "casMustChangePassView");
        this.createTransitionForState((TransitionableState)handler, CredentialExpiredException.class.getSimpleName(), "casExpiredPassView");
        this.createTransitionForState((TransitionableState)handler, InvalidLoginLocationException.class.getSimpleName(), "casBadWorkstationView");
        this.createTransitionForState((TransitionableState)handler, InvalidLoginTimeException.class.getSimpleName(), "casBadHoursView");
        this.createTransitionForState((TransitionableState)handler, FailedLoginException.class.getSimpleName(), "initializeLoginForm");
        this.createTransitionForState((TransitionableState)handler, AccountNotFoundException.class.getSimpleName(), "initializeLoginForm");
        this.createTransitionForState((TransitionableState)handler, UnauthorizedServiceForPrincipalException.class.getSimpleName(), "initializeLoginForm");
        this.createTransitionForState((TransitionableState)handler, PrincipalException.class.getSimpleName(), "initializeLoginForm");
        this.createTransitionForState((TransitionableState)handler, UnsatisfiedAuthenticationPolicyException.class.getSimpleName(), "initializeLoginForm");
        this.createTransitionForState((TransitionableState)handler, UnauthorizedAuthenticationException.class.getSimpleName(), "casAuthenticationBlockedView");
        this.createTransitionForState((TransitionableState)handler, "serviceUnauthorizedCheck", "serviceUnauthorizedCheck");
        this.createStateDefaultTransition((TransitionableState)handler, "initializeLoginForm");
        handler.getEntryActionList().add((Action)this.createEvaluateAction("clearWebflowCredentialsAction"));
    }

    protected void createRedirectToServiceActionState(Flow flow) {
        ActionState redirectToView = this.createActionState(flow, "redirect", "redirectToServiceAction");
        this.createTransitionForState((TransitionableState)redirectToView, Response.ResponseType.POST.name().toLowerCase(), "postView");
        this.createTransitionForState((TransitionableState)redirectToView, Response.ResponseType.HEADER.name().toLowerCase(), "headerView");
        this.createTransitionForState((TransitionableState)redirectToView, Response.ResponseType.REDIRECT.name().toLowerCase(), "redirectView");
        redirectToView.getExitActionList().add((Action)this.createEvaluateAction("clearWebflowCredentialsAction"));
    }

    protected void createServiceAuthorizationCheckAction(Flow flow) {
        ActionState serviceAuthorizationCheck = this.createActionState(flow, "serviceAuthorizationCheck", "serviceAuthorizationCheck");
        this.createStateDefaultTransition((TransitionableState)serviceAuthorizationCheck, "initializeLoginForm");
    }

    protected void createGatewayServicesMgmtAction(Flow flow) {
        ActionState gatewayServicesManagementCheck = this.createActionState(flow, "gatewayServicesManagementCheck", "gatewayServicesManagementCheck");
        this.createTransitionForState((TransitionableState)gatewayServicesManagementCheck, "success", "redirect");
    }

    protected void createDefaultEndStates(Flow flow) {
        this.createRedirectUnauthorizedServiceUrlEndState(flow);
        this.createServiceErrorEndState(flow);
        this.createWebflowConfigurationErrorEndState(flow);
        this.createServiceErrorEndState(flow);
        this.createRedirectEndState(flow);
        this.createPostEndState(flow);
        this.createInjectHeadersActionState(flow);
        this.createGenericLoginSuccessEndState(flow);
        this.createServiceWarningViewState(flow);
        this.createEndWebflowEndState(flow);
    }

    protected void createEndWebflowEndState(Flow flow) {
        this.createEndState(flow, "endWebflowExecution");
    }

    protected void createRedirectEndState(Flow flow) {
        this.createEndState(flow, "redirectView", "requestScope.url", true);
    }

    protected void createPostEndState(Flow flow) {
        this.createEndState(flow, "postView", "casPostResponseView");
    }

    protected void createInjectHeadersActionState(Flow flow) {
        ActionState headerState = this.createActionState(flow, "headerView", "injectResponseHeadersAction");
        this.createTransitionForState((TransitionableState)headerState, "success", "endWebflowExecution");
        this.createTransitionForState((TransitionableState)headerState, "redirect", "redirectView");
    }

    protected void createRedirectUnauthorizedServiceUrlEndState(Flow flow) {
        EndState state = this.createEndState(flow, "viewRedirectToUnauthorizedUrlView", "flowScope.unauthorizedRedirectUrl", true);
        state.getEntryActionList().add((Action)this.createEvaluateAction("redirectUnauthorizedServiceUrlAction"));
    }

    protected void createServiceErrorEndState(Flow flow) {
        this.createEndState(flow, "viewServiceErrorView", "error/casServiceErrorView");
    }

    protected void createWebflowConfigurationErrorEndState(Flow flow) {
        EndState state = this.createEndState(flow, "viewWebflowConfigurationErrorView", "error/casWebflowConfigErrorView");
        state.getEntryActionList().add((Action)new ConsumerExecutionAction(context -> {
            if (context.getFlashScope().contains("rootCauseException")) {
                Exception rootException = (Exception)context.getFlashScope().get("rootCauseException");
                LoggingUtils.error((Logger)LOGGER, (Throwable)rootException);
            }
        }));
    }

    protected void createGenericLoginSuccessEndState(Flow flow) {
        EndState state = this.createEndState(flow, "viewGenericLoginSuccess", "login/casGenericSuccessView");
        state.getEntryActionList().add((Action)this.createEvaluateAction("genericSuccessViewAction"));
    }

    protected void createServiceWarningViewState(Flow flow) {
        ViewState stateWarning = this.createViewState(flow, "showWarningView", "login/casConfirmView");
        this.createTransitionForState((TransitionableState)stateWarning, "success", "finalizeWarning");
        ActionState finalizeWarn = this.createActionState(flow, "finalizeWarning", "serviceWarningAction");
        this.createTransitionForState((TransitionableState)finalizeWarn, "redirect", "redirect");
    }

    protected void createDefaultGlobalExceptionHandlers(Flow flow) {
        TransitionExecutingFlowExecutionExceptionHandler h = new TransitionExecutingFlowExecutionExceptionHandler();
        h.add(UnauthorizedSsoServiceException.class, "viewLoginForm");
        h.add(NoSuchFlowExecutionException.class, "viewServiceErrorView");
        h.add(UnauthorizedServiceException.class, "serviceUnauthorizedCheck");
        h.add(UnauthorizedServiceForPrincipalException.class, "serviceUnauthorizedCheck");
        h.add(PrincipalException.class, "serviceUnauthorizedCheck");
        h.add(NoMatchingTransitionException.class, "viewWebflowConfigurationErrorView");
        flow.getExceptionHandlerSet().add((FlowExecutionExceptionHandler)h);
    }

    protected void createDefaultDecisionStates(Flow flow) {
        this.createServiceUnauthorizedCheckDecisionState(flow);
        this.createServiceCheckDecisionState(flow);
        this.createWarnDecisionState(flow);
        this.createGatewayRequestCheckDecisionState(flow);
        this.createHasServiceCheckDecisionState(flow);
        this.createRenewCheckActionState(flow);
    }

    protected void createServiceUnauthorizedCheckDecisionState(Flow flow) {
        DecisionState decision = this.createDecisionState(flow, "serviceUnauthorizedCheck", "flowScope.unauthorizedRedirectUrl != null", "viewRedirectToUnauthorizedUrlView", "viewServiceErrorView");
        decision.getEntryActionList().add((Action)this.createEvaluateAction("setServiceUnauthorizedRedirectUrlAction"));
    }

    protected void createServiceCheckDecisionState(Flow flow) {
        this.createDecisionState(flow, "serviceCheck", "flowScope.service != null", "generateServiceTicket", "viewGenericLoginSuccess");
    }

    protected void createWarnDecisionState(Flow flow) {
        this.createDecisionState(flow, "warn", "flowScope.warnCookieValue", "showWarningView", "redirect");
    }

    protected void createGatewayRequestCheckDecisionState(Flow flow) {
        this.createDecisionState(flow, "gatewayRequestCheck", "requestParameters.gateway != '' and requestParameters.gateway != null and flowScope.service != null", "gatewayServicesManagementCheck", "serviceAuthorizationCheck");
    }

    protected void createHasServiceCheckDecisionState(Flow flow) {
        this.createDecisionState(flow, "hasServiceCheck", "flowScope.service != null", "renewRequestCheck", "viewGenericLoginSuccess");
    }

    protected void createRenewCheckActionState(Flow flow) {
        ActionState action = this.createActionState(flow, "renewRequestCheck", "renewAuthenticationRequestCheckAction");
        this.createTransitionForState((TransitionableState)action, "proceed", "generateServiceTicket");
        this.createTransitionForState((TransitionableState)action, "renew", "serviceAuthorizationCheck");
        this.createStateDefaultTransition((TransitionableState)action, "serviceAuthorizationCheck");
    }

    private void createInitialLoginAction(Flow flow) {
        ActionState state = this.createActionState(flow, "initializeLoginForm", "initializeLoginAction");
        this.createTransitionForState((TransitionableState)state, "success", "afterInitializeLoginForm");
        ActionState afterState = this.createActionState(flow, "afterInitializeLoginForm", (Action)this.createSetAction("requestScope.initialized", "true"));
        this.createTransitionForState((TransitionableState)afterState, "success", "viewLoginForm");
    }
}

