/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.pac4j.authentication.clients;

import com.github.benmanes.caffeine.cache.Cache;
import java.util.Collection;
import java.util.Optional;
import org.apereo.cas.authentication.CasSSLContext;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.support.pac4j.authentication.clients.BaseDelegatedClientFactory;
import org.apereo.cas.support.pac4j.authentication.clients.DelegatedClientFactoryCustomizer;
import org.jooq.lambda.Unchecked;
import org.pac4j.core.client.IndirectClient;
import org.pac4j.saml.client.SAML2Client;
import org.pac4j.saml.store.SAMLMessageStoreFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.ObjectProvider;

public class DefaultDelegatedClientFactory
extends BaseDelegatedClientFactory
implements DisposableBean {
    public DefaultDelegatedClientFactory(CasConfigurationProperties casProperties, Collection<DelegatedClientFactoryCustomizer> customizers, CasSSLContext casSSLContext, ObjectProvider<SAMLMessageStoreFactory> samlMessageStoreFactory, Cache<String, Collection<IndirectClient>> clientsCache) {
        super(casProperties, customizers, casSSLContext, samlMessageStoreFactory, clientsCache);
    }

    @Override
    protected Collection<IndirectClient> loadClients() {
        return this.buildAllIdentityProviders(this.casProperties);
    }

    public void destroy() {
        Optional.ofNullable(this.getCachedClients()).stream().filter(client -> client instanceof SAML2Client).map(SAML2Client.class::cast).forEach(Unchecked.consumer(SAML2Client::destroy));
    }
}

