/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.impl.resource.authenticator;

import com.okta.commons.http.HttpHeaders;
import com.okta.commons.lang.Assert;
import com.okta.sdk.impl.ds.InternalDataStore;
import com.okta.sdk.impl.resource.AbstractInstanceResource;
import com.okta.sdk.impl.resource.DateProperty;
import com.okta.sdk.impl.resource.DefaultVoidResource;
import com.okta.sdk.impl.resource.EnumProperty;
import com.okta.sdk.impl.resource.MapProperty;
import com.okta.sdk.impl.resource.Property;
import com.okta.sdk.impl.resource.ResourceReference;
import com.okta.sdk.impl.resource.StringProperty;
import com.okta.sdk.resource.Resource;
import com.okta.sdk.resource.authenticator.Authenticator;
import com.okta.sdk.resource.authenticator.AuthenticatorProvider;
import com.okta.sdk.resource.authenticator.AuthenticatorSettings;
import com.okta.sdk.resource.authenticator.AuthenticatorStatus;
import com.okta.sdk.resource.authenticator.AuthenticatorType;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DefaultAuthenticator
extends AbstractInstanceResource<Authenticator>
implements Authenticator {
    private static final MapProperty linksProperty = new MapProperty("_links");
    private static final DateProperty createdProperty = new DateProperty("created");
    private static final StringProperty idProperty = new StringProperty("id");
    private static final StringProperty keyProperty = new StringProperty("key");
    private static final DateProperty lastUpdatedProperty = new DateProperty("lastUpdated");
    private static final StringProperty nameProperty = new StringProperty("name");
    private static final ResourceReference<AuthenticatorProvider> providerProperty = new ResourceReference<AuthenticatorProvider>("provider", AuthenticatorProvider.class, false);
    private static final ResourceReference<AuthenticatorSettings> settingsProperty = new ResourceReference<AuthenticatorSettings>("settings", AuthenticatorSettings.class, false);
    private static final EnumProperty<AuthenticatorStatus> statusProperty = new EnumProperty<AuthenticatorStatus>("status", AuthenticatorStatus.class);
    private static final EnumProperty<AuthenticatorType> typeProperty = new EnumProperty<AuthenticatorType>("type", AuthenticatorType.class);
    private static final Map<String, Property> PROPERTY_DESCRIPTORS = DefaultAuthenticator.createPropertyDescriptorMap(linksProperty, createdProperty, idProperty, keyProperty, lastUpdatedProperty, nameProperty, providerProperty, settingsProperty, statusProperty, typeProperty);

    public DefaultAuthenticator(InternalDataStore dataStore) {
        super(dataStore);
    }

    public DefaultAuthenticator(InternalDataStore dataStore, Map<String, Object> properties) {
        super(dataStore, properties);
    }

    @Override
    public Map<String, Property> getPropertyDescriptors() {
        return PROPERTY_DESCRIPTORS;
    }

    @Override
    public Class<? extends Resource> getResourceClass() {
        return Authenticator.class;
    }

    public Map<String, Object> getLinks() {
        return this.getMap(linksProperty);
    }

    public Date getCreated() {
        return this.getDateProperty(createdProperty);
    }

    public String getId() {
        return this.getString(idProperty);
    }

    public String getKey() {
        return this.getString(keyProperty);
    }

    public Authenticator setKey(String key) {
        this.setProperty(keyProperty, (Object)key);
        return this;
    }

    public Date getLastUpdated() {
        return this.getDateProperty(lastUpdatedProperty);
    }

    public String getName() {
        return this.getString(nameProperty);
    }

    public Authenticator setName(String name) {
        this.setProperty(nameProperty, (Object)name);
        return this;
    }

    public AuthenticatorProvider getProvider() {
        return this.getResourceProperty(providerProperty);
    }

    public Authenticator setProvider(AuthenticatorProvider provider) {
        this.setProperty(providerProperty, (Object)provider);
        return this;
    }

    public AuthenticatorSettings getSettings() {
        return this.getResourceProperty(settingsProperty);
    }

    public Authenticator setSettings(AuthenticatorSettings settings) {
        this.setProperty(settingsProperty, (Object)settings);
        return this;
    }

    public AuthenticatorStatus getStatus() {
        return this.getEnumProperty(statusProperty);
    }

    public Authenticator setStatus(AuthenticatorStatus status) {
        this.setProperty(statusProperty, (Object)status);
        return this;
    }

    public AuthenticatorType getType() {
        return this.getEnumProperty(typeProperty);
    }

    public Authenticator setType(AuthenticatorType type) {
        this.setProperty(typeProperty, (Object)type);
        return this;
    }

    public Authenticator activate() {
        String authenticatorId = this.getId();
        Assert.hasText((String)authenticatorId, (String)"'authenticatorId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().create("/api/v1/authenticators/" + authenticatorId + "/lifecycle/activate", new DefaultVoidResource(this.getDataStore()), this, Authenticator.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public Authenticator update() {
        String authenticatorId = this.getId();
        Assert.hasText((String)authenticatorId, (String)"'authenticatorId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        String href = "/api/v1/authenticators/" + authenticatorId + "";
        this.getDataStore().save(href, this, null, queryArgs, (Map<String, List<String>>)headers);
        return this;
    }

    public Authenticator deactivate() {
        String authenticatorId = this.getId();
        Assert.hasText((String)authenticatorId, (String)"'authenticatorId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().create("/api/v1/authenticators/" + authenticatorId + "/lifecycle/deactivate", new DefaultVoidResource(this.getDataStore()), this, Authenticator.class, queryArgs, (Map<String, List<String>>)headers);
    }
}

