/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.saml.util.credential;

import java.io.InputStream;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import lombok.Generated;
import net.shibboleth.utilities.java.support.collection.LazyList;
import org.opensaml.security.credential.UsageType;
import org.opensaml.security.crypto.KeySupport;
import org.opensaml.security.x509.BasicX509Credential;
import org.opensaml.security.x509.X509Support;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.core.io.Resource;

public class BasicX509CredentialFactoryBean
implements FactoryBean<BasicX509Credential> {
    private Resource entityResource;
    private List<Resource> certificateResources;
    private Resource privateKeyResource;
    private List<Resource> crlResources;
    private String usageType;
    private List<String> keyNames;
    private String entityID;
    private char[] privateKeyPassword;

    public BasicX509Credential getObject() throws Exception {
        List<X509Certificate> certificates = this.getCertificates();
        if (certificates.isEmpty()) {
            throw new BeanCreationException("No Certificates provided");
        }
        X509Certificate entityCertificate = this.getEntityCertificate();
        if (null == entityCertificate) {
            entityCertificate = certificates.get(0);
        }
        PrivateKey privateKey = this.getPrivateKey();
        BasicX509Credential credential = null;
        if (null == privateKey) {
            credential = new BasicX509Credential(entityCertificate);
        } else {
            credential = new BasicX509Credential(entityCertificate, privateKey);
            if (!KeySupport.matchKeyPair((PublicKey)entityCertificate.getPublicKey(), (PrivateKey)privateKey)) {
                throw new BeanCreationException("Public and private keys do not match");
            }
        }
        credential.setEntityCertificateChain(certificates);
        List<X509CRL> crls = this.getCRLs();
        if (null != crls && !crls.isEmpty()) {
            credential.setCRLs(crls);
        }
        if (null != this.getUsageType()) {
            credential.setUsageType(UsageType.valueOf((String)this.getUsageType()));
        }
        if (null != this.getEntityID()) {
            credential.setEntityId(this.getEntityID());
        }
        if (this.keyNames != null) {
            credential.getKeyNames().addAll(this.keyNames);
        }
        return credential;
    }

    public Class<?> getObjectType() {
        return BasicX509Credential.class;
    }

    private X509Certificate getEntityCertificate() {
        if (null == this.entityResource) {
            return null;
        }
        try {
            Collection certs = X509Support.decodeCertificates((InputStream)this.entityResource.getInputStream());
            if (certs.size() > 1) {
                throw new BeanCreationException("Configuration element indicated an entityCertificate, but multiple certificates were decoded");
            }
            return (X509Certificate)certs.iterator().next();
        }
        catch (Exception e) {
            throw new BeanCreationException("Could not decode provided Entity Certificate file " + this.entityResource.getDescription(), (Throwable)e);
        }
    }

    private List<X509Certificate> getCertificates() {
        if (this.certificateResources == null) {
            return new ArrayList<X509Certificate>();
        }
        LazyList certificates = new LazyList();
        for (Resource r : this.certificateResources) {
            try {
                InputStream is = r.getInputStream();
                try {
                    certificates.addAll(X509Support.decodeCertificates((InputStream)is));
                }
                finally {
                    if (is == null) continue;
                    is.close();
                }
            }
            catch (Exception e) {
                throw new BeanCreationException("Could not decode provided CertificateFile: " + r.getDescription(), (Throwable)e);
            }
        }
        return certificates;
    }

    private PrivateKey getPrivateKey() {
        PrivateKey privateKey;
        block9: {
            if (null == this.privateKeyResource) {
                return null;
            }
            InputStream is = this.privateKeyResource.getInputStream();
            try {
                privateKey = KeySupport.decodePrivateKey((InputStream)is, (char[])this.getPrivateKeyPassword());
                if (is == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new BeanCreationException("Could not decode provided KeyFile " + this.privateKeyResource.getDescription(), (Throwable)e);
                }
            }
            is.close();
        }
        return privateKey;
    }

    public boolean isSingleton() {
        return true;
    }

    private List<X509CRL> getCRLs() {
        if (null == this.crlResources) {
            return null;
        }
        LazyList crls = new LazyList();
        for (Resource crl : this.crlResources) {
            try {
                InputStream is = crl.getInputStream();
                try {
                    crls.addAll(X509Support.decodeCRLs((InputStream)is));
                }
                finally {
                    if (is == null) continue;
                    is.close();
                }
            }
            catch (Exception e) {
                throw new BeanCreationException("Could not decode provided CRL file " + crl.getDescription(), (Throwable)e);
            }
        }
        return crls;
    }

    @Generated
    public Resource getEntityResource() {
        return this.entityResource;
    }

    @Generated
    public List<Resource> getCertificateResources() {
        return this.certificateResources;
    }

    @Generated
    public Resource getPrivateKeyResource() {
        return this.privateKeyResource;
    }

    @Generated
    public List<Resource> getCrlResources() {
        return this.crlResources;
    }

    @Generated
    public String getUsageType() {
        return this.usageType;
    }

    @Generated
    public List<String> getKeyNames() {
        return this.keyNames;
    }

    @Generated
    public String getEntityID() {
        return this.entityID;
    }

    @Generated
    public char[] getPrivateKeyPassword() {
        return this.privateKeyPassword;
    }

    @Generated
    public void setEntityResource(Resource entityResource) {
        this.entityResource = entityResource;
    }

    @Generated
    public void setCertificateResources(List<Resource> certificateResources) {
        this.certificateResources = certificateResources;
    }

    @Generated
    public void setPrivateKeyResource(Resource privateKeyResource) {
        this.privateKeyResource = privateKeyResource;
    }

    @Generated
    public void setCrlResources(List<Resource> crlResources) {
        this.crlResources = crlResources;
    }

    @Generated
    public void setUsageType(String usageType) {
        this.usageType = usageType;
    }

    @Generated
    public void setKeyNames(List<String> keyNames) {
        this.keyNames = keyNames;
    }

    @Generated
    public void setEntityID(String entityID) {
        this.entityID = entityID;
    }

    @Generated
    public void setPrivateKeyPassword(char[] privateKeyPassword) {
        this.privateKeyPassword = privateKeyPassword;
    }
}

