/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.jobexecutor;

import com.fasterxml.jackson.databind.node.ObjectNode;
import org.flowable.batch.api.Batch;
import org.flowable.batch.api.BatchPart;
import org.flowable.batch.api.BatchService;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.flowable.engine.impl.jobexecutor.AbstractProcessInstanceMigrationJobHandler;
import org.flowable.engine.impl.migration.ProcessInstanceMigrationDocumentImpl;
import org.flowable.engine.impl.util.CommandContextUtil;
import org.flowable.engine.migration.ProcessInstanceMigrationDocument;
import org.flowable.engine.migration.ProcessInstanceMigrationManager;
import org.flowable.job.service.impl.persistence.entity.JobEntity;
import org.flowable.variable.api.delegate.VariableScope;

public class ProcessInstanceMigrationJobHandler
extends AbstractProcessInstanceMigrationJobHandler {
    public static final String TYPE = "process-migration";

    public String getType() {
        return TYPE;
    }

    public void execute(JobEntity job, String configuration, VariableScope variableScope, CommandContext commandContext) {
        ProcessEngineConfigurationImpl processEngineConfiguration = CommandContextUtil.getProcessEngineConfiguration(commandContext);
        BatchService batchService = processEngineConfiguration.getBatchServiceConfiguration().getBatchService();
        ProcessInstanceMigrationManager processInstanceMigrationManager = processEngineConfiguration.getProcessInstanceMigrationManager();
        String batchPartId = ProcessInstanceMigrationJobHandler.getBatchPartIdFromHandlerCfg(configuration);
        BatchPart batchPart = batchService.getBatchPart(batchPartId);
        Batch batch = batchService.getBatch(batchPart.getBatchId());
        ProcessInstanceMigrationDocument migrationDocument = ProcessInstanceMigrationDocumentImpl.fromJson(batch.getBatchDocumentJson(processEngineConfiguration.getEngineCfgKey()));
        String exceptionMessage = null;
        try {
            processInstanceMigrationManager.migrateProcessInstance(batchPart.getScopeId(), migrationDocument, commandContext);
        }
        catch (FlowableException e) {
            exceptionMessage = e.getMessage();
        }
        String resultAsJsonString = ProcessInstanceMigrationJobHandler.prepareResultAsJsonString(exceptionMessage);
        if (exceptionMessage != null) {
            batchService.completeBatchPart(batchPartId, "fail", resultAsJsonString);
        } else {
            batchService.completeBatchPart(batchPartId, "success", resultAsJsonString);
        }
    }

    protected static String prepareResultAsJsonString(String exceptionMessage) {
        ObjectNode objectNode = ProcessInstanceMigrationJobHandler.getObjectMapper().createObjectNode();
        if (exceptionMessage == null) {
            objectNode.put("resultStatus", "success");
        } else {
            objectNode.put("resultStatus", "fail");
            objectNode.put("resultMessage", exceptionMessage);
        }
        return objectNode.toString();
    }
}

