/*
 * Decompiled with CFR 0.152.
 */
package org.springmodules.cache.provider.gigaspaces;

import com.j_spaces.map.CacheFinder;
import com.j_spaces.map.IMap;
import java.beans.PropertyEditor;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.springframework.util.ObjectUtils;
import org.springmodules.cache.CacheException;
import org.springmodules.cache.CachingModel;
import org.springmodules.cache.FatalCacheException;
import org.springmodules.cache.FlushingModel;
import org.springmodules.cache.provider.AbstractCacheProviderFacade;
import org.springmodules.cache.provider.CacheAccessException;
import org.springmodules.cache.provider.CacheModelValidator;
import org.springmodules.cache.provider.CacheNotFoundException;
import org.springmodules.cache.provider.ReflectionCacheModelEditor;
import org.springmodules.cache.provider.gigaspaces.GigaSpacesCachingModel;
import org.springmodules.cache.provider.gigaspaces.GigaSpacesFlushingModel;
import org.springmodules.cache.provider.gigaspaces.GigaSpacesModelValidator;

public final class GigaSpacesFacade
extends AbstractCacheProviderFacade {
    private CacheModelValidator cacheModelValidator;
    private Map cachesHolder = new HashMap();
    static /* synthetic */ Class class$org$springmodules$cache$provider$gigaspaces$GigaSpacesCachingModel;
    static /* synthetic */ Class class$org$springmodules$cache$provider$gigaspaces$GigaSpacesFlushingModel;

    public GigaSpacesFacade() {
        this.cacheModelValidator = new GigaSpacesModelValidator();
    }

    public CacheModelValidator modelValidator() {
        return this.cacheModelValidator;
    }

    public PropertyEditor getCachingModelEditor() {
        ReflectionCacheModelEditor editor = new ReflectionCacheModelEditor();
        editor.setCacheModelClass(class$org$springmodules$cache$provider$gigaspaces$GigaSpacesCachingModel == null ? (class$org$springmodules$cache$provider$gigaspaces$GigaSpacesCachingModel = GigaSpacesFacade.class$("org.springmodules.cache.provider.gigaspaces.GigaSpacesCachingModel")) : class$org$springmodules$cache$provider$gigaspaces$GigaSpacesCachingModel);
        return editor;
    }

    public PropertyEditor getFlushingModelEditor() {
        ReflectionCacheModelEditor editor = new ReflectionCacheModelEditor();
        editor.setCacheModelClass(class$org$springmodules$cache$provider$gigaspaces$GigaSpacesFlushingModel == null ? (class$org$springmodules$cache$provider$gigaspaces$GigaSpacesFlushingModel = GigaSpacesFacade.class$("org.springmodules.cache.provider.gigaspaces.GigaSpacesFlushingModel")) : class$org$springmodules$cache$provider$gigaspaces$GigaSpacesFlushingModel);
        return editor;
    }

    protected IMap getCache(CachingModel model) throws CacheNotFoundException, CacheAccessException {
        GigaSpacesCachingModel gigaSpacesCachingModel = (GigaSpacesCachingModel)model;
        String cacheName = gigaSpacesCachingModel.getCacheName();
        return this.getCache(cacheName);
    }

    protected IMap getCache(String name) throws CacheNotFoundException, CacheAccessException {
        IMap cache = (IMap)this.cachesHolder.get(name);
        try {
            if (cache == null) {
                cache = (IMap)CacheFinder.find((String)name);
                this.cachesHolder.put(name, cache);
            }
        }
        catch (Exception exception) {
            throw new CacheAccessException(exception);
        }
        if (cache == null) {
            throw new CacheNotFoundException(name);
        }
        return cache;
    }

    protected boolean isSerializableCacheElementRequired() {
        return false;
    }

    protected void onFlushCache(FlushingModel model) throws CacheException {
        GigaSpacesFlushingModel flushingModel = (GigaSpacesFlushingModel)model;
        Object[] cacheNames = flushingModel.getCacheNames();
        if (!ObjectUtils.isEmpty((Object[])cacheNames)) {
            CacheException cacheException = null;
            int nameCount = cacheNames.length;
            try {
                for (int i = 0; i < nameCount; ++i) {
                    IMap cache = this.getCache((String)cacheNames[i]);
                    cache.clear();
                }
            }
            catch (CacheException exception) {
                cacheException = exception;
            }
            catch (Exception exception) {
                cacheException = new CacheAccessException(exception);
            }
            if (cacheException != null) {
                throw cacheException;
            }
        }
    }

    protected Object onGetFromCache(Serializable key, CachingModel model) throws CacheException {
        IMap cache = this.getCache(model);
        GigaSpacesCachingModel gigaSpacesCachingModel = (GigaSpacesCachingModel)model;
        Object cachedObject = null;
        try {
            Long waitForResponse = gigaSpacesCachingModel.getWaitForResponse();
            cachedObject = waitForResponse != null ? cache.get((Object)key, waitForResponse.longValue()) : cache.get((Object)key);
        }
        catch (Exception exception) {
            throw new CacheAccessException(exception);
        }
        return cachedObject;
    }

    protected void onPutInCache(Serializable key, CachingModel model, Object obj) throws CacheException {
        try {
            GigaSpacesCachingModel gigaSpacesCachingModel = (GigaSpacesCachingModel)model;
            IMap cache = this.getCache(gigaSpacesCachingModel);
            Long timeToLive = gigaSpacesCachingModel.getTimeToLive();
            if (timeToLive != null) {
                cache.put((Object)key, obj, timeToLive.longValue());
            } else {
                cache.put((Object)key, obj);
            }
        }
        catch (Exception exception) {
            throw new CacheAccessException(exception);
        }
    }

    protected void onRemoveFromCache(Serializable key, CachingModel model) throws CacheException {
        IMap cache = this.getCache(model);
        try {
            cache.remove((Object)key);
        }
        catch (Exception exception) {
            throw new CacheAccessException(exception);
        }
    }

    protected void validateCacheManager() throws FatalCacheException {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

