/*
 * Decompiled with CFR 0.152.
 */
package com.giffing.wicket.spring.boot.starter.configuration.extensions.core.settings.resource;

import com.giffing.wicket.spring.boot.context.extensions.ApplicationInitExtension;
import com.giffing.wicket.spring.boot.context.extensions.WicketApplicationInitConfiguration;
import com.giffing.wicket.spring.boot.starter.configuration.extensions.core.settings.resource.ResourceSettingsProperties;
import java.time.Duration;
import org.apache.wicket.protocol.http.WebApplication;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;

@ApplicationInitExtension
@ConditionalOnProperty(prefix="wicket.core.settings.resource", value={"enabled"}, matchIfMissing=false)
@EnableConfigurationProperties(value={ResourceSettingsProperties.class})
public class ResourceSettingsConfig
implements WicketApplicationInitConfiguration {
    @Autowired
    private ResourceSettingsProperties properties;

    public void init(WebApplication webApplication) {
        webApplication.getResourceSettings().setUseMinifiedResources(this.properties.isUseMinifiedResources());
        if (this.properties.getResourcePollFrequencySeconds() > 0) {
            webApplication.getResourceSettings().setResourcePollFrequency(Duration.ofSeconds(this.properties.getResourcePollFrequencySeconds()));
        }
    }
}

