/*
 * Decompiled with CFR 0.152.
 */
package net.tirasa.connid.bundles.ldap.sync.sunds;

import java.util.Collections;
import javax.naming.InvalidNameException;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import net.tirasa.connid.bundles.ldap.LdapConnection;
import net.tirasa.connid.bundles.ldap.commons.LdapUtil;
import net.tirasa.connid.bundles.ldap.sync.GenericChangeLogSyncStrategy;
import net.tirasa.connid.bundles.ldap.sync.sunds.ChangeLogAttributes;
import org.identityconnectors.framework.common.exceptions.ConnectorException;
import org.identityconnectors.framework.common.objects.AttributesAccessor;
import org.identityconnectors.framework.common.objects.ConnectorObjectBuilder;
import org.identityconnectors.framework.common.objects.ObjectClass;
import org.identityconnectors.framework.common.objects.SyncDelta;
import org.identityconnectors.framework.common.objects.SyncDeltaBuilder;
import org.identityconnectors.framework.common.objects.SyncToken;
import org.identityconnectors.framework.common.objects.Uid;

public class SunDSChangeLogSyncStrategy
extends GenericChangeLogSyncStrategy {
    private ChangeLogAttributes changeLogAttrs;

    public SunDSChangeLogSyncStrategy(LdapConnection conn) {
        super(conn);
    }

    @Override
    public SyncToken getLatestSyncToken(ObjectClass oclass) {
        return new SyncToken((Object)this.getChangeLogAttributes().getLastChangeNumber());
    }

    @Override
    protected SyncDelta createDeletionSyncDelta(SyncDeltaBuilder syncDeltaBuilder, String targetDN, ObjectClass oclass, AttributesAccessor inputAttrs) throws InvalidNameException {
        LOG.ok("Creating sync delta for deleted entry {0}", new Object[]{inputAttrs.findString("targetEntryUUID")});
        String uidAttr = this.conn.getSchema().getLdapUidAttribute(oclass);
        Uid deletedUid = LDAP_DN_ATTRIBUTES.contains(uidAttr) ? this.createUid(uidAttr, targetDN) : ("entryUUID".equalsIgnoreCase(uidAttr) ? new Uid(inputAttrs.findString("targetEntryUUID")) : new Uid(targetDN));
        ConnectorObjectBuilder objectBuilder = new ConnectorObjectBuilder();
        objectBuilder.setObjectClass(oclass);
        objectBuilder.setUid(deletedUid);
        objectBuilder.setName("fake-dn");
        objectBuilder.addAttributes(Collections.emptySet());
        syncDeltaBuilder.setUid(deletedUid);
        syncDeltaBuilder.setObject(objectBuilder.build());
        return syncDeltaBuilder.build();
    }

    @Override
    protected int getStartChangeNumber(SyncToken lastToken) {
        Integer lastTokenValue;
        Integer n = lastTokenValue = lastToken != null ? (Integer)lastToken.getValue() : null;
        if (lastTokenValue == null) {
            return this.getChangeLogAttributes().getFirstChangeNumber();
        }
        return lastTokenValue + 1;
    }

    ChangeLogAttributes getChangeLogAttributes() {
        if (this.changeLogAttrs == null) {
            try {
                Attributes attrs = this.conn.getInitialContext().getAttributes("", new String[]{"changeLog", "firstChangeNumber", "lastChangeNumber"});
                String changeLog = LdapUtil.getStringAttrValue(attrs, "changeLog");
                String firstChangeNumber = LdapUtil.getStringAttrValue(attrs, "firstChangeNumber");
                String lastChangeNumber = LdapUtil.getStringAttrValue(attrs, "lastChangeNumber");
                if (changeLog == null || firstChangeNumber == null | lastChangeNumber == null) {
                    throw new ConnectorException("Unable to locate the replication change log.\nFrom the admin console please verify that the change log is enabled under Configuration: Replication: Supplier Settings and that the Retro Change Log Plugin is enabled under Configuration: Plug-ins: Retro Change Log Plugin");
                }
                this.changeLogAttrs = new ChangeLogAttributes(changeLog, SunDSChangeLogSyncStrategy.convertToInt(firstChangeNumber, 0), SunDSChangeLogSyncStrategy.convertToInt(lastChangeNumber, 0));
            }
            catch (NamingException e) {
                throw new ConnectorException((Throwable)e);
            }
        }
        return this.changeLogAttrs;
    }
}

