/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java.job;

import java.util.Optional;
import org.apache.syncope.core.persistence.api.dao.JobStatusDAO;
import org.apache.syncope.core.provisioning.api.job.JobExecutionContext;
import org.apache.syncope.core.provisioning.api.job.JobExecutionException;
import org.apache.syncope.core.spring.security.AuthContextUtils;
import org.apache.syncope.core.spring.security.SecureRandomUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class Job
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(Job.class);
    public static final String OPERATION_ID = "operation.id";
    @Autowired
    private JobStatusDAO jobStatusDAO;
    private JobExecutionContext context;

    public JobExecutionContext getContext() {
        return this.context;
    }

    public void setContext(JobExecutionContext context) {
        this.context = context;
    }

    protected abstract void execute(JobExecutionContext var1) throws JobExecutionException;

    @Override
    public void run() {
        this.setContext(Optional.ofNullable(this.context).orElseGet(() -> new JobExecutionContext(AuthContextUtils.getDomain(), this.getClass().getName() + "_" + SecureRandomUtils.generateRandomUUID().toString(), AuthContextUtils.getWho(), false)));
        boolean locked = false;
        try {
            locked = (Boolean)AuthContextUtils.callAsAdmin((String)this.context.getDomain(), () -> this.jobStatusDAO.lock(this.context.getJobName()));
        }
        catch (Exception e) {
            LOG.debug("While attempting to lock job {}", (Object)this.context.getJobName(), (Object)e);
        }
        if (!locked) {
            LOG.debug("Could not lock job {}, skipping execution", (Object)this.context.getJobName());
            return;
        }
        LOG.debug("Job {} locked, starting execution", (Object)this.context.getJobName());
        try {
            this.execute(this.context);
        }
        catch (JobExecutionException e) {
            LOG.error("While executing job {}", (Object)this.context.getJobName(), (Object)e);
        }
        finally {
            LOG.debug("Job {} execution completed", (Object)this.context.getJobName());
            AuthContextUtils.runAsAdmin((String)this.context.getDomain(), () -> this.jobStatusDAO.unlock(this.context.getJobName()));
        }
    }
}

