/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.core.authorization.generator;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Optional;
import lombok.Generated;
import org.pac4j.core.authorization.generator.AuthorizationGenerator;
import org.pac4j.core.context.CallContext;
import org.pac4j.core.exception.TechnicalException;
import org.pac4j.core.profile.UserProfile;
import org.pac4j.core.profile.service.ProfileService;
import org.pac4j.core.util.CommonHelper;

public class LoadLinkedUserAuthorizationGenerator
implements AuthorizationGenerator {
    private ProfileService profileService;
    private boolean failIfLinkedUserNotFound = true;

    public LoadLinkedUserAuthorizationGenerator() {
    }

    public LoadLinkedUserAuthorizationGenerator(ProfileService profileService) {
        this.profileService = profileService;
    }

    @Override
    public Optional<UserProfile> generate(CallContext ctx, UserProfile profile) {
        CommonHelper.assertNotNull("profileService", this.profileService);
        Object linkedProfile = this.profileService.findByLinkedId(profile.getId());
        if (linkedProfile != null) {
            return Optional.ofNullable(linkedProfile);
        }
        if (this.failIfLinkedUserNotFound) {
            throw new TechnicalException("No linked account found for: " + profile);
        }
        return Optional.ofNullable(profile);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setProfileService(ProfileService profileService) {
        this.profileService = profileService;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setFailIfLinkedUserNotFound(boolean failIfLinkedUserNotFound) {
        this.failIfLinkedUserNotFound = failIfLinkedUserNotFound;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public ProfileService getProfileService() {
        return this.profileService;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean isFailIfLinkedUserNotFound() {
        return this.failIfLinkedUserNotFound;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String toString() {
        return "LoadLinkedUserAuthorizationGenerator(profileService=" + this.profileService + ", failIfLinkedUserNotFound=" + this.failIfLinkedUserNotFound + ")";
    }
}

