/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.audit.AuditableExecution;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.features.CasFeatureModule;
import org.apereo.cas.support.oauth.web.endpoints.OAuth20AccessTokenEndpointController;
import org.apereo.cas.support.oauth.web.endpoints.OAuth20AuthorizeEndpointController;
import org.apereo.cas.support.oauth.web.endpoints.OAuth20CallbackAuthorizeEndpointController;
import org.apereo.cas.support.oauth.web.endpoints.OAuth20ConfigurationContext;
import org.apereo.cas.support.oauth.web.endpoints.OAuth20DeviceUserCodeApprovalEndpointController;
import org.apereo.cas.support.oauth.web.endpoints.OAuth20IntrospectionEndpointController;
import org.apereo.cas.support.oauth.web.endpoints.OAuth20RevocationEndpointController;
import org.apereo.cas.support.oauth.web.endpoints.OAuth20UserProfileEndpointController;
import org.apereo.cas.support.oauth.web.mgmt.OAuth20TokenManagementEndpoint;
import org.apereo.cas.ticket.registry.TicketRegistry;
import org.apereo.cas.token.JwtBuilder;
import org.apereo.cas.util.spring.boot.ConditionalOnFeatureEnabled;
import org.apereo.cas.web.CasWebSecurityConfigurer;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.actuate.autoconfigure.endpoint.condition.ConditionalOnAvailableEndpoint;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ScopedProxyMode;

@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@ConditionalOnFeatureEnabled(feature={CasFeatureModule.FeatureCatalog.OAuth})
@Configuration(value="CasOAuth20EndpointsConfiguration", proxyBeanMethods=false)
class CasOAuth20EndpointsConfiguration {
    CasOAuth20EndpointsConfiguration() {
    }

    @Configuration(value="CasOAuth20EndpointSecurityConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    static class CasOAuth20EndpointSecurityConfiguration {
        CasOAuth20EndpointSecurityConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean(name={"oauth20ProtocolEndpointConfigurer"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public CasWebSecurityConfigurer<Void> oauth20ProtocolEndpointConfigurer() {
            return new CasWebSecurityConfigurer<Void>(this){

                public List<String> getIgnoredEndpoints() {
                    return List.of(StringUtils.prependIfMissing((String)"/oauth2.0", (CharSequence)"/", (CharSequence[])new CharSequence[0]));
                }
            };
        }
    }

    @Configuration(value="CasOAuth20EndpointControllersConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    static class CasOAuth20EndpointControllersConfiguration {
        CasOAuth20EndpointControllersConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean(name={"callbackAuthorizeController"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public OAuth20CallbackAuthorizeEndpointController callbackAuthorizeController(@Qualifier(value="oauth20ConfigurationContext") OAuth20ConfigurationContext context) {
            return new OAuth20CallbackAuthorizeEndpointController(context);
        }

        @ConditionalOnMissingBean(name={"introspectionEndpointController"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public OAuth20IntrospectionEndpointController<OAuth20ConfigurationContext> introspectionEndpointController(@Qualifier(value="oauth20ConfigurationContext") OAuth20ConfigurationContext context) {
            return new OAuth20IntrospectionEndpointController(context);
        }

        @ConditionalOnMissingBean(name={"accessTokenController"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public OAuth20AccessTokenEndpointController<OAuth20ConfigurationContext> accessTokenController(@Qualifier(value="accessTokenGrantAuditableRequestExtractor") AuditableExecution accessTokenGrantAuditableRequestExtractor, @Qualifier(value="oauth20ConfigurationContext") OAuth20ConfigurationContext context) {
            return new OAuth20AccessTokenEndpointController(context, accessTokenGrantAuditableRequestExtractor);
        }

        @ConditionalOnMissingBean(name={"deviceUserCodeApprovalEndpointController"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public OAuth20DeviceUserCodeApprovalEndpointController deviceUserCodeApprovalEndpointController(@Qualifier(value="oauth20ConfigurationContext") OAuth20ConfigurationContext context) {
            return new OAuth20DeviceUserCodeApprovalEndpointController(context);
        }

        @ConditionalOnMissingBean(name={"oauthProfileController"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public OAuth20UserProfileEndpointController<OAuth20ConfigurationContext> oauthProfileController(@Qualifier(value="oauth20ConfigurationContext") OAuth20ConfigurationContext context) {
            return new OAuth20UserProfileEndpointController(context);
        }

        @ConditionalOnMissingBean(name={"oauthRevocationController"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public OAuth20RevocationEndpointController<OAuth20ConfigurationContext> oauthRevocationController(@Qualifier(value="oauth20ConfigurationContext") OAuth20ConfigurationContext context) {
            return new OAuth20RevocationEndpointController(context);
        }

        @ConditionalOnMissingBean(name={"authorizeController"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public OAuth20AuthorizeEndpointController<OAuth20ConfigurationContext> authorizeController(@Qualifier(value="oauth20ConfigurationContext") OAuth20ConfigurationContext context) {
            return new OAuth20AuthorizeEndpointController(context);
        }

        @Bean
        @ConditionalOnAvailableEndpoint
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public OAuth20TokenManagementEndpoint oauth20TokenManagementEndpoint(@Qualifier(value="ticketRegistry") ObjectProvider<TicketRegistry> ticketRegistry, @Qualifier(value="accessTokenJwtBuilder") ObjectProvider<JwtBuilder> accessTokenJwtBuilder, CasConfigurationProperties casProperties) {
            return new OAuth20TokenManagementEndpoint(casProperties, ticketRegistry, accessTokenJwtBuilder);
        }
    }
}

