/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.cqengine.query;

import com.googlecode.cqengine.IndexedCollection;
import com.googlecode.cqengine.attribute.Attribute;
import com.googlecode.cqengine.attribute.MultiValueAttribute;
import com.googlecode.cqengine.attribute.MultiValueNullableAttribute;
import com.googlecode.cqengine.attribute.OrderMissingFirstAttribute;
import com.googlecode.cqengine.attribute.OrderMissingLastAttribute;
import com.googlecode.cqengine.attribute.SelfAttribute;
import com.googlecode.cqengine.attribute.SimpleAttribute;
import com.googlecode.cqengine.attribute.SimpleNullableAttribute;
import com.googlecode.cqengine.attribute.SimpleNullableMapAttribute;
import com.googlecode.cqengine.attribute.StandingQueryAttribute;
import com.googlecode.cqengine.attribute.support.FunctionalMultiValueAttribute;
import com.googlecode.cqengine.attribute.support.FunctionalMultiValueNullableAttribute;
import com.googlecode.cqengine.attribute.support.FunctionalSimpleAttribute;
import com.googlecode.cqengine.attribute.support.FunctionalSimpleNullableAttribute;
import com.googlecode.cqengine.attribute.support.MultiValueFunction;
import com.googlecode.cqengine.attribute.support.SimpleFunction;
import com.googlecode.cqengine.entity.MapEntity;
import com.googlecode.cqengine.entity.PrimaryKeyedMapEntity;
import com.googlecode.cqengine.query.Query;
import com.googlecode.cqengine.query.comparative.LongestPrefix;
import com.googlecode.cqengine.query.comparative.Max;
import com.googlecode.cqengine.query.comparative.Min;
import com.googlecode.cqengine.query.logical.And;
import com.googlecode.cqengine.query.logical.Not;
import com.googlecode.cqengine.query.logical.Or;
import com.googlecode.cqengine.query.option.ArgumentValidationOption;
import com.googlecode.cqengine.query.option.ArgumentValidationStrategy;
import com.googlecode.cqengine.query.option.AttributeOrder;
import com.googlecode.cqengine.query.option.DeduplicationOption;
import com.googlecode.cqengine.query.option.DeduplicationStrategy;
import com.googlecode.cqengine.query.option.FlagsDisabled;
import com.googlecode.cqengine.query.option.FlagsEnabled;
import com.googlecode.cqengine.query.option.IsolationLevel;
import com.googlecode.cqengine.query.option.IsolationOption;
import com.googlecode.cqengine.query.option.OrderByOption;
import com.googlecode.cqengine.query.option.QueryOptions;
import com.googlecode.cqengine.query.option.Threshold;
import com.googlecode.cqengine.query.option.Thresholds;
import com.googlecode.cqengine.query.simple.All;
import com.googlecode.cqengine.query.simple.Between;
import com.googlecode.cqengine.query.simple.Equal;
import com.googlecode.cqengine.query.simple.ExistsIn;
import com.googlecode.cqengine.query.simple.GreaterThan;
import com.googlecode.cqengine.query.simple.Has;
import com.googlecode.cqengine.query.simple.In;
import com.googlecode.cqengine.query.simple.LessThan;
import com.googlecode.cqengine.query.simple.None;
import com.googlecode.cqengine.query.simple.StringContains;
import com.googlecode.cqengine.query.simple.StringEndsWith;
import com.googlecode.cqengine.query.simple.StringIsContainedIn;
import com.googlecode.cqengine.query.simple.StringIsPrefixOf;
import com.googlecode.cqengine.query.simple.StringMatchesRegex;
import com.googlecode.cqengine.query.simple.StringStartsWith;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import net.jodah.typetools.TypeResolver;

public class QueryFactory {
    static final String GENERIC_TYPE_RESOLUTION_FAILURE_MESSAGE = "If the function you supplied was created from a lambda expression, then it's likely that the host JVM does not allow the generic type information to be read from lambda expressions. Alternatively, if you supplied a class-based implementation of the function, then you must ensure that you specified the generic types of the function when it was compiled. As a workaround, you can use the counterpart methods in QueryFactory which allow the generic types to be specified explicitly.";

    QueryFactory() {
    }

    public static <O, A> Equal<O, A> equal(Attribute<O, A> attribute, A attributeValue) {
        return new Equal<O, A>(attribute, attributeValue);
    }

    public static <O, A extends Comparable<A>> LessThan<O, A> lessThanOrEqualTo(Attribute<O, A> attribute, A attributeValue) {
        return new LessThan<O, A>(attribute, attributeValue, true);
    }

    public static <O, A extends Comparable<A>> LessThan<O, A> lessThan(Attribute<O, A> attribute, A attributeValue) {
        return new LessThan<O, A>(attribute, attributeValue, false);
    }

    public static <O, A extends Comparable<A>> GreaterThan<O, A> greaterThanOrEqualTo(Attribute<O, A> attribute, A attributeValue) {
        return new GreaterThan<O, A>(attribute, attributeValue, true);
    }

    public static <O, A extends Comparable<A>> GreaterThan<O, A> greaterThan(Attribute<O, A> attribute, A attributeValue) {
        return new GreaterThan<O, A>(attribute, attributeValue, false);
    }

    public static <O, A extends Comparable<A>> Between<O, A> between(Attribute<O, A> attribute, A lowerValue, boolean lowerInclusive, A upperValue, boolean upperInclusive) {
        return new Between<O, A>(attribute, lowerValue, lowerInclusive, upperValue, upperInclusive);
    }

    public static <O, A extends Comparable<A>> Between<O, A> between(Attribute<O, A> attribute, A lowerValue, A upperValue) {
        return new Between<O, A>(attribute, lowerValue, true, upperValue, true);
    }

    public static <O, A> Query<O> in(Attribute<O, A> attribute, A ... attributeValues) {
        return QueryFactory.in(attribute, Arrays.asList(attributeValues));
    }

    public static <O, A> Query<O> in(Attribute<O, A> attribute, Collection<A> attributeValues) {
        return QueryFactory.in(attribute, attribute instanceof SimpleAttribute, attributeValues);
    }

    public static <O, A> Query<O> in(Attribute<O, A> attribute, boolean disjoint, Collection<A> attributeValues) {
        int n = attributeValues.size();
        switch (n) {
            case 0: {
                return QueryFactory.none(attribute.getObjectType());
            }
            case 1: {
                A singleValue = attributeValues.iterator().next();
                return QueryFactory.equal(attribute, singleValue);
            }
        }
        Set<Object> values = attributeValues instanceof Set ? (Set<Object>)attributeValues : new HashSet<A>(attributeValues);
        return new In<O, A>(attribute, disjoint, values);
    }

    public static <O, A extends CharSequence> StringStartsWith<O, A> startsWith(Attribute<O, A> attribute, A attributeValue) {
        return new StringStartsWith<O, A>(attribute, attributeValue);
    }

    public static <O, A extends CharSequence> LongestPrefix<O, A> longestPrefix(Attribute<O, A> attribute, A attributeValue) {
        return new LongestPrefix<O, A>(attribute, attributeValue);
    }

    public static <O, A extends Comparable<A>> Min<O, A> min(Attribute<O, A> attribute) {
        return new Min<O, A>(attribute);
    }

    public static <O, A extends Comparable<A>> Max<O, A> max(Attribute<O, A> attribute) {
        return new Max<O, A>(attribute);
    }

    public static <O, A extends CharSequence> StringIsPrefixOf<O, A> isPrefixOf(Attribute<O, A> attribute, A attributeValue) {
        return new StringIsPrefixOf<O, A>(attribute, attributeValue);
    }

    public static <O, A extends CharSequence> StringEndsWith<O, A> endsWith(Attribute<O, A> attribute, A attributeValue) {
        return new StringEndsWith<O, A>(attribute, attributeValue);
    }

    public static <O, A extends CharSequence> StringContains<O, A> contains(Attribute<O, A> attribute, A attributeValue) {
        return new StringContains<O, A>(attribute, attributeValue);
    }

    public static <O, A extends CharSequence> StringIsContainedIn<O, A> isContainedIn(Attribute<O, A> attribute, A attributeValue) {
        return new StringIsContainedIn<O, A>(attribute, attributeValue);
    }

    public static <O, A extends CharSequence> StringMatchesRegex<O, A> matchesRegex(Attribute<O, A> attribute, Pattern regexPattern) {
        return new StringMatchesRegex<O, A>(attribute, regexPattern);
    }

    public static <O, A extends CharSequence> StringMatchesRegex<O, A> matchesRegex(Attribute<O, A> attribute, String regex) {
        return new StringMatchesRegex<O, A>(attribute, Pattern.compile(regex));
    }

    public static <O, A> Has<O, A> has(Attribute<O, A> attribute) {
        return new Has<O, A>(attribute);
    }

    public static <O> And<O> and(Query<O> query1, Query<O> query2) {
        List queries = Arrays.asList(query1, query2);
        return new And(queries);
    }

    public static <O> And<O> and(Query<O> query1, Query<O> query2, Query<O> ... additionalQueries) {
        ArrayList queries = new ArrayList(2 + additionalQueries.length);
        queries.add(query1);
        queries.add(query2);
        Collections.addAll(queries, additionalQueries);
        return new And(queries);
    }

    public static <O> And<O> and(Query<O> query1, Query<O> query2, Collection<Query<O>> additionalQueries) {
        ArrayList queries = new ArrayList(2 + additionalQueries.size());
        queries.add(query1);
        queries.add(query2);
        queries.addAll(additionalQueries);
        return new And(queries);
    }

    public static <O> Or<O> or(Query<O> query1, Query<O> query2) {
        List queries = Arrays.asList(query1, query2);
        return new Or(queries);
    }

    public static <O> Or<O> or(Query<O> query1, Query<O> query2, Query<O> ... additionalQueries) {
        ArrayList queries = new ArrayList(2 + additionalQueries.length);
        queries.add(query1);
        queries.add(query2);
        Collections.addAll(queries, additionalQueries);
        return new Or(queries);
    }

    public static <O> Or<O> or(Query<O> query1, Query<O> query2, Collection<Query<O>> additionalQueries) {
        ArrayList queries = new ArrayList(2 + additionalQueries.size());
        queries.add(query1);
        queries.add(query2);
        queries.addAll(additionalQueries);
        return new Or(queries);
    }

    public static <O> Not<O> not(Query<O> query) {
        return new Not<O>(query);
    }

    public static <O, F, A> Query<O> existsIn(IndexedCollection<F> foreignCollection, Attribute<O, A> localKeyAttribute, Attribute<F, A> foreignKeyAttribute) {
        return new ExistsIn<O, F, A>(foreignCollection, localKeyAttribute, foreignKeyAttribute);
    }

    public static <O, F, A> Query<O> existsIn(IndexedCollection<F> foreignCollection, Attribute<O, A> localKeyAttribute, Attribute<F, A> foreignKeyAttribute, Query<F> foreignRestrictions) {
        return new ExistsIn<O, F, A>(foreignCollection, localKeyAttribute, foreignKeyAttribute, foreignRestrictions);
    }

    public static <O> Query<O> all(Class<O> objectType) {
        return new All<O>(objectType);
    }

    public static <O> Query<O> none(Class<O> objectType) {
        return new None<O>(objectType);
    }

    public static <O> OrderByOption<O> orderBy(List<AttributeOrder<O>> attributeOrders) {
        return new OrderByOption<O>(attributeOrders);
    }

    public static <O> OrderByOption<O> orderBy(AttributeOrder<O> ... attributeOrders) {
        return new OrderByOption<O>(Arrays.asList(attributeOrders));
    }

    public static <O> AttributeOrder<O> ascending(Attribute<O, ? extends Comparable> attribute) {
        return new AttributeOrder<O>(attribute, false);
    }

    public static <O> AttributeOrder<O> descending(Attribute<O, ? extends Comparable> attribute) {
        return new AttributeOrder<O>(attribute, true);
    }

    public static DeduplicationOption deduplicate(DeduplicationStrategy deduplicationStrategy) {
        return new DeduplicationOption(deduplicationStrategy);
    }

    public static IsolationOption isolationLevel(IsolationLevel isolationLevel) {
        return new IsolationOption(isolationLevel);
    }

    public static ArgumentValidationOption argumentValidation(ArgumentValidationStrategy strategy) {
        return new ArgumentValidationOption(strategy);
    }

    public static QueryOptions queryOptions(Object ... queryOptions) {
        return QueryFactory.queryOptions(Arrays.asList(queryOptions));
    }

    public static QueryOptions queryOptions(Collection<Object> queryOptions) {
        QueryOptions resultOptions = new QueryOptions();
        for (Object queryOption : queryOptions) {
            resultOptions.put(queryOption.getClass(), queryOption);
        }
        return resultOptions;
    }

    public static QueryOptions noQueryOptions() {
        return new QueryOptions();
    }

    public static FlagsEnabled enableFlags(Object ... flags) {
        FlagsEnabled result = new FlagsEnabled();
        for (Object flag : flags) {
            result.add(flag);
        }
        return result;
    }

    public static FlagsDisabled disableFlags(Object ... flags) {
        FlagsDisabled result = new FlagsDisabled();
        for (Object flag : flags) {
            result.add(flag);
        }
        return result;
    }

    public static Thresholds applyThresholds(Threshold ... thresholds) {
        return new Thresholds(Arrays.asList(thresholds));
    }

    public static Threshold threshold(Object key, Double value) {
        return new Threshold(key, value);
    }

    public static <O> SelfAttribute<O> selfAttribute(Class<O> objectType) {
        return new SelfAttribute<O>(objectType);
    }

    public static <K, A> Attribute<Map, A> mapAttribute(K mapKey, Class<A> mapValueType) {
        return new SimpleNullableMapAttribute<K, A>(mapKey, mapValueType);
    }

    public static Map mapEntity(Map map) {
        return map instanceof MapEntity ? map : new MapEntity(map);
    }

    public static Map primaryKeyedMapEntity(Map map, Object primaryKey) {
        return map instanceof PrimaryKeyedMapEntity ? map : new PrimaryKeyedMapEntity(map, primaryKey);
    }

    public static <O> OrderMissingLastAttribute<O> missingLast(Attribute<O, ? extends Comparable> delegateAttribute) {
        return new OrderMissingLastAttribute<O>(delegateAttribute);
    }

    public static <O> OrderMissingFirstAttribute<O> missingFirst(Attribute<O, ? extends Comparable> delegateAttribute) {
        return new OrderMissingFirstAttribute<O>(delegateAttribute);
    }

    public static <O> StandingQueryAttribute<O> forStandingQuery(Query<O> standingQuery) {
        return new StandingQueryAttribute<O>(standingQuery);
    }

    public static <O, A> StandingQueryAttribute<O> forObjectsMissing(Attribute<O, A> attribute) {
        return QueryFactory.forStandingQuery(QueryFactory.not(QueryFactory.has(attribute)));
    }

    public static <O, A> SimpleAttribute<O, A> attribute(SimpleFunction<O, A> function) {
        return QueryFactory.attribute(function.getClass().getName(), function);
    }

    public static <O, A> SimpleAttribute<O, A> attribute(String attributeName, SimpleFunction<O, A> function) {
        FunctionGenericTypes<O, A> resolved = QueryFactory.resolveSimpleFunctionGenericTypes(function.getClass());
        return QueryFactory.attribute(resolved.objectType, resolved.attributeType, attributeName, function);
    }

    public static <O, A> SimpleAttribute<O, A> attribute(Class<O> objectType, Class<A> attributeType, String attributeName, SimpleFunction<O, A> function) {
        return new FunctionalSimpleAttribute<O, A>(objectType, attributeType, attributeName, function);
    }

    public static <O, A> SimpleNullableAttribute<O, A> nullableAttribute(SimpleFunction<O, A> function) {
        return QueryFactory.nullableAttribute(function.getClass().getName(), function);
    }

    public static <O, A> SimpleNullableAttribute<O, A> nullableAttribute(String attributeName, SimpleFunction<O, A> function) {
        FunctionGenericTypes<O, A> resolved = QueryFactory.resolveSimpleFunctionGenericTypes(function.getClass());
        return QueryFactory.nullableAttribute(resolved.objectType, resolved.attributeType, attributeName, function);
    }

    public static <O, A> SimpleNullableAttribute<O, A> nullableAttribute(Class<O> objectType, Class<A> attributeType, String attributeName, SimpleFunction<O, A> function) {
        return new FunctionalSimpleNullableAttribute<O, A>(objectType, attributeType, attributeName, function);
    }

    public static <O, A, I extends Iterable<A>> MultiValueAttribute<O, A> attribute(Class<A> attributeType, MultiValueFunction<O, A, I> function) {
        return QueryFactory.attribute(attributeType, function.getClass().getName(), function);
    }

    public static <O, A, I extends Iterable<A>> MultiValueAttribute<O, A> attribute(Class<A> attributeType, String attributeName, MultiValueFunction<O, A, I> function) {
        Class<O> resolvedObjectType = QueryFactory.resolveMultiValueFunctionGenericObjectType(function.getClass());
        return QueryFactory.attribute(resolvedObjectType, attributeType, attributeName, function);
    }

    public static <O, A, I extends Iterable<A>> MultiValueAttribute<O, A> attribute(Class<O> objectType, Class<A> attributeType, String attributeName, MultiValueFunction<O, A, I> function) {
        return new FunctionalMultiValueAttribute<O, A, I>(objectType, attributeType, attributeName, function);
    }

    public static <O, A, I extends Iterable<A>> MultiValueNullableAttribute<O, A> nullableAttribute(Class<A> attributeType, MultiValueFunction<O, A, I> function) {
        return QueryFactory.nullableAttribute(attributeType, function.getClass().getName(), function);
    }

    public static <O, A, I extends Iterable<A>> MultiValueNullableAttribute<O, A> nullableAttribute(Class<A> attributeType, String attributeName, MultiValueFunction<O, A, I> function) {
        Class<O> resolvedObjectType = QueryFactory.resolveMultiValueFunctionGenericObjectType(function.getClass());
        return QueryFactory.nullableAttribute(resolvedObjectType, attributeType, attributeName, function);
    }

    public static <O, A, I extends Iterable<A>> MultiValueNullableAttribute<O, A> nullableAttribute(Class<O> objectType, Class<A> attributeType, String attributeName, MultiValueFunction<O, A, I> function) {
        return new FunctionalMultiValueNullableAttribute<O, A, I>(objectType, attributeType, attributeName, true, function);
    }

    static <O, A, F> FunctionGenericTypes<O, A> resolveSimpleFunctionGenericTypes(Class<?> subType) {
        Class[] typeArgs = TypeResolver.resolveRawArguments(SimpleFunction.class, subType);
        QueryFactory.validateSimpleFunctionGenericTypes(typeArgs, subType);
        Class objectType = typeArgs[0];
        Class attributeType = typeArgs[1];
        return new FunctionGenericTypes(objectType, attributeType);
    }

    static void validateSimpleFunctionGenericTypes(Class<?>[] typeArgs, Class<?> subType) {
        if (typeArgs == null) {
            throw new IllegalStateException("Could not resolve any generic type information from the given function of type: " + subType.getName() + ". " + GENERIC_TYPE_RESOLUTION_FAILURE_MESSAGE);
        }
        if (typeArgs.length != 2 || typeArgs[0] == TypeResolver.Unknown.class || typeArgs[1] == TypeResolver.Unknown.class) {
            throw new IllegalStateException("Could not resolve sufficient generic type information from the given function of type: " + subType.getName() + ", resolved: " + Arrays.toString(typeArgs) + ". " + GENERIC_TYPE_RESOLUTION_FAILURE_MESSAGE);
        }
    }

    static <O> Class<O> resolveMultiValueFunctionGenericObjectType(Class<?> subType) {
        Class[] typeArgs = TypeResolver.resolveRawArguments(MultiValueFunction.class, subType);
        QueryFactory.validateMultiValueFunctionGenericTypes(typeArgs, subType);
        Class objectType = typeArgs[0];
        return objectType;
    }

    static void validateMultiValueFunctionGenericTypes(Class<?>[] typeArgs, Class<?> subType) {
        if (typeArgs == null) {
            throw new IllegalStateException("Could not resolve any generic type information from the given function of type: " + subType.getName() + ". " + GENERIC_TYPE_RESOLUTION_FAILURE_MESSAGE);
        }
        if (typeArgs.length != 3 || typeArgs[0] == TypeResolver.Unknown.class) {
            throw new IllegalStateException("Could not resolve sufficient generic type information from the given function of type: " + subType.getName() + ", resolved: " + Arrays.toString(typeArgs) + ". " + GENERIC_TYPE_RESOLUTION_FAILURE_MESSAGE);
        }
    }

    public static <O> And<O> and(Query<O> query1, Query<O> query2, Query<O> query3) {
        List queries = Arrays.asList(query1, query2, query3);
        return new And(queries);
    }

    public static <O> And<O> and(Query<O> query1, Query<O> query2, Query<O> query3, Query<O> query4) {
        List queries = Arrays.asList(query1, query2, query3, query4);
        return new And(queries);
    }

    public static <O> And<O> and(Query<O> query1, Query<O> query2, Query<O> query3, Query<O> query4, Query<O> query5) {
        List queries = Arrays.asList(query1, query2, query3, query4, query5);
        return new And(queries);
    }

    public static <O> Or<O> or(Query<O> query1, Query<O> query2, Query<O> query3) {
        List queries = Arrays.asList(query1, query2, query3);
        return new Or(queries);
    }

    public static <O> Or<O> or(Query<O> query1, Query<O> query2, Query<O> query3, Query<O> query4) {
        List queries = Arrays.asList(query1, query2, query3, query4);
        return new Or(queries);
    }

    public static <O> Or<O> or(Query<O> query1, Query<O> query2, Query<O> query3, Query<O> query4, Query<O> query5) {
        List queries = Arrays.asList(query1, query2, query3, query4, query5);
        return new Or(queries);
    }

    public static <O> OrderByOption<O> orderBy(AttributeOrder<O> attributeOrder) {
        List<AttributeOrder<O>> attributeOrders = Collections.singletonList(attributeOrder);
        return new OrderByOption<O>(attributeOrders);
    }

    public static <O> OrderByOption<O> orderBy(AttributeOrder<O> attributeOrder1, AttributeOrder<O> attributeOrder2) {
        List attributeOrders = Arrays.asList(attributeOrder1, attributeOrder2);
        return new OrderByOption(attributeOrders);
    }

    public static <O> OrderByOption<O> orderBy(AttributeOrder<O> attributeOrder1, AttributeOrder<O> attributeOrder2, AttributeOrder<O> attributeOrder3) {
        List attributeOrders = Arrays.asList(attributeOrder1, attributeOrder2, attributeOrder3);
        return new OrderByOption(attributeOrders);
    }

    public static <O> OrderByOption<O> orderBy(AttributeOrder<O> attributeOrder1, AttributeOrder<O> attributeOrder2, AttributeOrder<O> attributeOrder3, AttributeOrder<O> attributeOrder4) {
        List attributeOrders = Arrays.asList(attributeOrder1, attributeOrder2, attributeOrder3, attributeOrder4);
        return new OrderByOption(attributeOrders);
    }

    public static <O> OrderByOption<O> orderBy(AttributeOrder<O> attributeOrder1, AttributeOrder<O> attributeOrder2, AttributeOrder<O> attributeOrder3, AttributeOrder<O> attributeOrder4, AttributeOrder<O> attributeOrder5) {
        List attributeOrders = Arrays.asList(attributeOrder1, attributeOrder2, attributeOrder3, attributeOrder4, attributeOrder5);
        return new OrderByOption(attributeOrders);
    }

    public static <O> Predicate<O> predicate(Query<O> query) {
        return QueryFactory.predicate(query, null);
    }

    public static <O> Predicate<O> predicate(Query<O> query, QueryOptions queryOptions) {
        return object -> query.matches(object, queryOptions);
    }

    public static QueryOptions queryOptions(Object queryOption) {
        return QueryFactory.queryOptions(Collections.singleton(queryOption));
    }

    public static QueryOptions queryOptions(Object queryOption1, Object queryOption2) {
        List<Object> queryOptions = Arrays.asList(queryOption1, queryOption2);
        return QueryFactory.queryOptions(queryOptions);
    }

    static class FunctionGenericTypes<O, A> {
        final Class<O> objectType;
        final Class<A> attributeType;

        FunctionGenericTypes(Class<O> objectType, Class<A> attributeType) {
            this.objectType = objectType;
            this.attributeType = attributeType;
        }
    }
}

