/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.rest.cxf.service;

import jakarta.ws.rs.core.Response;
import java.time.OffsetDateTime;
import org.apache.syncope.common.lib.request.AnyCR;
import org.apache.syncope.common.lib.request.AnyUR;
import org.apache.syncope.common.lib.to.PagedResult;
import org.apache.syncope.common.lib.to.ProvisioningResult;
import org.apache.syncope.common.lib.to.RemediationTO;
import org.apache.syncope.common.lib.types.AnyTypeKind;
import org.apache.syncope.common.rest.api.beans.AbstractQuery;
import org.apache.syncope.common.rest.api.beans.RemediationQuery;
import org.apache.syncope.common.rest.api.service.RemediationService;
import org.apache.syncope.core.logic.RemediationLogic;
import org.apache.syncope.core.persistence.api.dao.NotFoundException;
import org.apache.syncope.core.persistence.api.entity.AnyUtilsFactory;
import org.apache.syncope.core.rest.cxf.service.AbstractService;
import org.springframework.data.domain.Page;

public class RemediationServiceImpl
extends AbstractService
implements RemediationService {
    protected final RemediationLogic logic;
    protected final AnyUtilsFactory anyUtilsFactory;

    public RemediationServiceImpl(RemediationLogic logic, AnyUtilsFactory anyUtilsFactory) {
        this.logic = logic;
        this.anyUtilsFactory = anyUtilsFactory;
    }

    public PagedResult<RemediationTO> list(RemediationQuery query) {
        Page result = this.logic.list(query.getBefore(), query.getAfter(), RemediationServiceImpl.pageable((AbstractQuery)query));
        return this.buildPagedResult(result);
    }

    public RemediationTO read(String key) {
        return this.logic.read(key);
    }

    public Response delete(String key) {
        this.logic.delete(key);
        return Response.noContent().build();
    }

    public Response remedy(String remediationKey, AnyCR anyCR) {
        ProvisioningResult created = this.logic.remedy(remediationKey, anyCR, this.isNullPriorityAsync());
        return this.createResponse(created);
    }

    private void check(String key, String anyKey) {
        RemediationTO remediation = this.logic.read(key);
        AnyTypeKind anyTypeKind = AnyTypeKind.USER.name().equals(remediation.getAnyType()) ? AnyTypeKind.USER : (AnyTypeKind.GROUP.name().equals(remediation.getAnyType()) ? AnyTypeKind.GROUP : AnyTypeKind.ANY_OBJECT);
        OffsetDateTime etag = (OffsetDateTime)this.anyUtilsFactory.getInstance(anyTypeKind).dao().findLastChange(anyKey).orElseThrow(() -> new NotFoundException(remediation.getAnyType() + " for " + key));
        this.checkETag(String.valueOf(etag.toInstant().toEpochMilli()));
    }

    public Response remedy(String remediationKey, AnyUR anyUR) {
        this.check(remediationKey, anyUR.getKey());
        ProvisioningResult updated = this.logic.remedy(remediationKey, anyUR, this.isNullPriorityAsync());
        return this.modificationResponse(updated);
    }

    public Response remedy(String remediationKey, String anyKey) {
        this.check(remediationKey, anyKey);
        ProvisioningResult deleted = this.logic.remedy(remediationKey, anyKey, this.isNullPriorityAsync());
        return this.modificationResponse(deleted);
    }
}

