/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.migration;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.flowable.engine.migration.ActivityMigrationMappingOptions;

public abstract class ActivityMigrationMapping {
    protected String toCallActivityId;
    protected Integer callActivityProcessDefinitionVersion;
    protected String fromCallActivityId;

    public abstract List<String> getFromActivityIds();

    public abstract List<String> getToActivityIds();

    public boolean isToParentProcess() {
        return this.fromCallActivityId != null;
    }

    public boolean isToCallActivity() {
        return this.toCallActivityId != null;
    }

    public String getToCallActivityId() {
        return this.toCallActivityId;
    }

    public Integer getCallActivityProcessDefinitionVersion() {
        return this.callActivityProcessDefinitionVersion;
    }

    public String getFromCallActivityId() {
        return this.fromCallActivityId;
    }

    public static OneToOneMapping createMappingFor(String fromActivityId, String toActivityId) {
        return new OneToOneMapping(fromActivityId, toActivityId);
    }

    public static OneToManyMapping createMappingFor(String fromActivityId, List<String> toActivityIds) {
        return new OneToManyMapping(fromActivityId, toActivityIds);
    }

    public static ManyToOneMapping createMappingFor(List<String> fromActivityIds, String toActivityId) {
        return new ManyToOneMapping(fromActivityIds, toActivityId);
    }

    public static class OneToOneMapping
    extends ActivityMigrationMapping
    implements ActivityMigrationMappingOptions.SingleToActivityOptions<OneToOneMapping> {
        public String fromActivityId;
        public String toActivityId;
        protected String withNewAssignee;
        protected String withNewOwner;
        protected Map<String, Object> withLocalVariables = new LinkedHashMap<String, Object>();

        public OneToOneMapping(String fromActivityId, String toActivityId) {
            this.fromActivityId = fromActivityId;
            this.toActivityId = toActivityId;
        }

        @Override
        public List<String> getFromActivityIds() {
            ArrayList<String> list = new ArrayList<String>();
            list.add(this.fromActivityId);
            return list;
        }

        @Override
        public List<String> getToActivityIds() {
            ArrayList<String> list = new ArrayList<String>();
            list.add(this.toActivityId);
            return list;
        }

        public String getFromActivityId() {
            return this.fromActivityId;
        }

        public String getToActivityId() {
            return this.toActivityId;
        }

        @Override
        public OneToOneMapping inParentProcessOfCallActivityId(String fromCallActivityId) {
            this.fromCallActivityId = fromCallActivityId;
            this.toCallActivityId = null;
            this.callActivityProcessDefinitionVersion = null;
            return this;
        }

        @Override
        public OneToOneMapping inSubProcessOfCallActivityId(String toCallActivityId) {
            this.toCallActivityId = toCallActivityId;
            this.callActivityProcessDefinitionVersion = null;
            this.fromCallActivityId = null;
            return this;
        }

        @Override
        public OneToOneMapping inSubProcessOfCallActivityId(String toCallActivityId, int subProcessDefVersion) {
            this.toCallActivityId = toCallActivityId;
            this.callActivityProcessDefinitionVersion = subProcessDefVersion;
            this.fromCallActivityId = null;
            return this;
        }

        @Override
        public OneToOneMapping withNewAssignee(String newAssigneeId) {
            this.withNewAssignee = newAssigneeId;
            return this;
        }

        @Override
        public String getWithNewAssignee() {
            return this.withNewAssignee;
        }

        @Override
        public OneToOneMapping withNewOwner(String newOwner) {
            this.withNewOwner = newOwner;
            return this;
        }

        @Override
        public String getWithNewOwner() {
            return this.withNewOwner;
        }

        @Override
        public OneToOneMapping withLocalVariable(String variableName, Object variableValue) {
            this.withLocalVariables.put(variableName, variableValue);
            return this;
        }

        @Override
        public OneToOneMapping withLocalVariables(Map<String, Object> variables) {
            this.withLocalVariables.putAll(variables);
            return this;
        }

        @Override
        public Map<String, Object> getActivityLocalVariables() {
            return this.withLocalVariables;
        }

        public String toString() {
            return "OneToOneMapping{fromActivityId='" + this.fromActivityId + "', toActivityId='" + this.toActivityId + "'}";
        }
    }

    public static class OneToManyMapping
    extends ActivityMigrationMapping
    implements ActivityMigrationMappingOptions.MultipleToActivityOptions<OneToManyMapping> {
        public String fromActivityId;
        public List<String> toActivityIds;
        protected Map<String, Map<String, Object>> withLocalVariables = new LinkedHashMap<String, Map<String, Object>>();

        public OneToManyMapping(String fromActivityId, List<String> toActivityIds) {
            this.fromActivityId = fromActivityId;
            this.toActivityIds = toActivityIds;
        }

        @Override
        public List<String> getFromActivityIds() {
            ArrayList<String> list = new ArrayList<String>();
            list.add(this.fromActivityId);
            return list;
        }

        @Override
        public List<String> getToActivityIds() {
            return new ArrayList<String>(this.toActivityIds);
        }

        public String getFromActivityId() {
            return this.fromActivityId;
        }

        @Override
        public OneToManyMapping inParentProcessOfCallActivityId(String fromCallActivityId) {
            this.fromCallActivityId = fromCallActivityId;
            this.toCallActivityId = null;
            this.callActivityProcessDefinitionVersion = null;
            return this;
        }

        @Override
        public OneToManyMapping inSubProcessOfCallActivityId(String toCallActivityId) {
            this.toCallActivityId = toCallActivityId;
            this.callActivityProcessDefinitionVersion = null;
            this.fromCallActivityId = null;
            return this;
        }

        @Override
        public OneToManyMapping inSubProcessOfCallActivityId(String toCallActivityId, int subProcessDefVersion) {
            this.toCallActivityId = toCallActivityId;
            this.callActivityProcessDefinitionVersion = subProcessDefVersion;
            this.fromCallActivityId = null;
            return this;
        }

        @Override
        public OneToManyMapping withLocalVariableForActivity(String toActivity, String variableName, Object variableValue) {
            Map activityVariables = this.withLocalVariables.computeIfAbsent(toActivity, key -> new HashMap());
            activityVariables.put(variableName, variableValue);
            return this;
        }

        @Override
        public OneToManyMapping withLocalVariablesForActivity(String toActivity, Map<String, Object> variables) {
            Map activityVariables = this.withLocalVariables.computeIfAbsent(toActivity, key -> new HashMap());
            activityVariables.putAll(variables);
            return this;
        }

        @Override
        public OneToManyMapping withLocalVariableForAllActivities(String variableName, Object variableValue) {
            this.toActivityIds.forEach(id -> this.withLocalVariableForActivity((String)id, variableName, variableValue));
            return this;
        }

        @Override
        public OneToManyMapping withLocalVariablesForAllActivities(Map<String, Object> variables) {
            this.toActivityIds.forEach(id -> this.withLocalVariablesForActivity((String)id, (Map)variables));
            return this;
        }

        @Override
        public OneToManyMapping withLocalVariables(Map<String, Map<String, Object>> mappingVariables) {
            this.withLocalVariables.putAll(mappingVariables);
            return this;
        }

        @Override
        public Map<String, Map<String, Object>> getActivitiesLocalVariables() {
            return this.withLocalVariables;
        }

        public String toString() {
            return "OneToManyMapping{fromActivityId='" + this.fromActivityId + "', toActivityIds=" + String.valueOf(this.toActivityIds) + "}";
        }
    }

    public static class ManyToOneMapping
    extends ActivityMigrationMapping
    implements ActivityMigrationMappingOptions.SingleToActivityOptions<ManyToOneMapping> {
        public List<String> fromActivityIds;
        public String toActivityId;
        protected String withNewAssignee;
        protected String withNewOwner;
        protected Map<String, Object> withLocalVariables = new LinkedHashMap<String, Object>();

        public ManyToOneMapping(List<String> fromActivityIds, String toActivityId) {
            this.fromActivityIds = fromActivityIds;
            this.toActivityId = toActivityId;
        }

        @Override
        public List<String> getFromActivityIds() {
            return new ArrayList<String>(this.fromActivityIds);
        }

        @Override
        public List<String> getToActivityIds() {
            ArrayList<String> list = new ArrayList<String>();
            list.add(this.toActivityId);
            return list;
        }

        public String getToActivityId() {
            return this.toActivityId;
        }

        @Override
        public ManyToOneMapping inParentProcessOfCallActivityId(String fromCallActivityId) {
            this.fromCallActivityId = fromCallActivityId;
            this.toCallActivityId = null;
            this.callActivityProcessDefinitionVersion = null;
            return this;
        }

        @Override
        public ManyToOneMapping inSubProcessOfCallActivityId(String toCallActivityId) {
            this.toCallActivityId = toCallActivityId;
            this.callActivityProcessDefinitionVersion = null;
            this.fromCallActivityId = null;
            return this;
        }

        @Override
        public ManyToOneMapping inSubProcessOfCallActivityId(String toCallActivityId, int subProcessDefVersion) {
            this.toCallActivityId = toCallActivityId;
            this.callActivityProcessDefinitionVersion = subProcessDefVersion;
            this.fromCallActivityId = null;
            return this;
        }

        @Override
        public ManyToOneMapping withNewAssignee(String newAssigneeId) {
            this.withNewAssignee = newAssigneeId;
            return this;
        }

        @Override
        public String getWithNewAssignee() {
            return this.withNewAssignee;
        }

        @Override
        public ManyToOneMapping withNewOwner(String newOwner) {
            this.withNewOwner = newOwner;
            return this;
        }

        @Override
        public String getWithNewOwner() {
            return this.withNewOwner;
        }

        @Override
        public ManyToOneMapping withLocalVariable(String variableName, Object variableValue) {
            this.withLocalVariables.put(variableName, variableValue);
            return this;
        }

        @Override
        public ManyToOneMapping withLocalVariables(Map<String, Object> variables) {
            this.withLocalVariables.putAll(variables);
            return this;
        }

        @Override
        public Map<String, Object> getActivityLocalVariables() {
            return this.withLocalVariables;
        }

        public String toString() {
            return "ManyToOneMapping{fromActivityIds=" + String.valueOf(this.fromActivityIds) + ", toActivityId='" + this.toActivityId + "'}";
        }
    }
}

