/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.html.media;

import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.model.IModel;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.apache.wicket.request.resource.PackageResource;
import org.apache.wicket.request.resource.PackageResourceReference;
import org.apache.wicket.request.resource.ResourceReference;
import org.apache.wicket.util.resource.IResourceStream;

public class Source
extends WebMarkupContainer {
    private static final long serialVersionUID = 1L;
    private boolean displayType;
    private String type;
    private String media;
    private PageParameters pageParameters;
    private final ResourceReference resourceReference;
    private final String url;

    public Source(String id) {
        this(id, null, null, null, null);
    }

    public Source(String id, IModel<?> model) {
        this(id, model, null, null, null);
    }

    public Source(String id, ResourceReference resourceReference) {
        this(id, null, null, null, resourceReference);
    }

    public Source(String id, IModel<?> model, ResourceReference resourceReference) {
        this(id, model, null, null, resourceReference);
    }

    public Source(String id, ResourceReference resourceReference, PageParameters pageParameters) {
        this(id, null, null, pageParameters, resourceReference);
    }

    public Source(String id, IModel<?> model, ResourceReference resourceReference, PageParameters pageParameters) {
        this(id, model, null, pageParameters, resourceReference);
    }

    public Source(String id, String url) {
        this(id, null, url, null, null);
    }

    public Source(String id, IModel<?> model, String url) {
        this(id, model, url, null, null);
    }

    private Source(String id, IModel<?> model, String url, PageParameters pageParameters, ResourceReference resourceReference) {
        super(id, model);
        this.url = url;
        this.pageParameters = pageParameters;
        this.resourceReference = resourceReference;
    }

    @Override
    protected void onComponentTag(ComponentTag tag) {
        String _media;
        this.checkComponentTag(tag, "source");
        super.onComponentTag(tag);
        if (this.resourceReference != null) {
            CharSequence url = RequestCycle.get().urlFor(this.resourceReference, this.pageParameters);
            tag.put("src", url);
        } else if (this.url != null) {
            tag.put("src", this.url);
        }
        if (this.getDisplayType()) {
            if (this.type != null) {
                tag.put("type", this.type);
            } else if (this.resourceReference != null && this.resourceReference instanceof PackageResourceReference) {
                PackageResource resource = ((PackageResourceReference)this.resourceReference).getResource();
                IResourceStream resourceStream = resource.getResourceStream();
                String contentType = resourceStream.getContentType();
                tag.put("type", contentType);
            }
        }
        if ((_media = this.getMedia()) != null) {
            tag.put("media", _media);
        }
    }

    public boolean getDisplayType() {
        return this.displayType;
    }

    public void setDisplayType(boolean displayType) {
        this.displayType = displayType;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getMedia() {
        return this.media;
    }

    public void setMedia(String media) {
        this.media = media;
    }

    public PageParameters getPageParameters() {
        return this.pageParameters;
    }

    public void setPageParameters(PageParameters pageParameters) {
        this.pageParameters = pageParameters;
    }
}

