/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.logic;

import java.lang.reflect.Method;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.syncope.common.lib.to.SecurityQuestionTO;
import org.apache.syncope.core.logic.AbstractTransactionalLogic;
import org.apache.syncope.core.logic.UnresolvedReferenceException;
import org.apache.syncope.core.persistence.api.dao.NotFoundException;
import org.apache.syncope.core.persistence.api.dao.SecurityQuestionDAO;
import org.apache.syncope.core.persistence.api.dao.UserDAO;
import org.apache.syncope.core.persistence.api.entity.Entity;
import org.apache.syncope.core.persistence.api.entity.user.SecurityQuestion;
import org.apache.syncope.core.persistence.api.entity.user.User;
import org.apache.syncope.core.provisioning.api.data.SecurityQuestionDataBinder;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.transaction.annotation.Transactional;

public class SecurityQuestionLogic
extends AbstractTransactionalLogic<SecurityQuestionTO> {
    protected final SecurityQuestionDAO securityQuestionDAO;
    protected final UserDAO userDAO;
    protected final SecurityQuestionDataBinder binder;

    public SecurityQuestionLogic(SecurityQuestionDAO securityQuestionDAO, UserDAO userDAO, SecurityQuestionDataBinder binder) {
        this.securityQuestionDAO = securityQuestionDAO;
        this.userDAO = userDAO;
        this.binder = binder;
    }

    @PreAuthorize(value="isAuthenticated()")
    @Transactional(readOnly=true)
    public List<SecurityQuestionTO> list() {
        return this.securityQuestionDAO.findAll().stream().map(arg_0 -> ((SecurityQuestionDataBinder)this.binder).getSecurityQuestionTO(arg_0)).toList();
    }

    @PreAuthorize(value="hasRole('SECURITY_QUESTION_READ')")
    @Transactional(readOnly=true)
    public SecurityQuestionTO read(String key) {
        SecurityQuestion securityQuestion = (SecurityQuestion)this.securityQuestionDAO.findById(key).orElseThrow(() -> new NotFoundException("SecurityQuestion " + key));
        return this.binder.getSecurityQuestionTO(securityQuestion);
    }

    @PreAuthorize(value="hasRole('SECURITY_QUESTION_CREATE')")
    public SecurityQuestionTO create(SecurityQuestionTO securityQuestionTO) {
        return this.binder.getSecurityQuestionTO((SecurityQuestion)this.securityQuestionDAO.save((Entity)this.binder.create(securityQuestionTO)));
    }

    @PreAuthorize(value="hasRole('SECURITY_QUESTION_UPDATE')")
    public SecurityQuestionTO update(SecurityQuestionTO securityQuestionTO) {
        SecurityQuestion securityQuestion = (SecurityQuestion)this.securityQuestionDAO.findById(securityQuestionTO.getKey()).orElseThrow(() -> new NotFoundException("SecurityQuestion " + securityQuestionTO.getKey()));
        this.binder.update(securityQuestion, securityQuestionTO);
        securityQuestion = (SecurityQuestion)this.securityQuestionDAO.save((Entity)securityQuestion);
        return this.binder.getSecurityQuestionTO(securityQuestion);
    }

    @PreAuthorize(value="hasRole('SECURITY_QUESTION_DELETE')")
    public SecurityQuestionTO delete(String key) {
        SecurityQuestion securityQuestion = (SecurityQuestion)this.securityQuestionDAO.findById(key).orElseThrow(() -> new NotFoundException("SecurityQuestion " + key));
        SecurityQuestionTO deleted = this.binder.getSecurityQuestionTO(securityQuestion);
        this.securityQuestionDAO.deleteById(key);
        return deleted;
    }

    @PreAuthorize(value="hasRole('ANONYMOUS')")
    public SecurityQuestionTO readByUser(String username) {
        if (username == null) {
            throw new NotFoundException("Null username");
        }
        User user = (User)this.userDAO.findByUsername(username).orElseThrow(() -> new NotFoundException("User " + username));
        if (user.getSecurityQuestion() == null) {
            LOG.error("Could not find security question for user '{}'", (Object)username);
            throw new NotFoundException("Security question for user " + username);
        }
        return this.binder.getSecurityQuestionTO(user.getSecurityQuestion());
    }

    @Override
    protected SecurityQuestionTO resolveReference(Method method, Object ... args) throws UnresolvedReferenceException {
        String key = null;
        if (ArrayUtils.isNotEmpty((Object[])args)) {
            for (int i = 0; key == null && i < args.length; ++i) {
                Object object = args[i];
                if (object instanceof String) {
                    String string;
                    key = string = (String)object;
                    continue;
                }
                object = args[i];
                if (!(object instanceof SecurityQuestionTO)) continue;
                SecurityQuestionTO securityQuestionTO = (SecurityQuestionTO)object;
                key = securityQuestionTO.getKey();
            }
        }
        if (key != null) {
            try {
                return this.binder.getSecurityQuestionTO((SecurityQuestion)this.securityQuestionDAO.findById(key).orElseThrow());
            }
            catch (Throwable ignore) {
                LOG.debug("Unresolved reference", ignore);
                throw new UnresolvedReferenceException(ignore);
            }
        }
        throw new UnresolvedReferenceException();
    }
}

