/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.oidc.web.response;

import com.nimbusds.jwt.JWTClaimsSet;
import java.time.Clock;
import java.time.LocalDateTime;
import java.util.Date;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.apereo.cas.configuration.support.Beans;
import org.apereo.cas.oidc.OidcConfigurationContext;
import org.apereo.cas.services.OidcRegisteredService;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.support.oauth.web.response.callback.OAuth20ResponseModeBuilder;
import org.apereo.cas.util.DateTimeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;

public abstract class BaseOAuth20JwtResponseModeBuilder
implements OAuth20ResponseModeBuilder {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(BaseOAuth20JwtResponseModeBuilder.class);
    protected final ObjectProvider<OidcConfigurationContext> configurationContext;

    protected Date getExpirationDate() {
        long jwtExpiration = Beans.newDuration((String)((OidcConfigurationContext)((Object)this.configurationContext.getObject())).getCasProperties().getAuthn().getOidc().getJarm().getExpiration()).toSeconds();
        LocalDateTime expiration = LocalDateTime.now(Clock.systemUTC()).plusSeconds(jwtExpiration);
        return DateTimeUtils.dateOf((LocalDateTime)expiration);
    }

    protected String buildJwtResponse(RegisteredService registeredService, Map<String, String> parameters) {
        OidcConfigurationContext ctx = (OidcConfigurationContext)((Object)this.configurationContext.getObject());
        OidcRegisteredService oidcService = Objects.requireNonNull((OidcRegisteredService)registeredService);
        JWTClaimsSet.Builder claimsBuilder = new JWTClaimsSet.Builder().issuer(ctx.getIssuerService().determineIssuer(Optional.of(oidcService))).expirationTime(this.getExpirationDate()).audience(oidcService.getClientId());
        parameters.forEach((arg_0, arg_1) -> ((JWTClaimsSet.Builder)claimsBuilder).claim(arg_0, arg_1));
        JWTClaimsSet claimSet = claimsBuilder.build();
        LOGGER.debug("Generating JWT response based on claims [{}]", (Object)claimSet.toString());
        return ctx.getResponseModeJwtBuilder().build(registeredService, claimSet);
    }

    @Generated
    public BaseOAuth20JwtResponseModeBuilder(ObjectProvider<OidcConfigurationContext> configurationContext) {
        this.configurationContext = configurationContext;
    }
}

