/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.mfa.simple.validation;

import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.mfa.simple.CasSimpleMultifactorTokenCredential;
import org.apereo.cas.mfa.simple.ticket.CasSimpleMultifactorAuthenticationTicket;
import org.apereo.cas.mfa.simple.ticket.CasSimpleMultifactorAuthenticationTicketFactory;
import org.apereo.cas.mfa.simple.validation.BaseCasSimpleMultifactorAuthenticationService;
import org.apereo.cas.mfa.simple.validation.CasSimpleMultifactorAuthenticationAccountService;
import org.apereo.cas.ticket.Ticket;
import org.apereo.cas.ticket.TicketFactory;
import org.apereo.cas.ticket.registry.TicketRegistry;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.function.FunctionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;

public class DefaultCasSimpleMultifactorAuthenticationService
extends BaseCasSimpleMultifactorAuthenticationService {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultCasSimpleMultifactorAuthenticationService.class);
    private static final int MAX_ATTEMPTS = 5;
    protected final TicketFactory ticketFactory;
    protected final ObjectProvider<CasSimpleMultifactorAuthenticationAccountService> accountServiceProvider;

    public DefaultCasSimpleMultifactorAuthenticationService(TicketRegistry ticketRegistry, TicketFactory ticketFactory, ObjectProvider<CasSimpleMultifactorAuthenticationAccountService> accountServiceProvider) {
        super(ticketRegistry);
        this.ticketFactory = ticketFactory;
        this.accountServiceProvider = accountServiceProvider;
    }

    @Override
    public CasSimpleMultifactorAuthenticationTicket generate(Principal principal, Service service) throws Throwable {
        CasSimpleMultifactorAuthenticationTicketFactory mfaFactory = (CasSimpleMultifactorAuthenticationTicketFactory)this.ticketFactory.get(CasSimpleMultifactorAuthenticationTicket.class);
        Map properties = CollectionUtils.wrap((String)"principal", (Object)principal);
        return (CasSimpleMultifactorAuthenticationTicket)FunctionUtils.doAndRetry(retryContext -> {
            CasSimpleMultifactorAuthenticationTicket token = (CasSimpleMultifactorAuthenticationTicket)FunctionUtils.doAndThrow(() -> mfaFactory.create(service, properties), t -> new RuntimeException((Throwable)t));
            String tokenId = token.getId();
            Ticket trackingToken = this.ticketRegistry.getTicket(tokenId);
            if (trackingToken != null) {
                throw new IllegalArgumentException("Token: " + tokenId + " already exists in ticket registry");
            }
            LOGGER.debug("Created multifactor authentication token [{}] for service [{}]", (Object)tokenId, (Object)service);
            return token;
        }, (int)5);
    }

    @Override
    public void store(CasSimpleMultifactorAuthenticationTicket token) {
        token.update();
        Ticket trackingToken = this.ticketRegistry.getTicket(token.getId());
        FunctionUtils.doUnchecked(us -> {
            if (trackingToken != null) {
                LOGGER.debug("Updating existing token [{}] to registry", (Object)token.getId());
                this.ticketRegistry.updateTicket(trackingToken);
            } else {
                LOGGER.debug("Adding token [{}] to registry", (Object)token.getId());
                this.ticketRegistry.addTicket((Ticket)token);
            }
        }, (Object[])new Object[0]);
    }

    @Override
    public Principal fetch(CasSimpleMultifactorTokenCredential tokenCredential) {
        return Optional.ofNullable(this.getMultifactorAuthenticationTicket(tokenCredential)).map(this::getPrincipalFromTicket).orElse(null);
    }

    @Override
    public void update(Principal principal, Map<String, Object> attributes) {
        this.accountServiceProvider.ifAvailable(service -> service.update(principal, attributes));
    }

    @Override
    public Principal validate(Principal resolvedPrincipal, CasSimpleMultifactorTokenCredential credential) throws Exception {
        CasSimpleMultifactorAuthenticationTicket acct = this.getMultifactorAuthenticationTicket(credential);
        LOGGER.debug("Received token [{}] and principal id [{}]", (Object)acct, (Object)resolvedPrincipal.getId());
        Principal principal = this.validateTokenForPrincipal(resolvedPrincipal, acct);
        this.deleteToken(acct);
        LOGGER.debug("Validated token [{}] successfully for [{}].", (Object)credential.getId(), (Object)resolvedPrincipal.getId());
        return principal;
    }
}

