/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.mfa.simple.web;

import com.google.common.base.Splitter;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import java.util.List;
import lombok.Generated;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.AuthenticationException;
import org.apereo.cas.authentication.AuthenticationSystemSupport;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.credential.UsernamePasswordCredential;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.authentication.principal.ServiceFactory;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.mfa.simple.ticket.CasSimpleMultifactorAuthenticationTicket;
import org.apereo.cas.mfa.simple.validation.CasSimpleMultifactorAuthenticationService;
import org.apereo.cas.ticket.Ticket;
import org.apereo.cas.util.EncodingUtils;
import org.apereo.cas.util.function.FunctionUtils;
import org.apereo.cas.web.BaseCasRestActuatorEndpoint;
import org.jooq.lambda.Unchecked;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.actuate.endpoint.Access;
import org.springframework.boot.actuate.endpoint.annotation.Endpoint;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestParam;

@Endpoint(id="mfaSimple", defaultAccess=Access.NONE)
public class CasSimpleMultifactorAuthenticationEndpoint
extends BaseCasRestActuatorEndpoint {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(CasSimpleMultifactorAuthenticationEndpoint.class);

    public CasSimpleMultifactorAuthenticationEndpoint(CasConfigurationProperties casProperties, ConfigurableApplicationContext applicationContext) {
        super(casProperties, applicationContext);
    }

    @GetMapping(produces={"application/json"})
    @Operation(summary="Generate simple multifactor authentication token", parameters={@Parameter(name="credential", required=true, description="Credential header in base64 encoding to carry the user"), @Parameter(name="service", required=true, description="The target service url for which the token should be issued")})
    public ResponseEntity generateToken(@RequestParam String service, @RequestHeader(value="Credential") String authorization) {
        return (ResponseEntity)FunctionUtils.doAndHandle(() -> {
            Credential credential = this.extractCredential(authorization);
            Service givenService = this.extractService(service);
            MultifactorAuthenticationTokenResponse result = this.generateToken(credential, givenService);
            return ResponseEntity.ok((Object)result);
        }, e -> ResponseEntity.badRequest().body((Object)"Invalid or unauthenticated request")).get();
    }

    protected MultifactorAuthenticationTokenResponse generateToken(Credential credential, Service givenService) throws Throwable {
        AuthenticationSystemSupport authnSupport = (AuthenticationSystemSupport)this.applicationContext.getBean("defaultAuthenticationSystemSupport", AuthenticationSystemSupport.class);
        return (MultifactorAuthenticationTokenResponse)authnSupport.handleInitialAuthenticationTransaction(givenService, new Credential[]{credential}).getInitialAuthentication().map(Unchecked.function(authentication -> {
            CasSimpleMultifactorAuthenticationTicket token = this.createAndStoreToken(givenService, (Authentication)authentication);
            return new MultifactorAuthenticationTokenResponse(token.getId(), authentication.getPrincipal().getId(), givenService.getId(), token.getExpirationPolicy().getTimeToLive((Ticket)token));
        })).orElseThrow(() -> new AuthenticationException("Unable to successfully authenticate the user and/or generate token"));
    }

    protected Credential extractCredential(String base64Credentials) {
        List basicAuthCredentials = Splitter.on((char)':').splitToList((CharSequence)EncodingUtils.decodeBase64ToString((String)base64Credentials));
        return new UsernamePasswordCredential((String)basicAuthCredentials.getFirst(), (String)basicAuthCredentials.get(1));
    }

    protected CasSimpleMultifactorAuthenticationTicket createAndStoreToken(Service givenService, Authentication authentication) throws Throwable {
        Principal principal = authentication.getPrincipal();
        CasSimpleMultifactorAuthenticationService mfaService = (CasSimpleMultifactorAuthenticationService)this.applicationContext.getBean("casSimpleMultifactorAuthenticationService", CasSimpleMultifactorAuthenticationService.class);
        CasSimpleMultifactorAuthenticationTicket token = mfaService.generate(principal, givenService);
        mfaService.store(token);
        return token;
    }

    protected Service extractService(String service) {
        ServiceFactory serviceFactory = (ServiceFactory)this.applicationContext.getBean("webApplicationServiceFactory", ServiceFactory.class);
        return serviceFactory.createService(service);
    }

    private record MultifactorAuthenticationTokenResponse(String id, String principal, String service, long ttl) {
    }
}

