/*
 * Decompiled with CFR 0.152.
 */
package org.tomitribe.swizzle.stream;

import java.io.IOException;
import java.io.InputStream;
import org.tomitribe.swizzle.stream.FilteredInputStream;
import org.tomitribe.swizzle.stream.ScanBuffer;
import org.tomitribe.swizzle.stream.StreamTokenHandler;

public class FixedTokenReplacementInputStream
extends FilteredInputStream {
    private final ScanBuffer tokenBuffer;
    private final StreamTokenHandler handler;
    private InputStream value;
    private StreamReadingStrategy strategy;
    private final StreamReadingStrategy flushingValue = new StreamReadingStrategy(){

        @Override
        public int _read() throws IOException {
            int i = FixedTokenReplacementInputStream.this.value.read();
            if (i == -1) {
                FixedTokenReplacementInputStream.this.strategy = FixedTokenReplacementInputStream.this.lookingForToken;
                i = FixedTokenReplacementInputStream.this.read();
            }
            return i;
        }
    };
    private final StreamReadingStrategy lookingForToken = new StreamReadingStrategy(){

        @Override
        public int _read() throws IOException {
            int stream = FixedTokenReplacementInputStream.this.superRead();
            int buffer = FixedTokenReplacementInputStream.this.tokenBuffer.append(stream);
            if (FixedTokenReplacementInputStream.this.tokenBuffer.match()) {
                FixedTokenReplacementInputStream.this.tokenBuffer.flush();
                String token = FixedTokenReplacementInputStream.this.tokenBuffer.getScanString();
                FixedTokenReplacementInputStream.this.value = FixedTokenReplacementInputStream.this.handler.processToken(token);
                FixedTokenReplacementInputStream.this.strategy = FixedTokenReplacementInputStream.this.flushingValue;
                int i = buffer == -1 && stream != -1 ? FixedTokenReplacementInputStream.this.read() : buffer;
                return i;
            }
            int i = buffer == -1 && FixedTokenReplacementInputStream.this.tokenBuffer.hasData() ? this._read() : buffer;
            return i;
        }
    };

    public FixedTokenReplacementInputStream(InputStream in, String token, StreamTokenHandler handler) {
        this(in, token, handler, true);
    }

    public FixedTokenReplacementInputStream(InputStream in, String token, StreamTokenHandler handler, boolean caseSensitive) {
        super(in);
        this.tokenBuffer = new ScanBuffer(token, caseSensitive);
        this.handler = handler;
        this.strategy = this.lookingForToken;
    }

    @Override
    public int read() throws IOException {
        return this.strategy._read();
    }

    private int superRead() throws IOException {
        return super.read();
    }

    static interface StreamReadingStrategy {
        public int _read() throws IOException;
    }
}

