/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 * 
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package org.apache.vinci.transport;

/**
 * Class for representing a list of attributes for an XML element.
 */
public class Attributes extends VinciFrame {

  public Attributes() {
  }

  public Attributes(int initialCapacity) {
    super(initialCapacity);
  }

  /**
   * This method throws an unchecked exception since you should never add non-leaf valued
   * attributes.
   * 
   * @exception UnsupportedOperationException
   *              thrown unconditionally.
   */
  @Override
  public VinciFrame fset(String key, Frame val) {
    throw new UnsupportedOperationException("Can't set frame as attribute value.");
  }

  /**
   * This method throws an unchecked exception since you should never add non-leaf valued
   * attributes.
   * 
   * @exception UnsupportedOperationException
   *              thrown unconditionally.
   */
  @Override
  public Frame fadd(String key, Frame val) {
    throw new UnsupportedOperationException("Can't add frame as attribute value.");
  }

  /**
   * This method throws an unchecked exception since valueless attributes are undefined.
   * 
   * @exception UnsupportedOperationException
   *              thrown unconditionally.
   */
  @Override
  public Frame fadd(String key) {
    throw new UnsupportedOperationException("Can't add empty attribute values.");
  }
}
