/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.logging.log4j2.internal.spi;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.impl.ThrowableProxy;
import org.ops4j.pax.logging.log4j2.internal.spi.PaxLevelImpl;
import org.ops4j.pax.logging.log4j2.internal.spi.PaxLocationInfoImpl;
import org.ops4j.pax.logging.spi.PaxLevel;
import org.ops4j.pax.logging.spi.PaxLocationInfo;
import org.ops4j.pax.logging.spi.PaxLoggingEvent;

public class PaxLoggingEventImpl
implements PaxLoggingEvent {
    private final LogEvent event;

    public PaxLoggingEventImpl(LogEvent event) {
        this.event = event;
    }

    public PaxLocationInfo getLocationInformation() {
        return new PaxLocationInfoImpl(this.event.getSource());
    }

    public PaxLevel getLevel() {
        return new PaxLevelImpl(this.event.getLevel());
    }

    public String getLoggerName() {
        return this.event.getLoggerName();
    }

    public String getMessage() {
        return this.event.getMessage().getFormattedMessage();
    }

    public String getRenderedMessage() {
        return this.event.getMessage().getFormattedMessage();
    }

    public String getThreadName() {
        return this.event.getThreadName();
    }

    public String[] getThrowableStrRep() {
        ThrowableProxy t = this.event.getThrownProxy();
        return t != null ? t.getExtendedStackTraceAsString("").split("\n") : null;
    }

    public boolean locationInformationExists() {
        return this.event.isIncludeLocation();
    }

    public long getTimeStamp() {
        return this.event.getTimeMillis();
    }

    public String getFQNOfLoggerClass() {
        return this.event.getLoggerFqcn();
    }

    public Map<String, Object> getProperties() {
        return this.event.getContextData() == null ? Collections.emptyMap() : new HashMap(this.event.getContextData().toMap());
    }

    static {
        new PaxLocationInfoImpl(null);
        new PaxLevelImpl(Level.DEBUG);
    }
}

