/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.util.convert.converter;

import java.util.Locale;
import org.apache.wicket.util.convert.IConverter;
import org.apache.wicket.util.convert.converter.AbstractConverter;

public class CharacterConverter
extends AbstractConverter<Character> {
    private static final long serialVersionUID = 1L;
    public static final IConverter<Character> INSTANCE = new CharacterConverter();

    @Override
    public Character convertToObject(String value, Locale locale) {
        int length = value.length();
        if (length == 0) {
            return null;
        }
        if (length == 1) {
            return Character.valueOf(value.charAt(0));
        }
        throw this.newConversionException("Cannot convert '" + value + "' to Character", value, locale);
    }

    @Override
    protected Class<Character> getTargetType() {
        return Character.class;
    }
}

