/*
 * Decompiled with CFR 0.152.
 */
package org.danekja.java.util.function.serializable;

import java.io.Serializable;
import java.util.Objects;
import java.util.function.Predicate;

@FunctionalInterface
public interface SerializablePredicate<T>
extends Predicate<T>,
Serializable {
    @Override
    default public SerializablePredicate<T> and(SerializablePredicate<? super T> other) {
        Objects.requireNonNull(other);
        return t -> this.test(t) && other.test(t);
    }

    @Override
    default public SerializablePredicate<T> negate() {
        return t -> !this.test(t);
    }

    @Override
    default public SerializablePredicate<T> or(SerializablePredicate<? super T> other) {
        Objects.requireNonNull(other);
        return t -> this.test(t) || other.test(t);
    }

    public static <T> SerializablePredicate<T> isEqual(Object targetRef) {
        return null == targetRef ? Objects::isNull : object -> targetRef.equals(object);
    }
}

