/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.csp;

import org.apache.wicket.csp.CSPHeaderConfiguration;
import org.apache.wicket.csp.CSPHeaderMode;
import org.apache.wicket.csp.ContentSecurityPolicySettings;
import org.apache.wicket.request.IRequestHandler;
import org.apache.wicket.request.IRequestHandlerDelegate;
import org.apache.wicket.request.cycle.IRequestCycleListener;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.request.http.WebResponse;

public class CSPRequestCycleListener
implements IRequestCycleListener {
    private final ContentSecurityPolicySettings settings;

    public CSPRequestCycleListener(ContentSecurityPolicySettings settings) {
        this.settings = settings;
    }

    @Override
    public void onRequestHandlerResolved(RequestCycle cycle, IRequestHandler handler) {
        this.protect(cycle, handler);
    }

    @Override
    public void onRequestHandlerExecuted(RequestCycle cycle, IRequestHandler handler) {
        this.protect(cycle, handler);
    }

    protected void protect(RequestCycle cycle, IRequestHandler handler) {
        if (!this.mustProtect(handler) || !(cycle.getResponse() instanceof WebResponse)) {
            return;
        }
        WebResponse webResponse = (WebResponse)cycle.getResponse();
        if (!webResponse.isHeaderSupported()) {
            return;
        }
        this.settings.getConfiguration().entrySet().stream().filter(entry -> ((CSPHeaderConfiguration)entry.getValue()).isSet()).forEach(entry -> {
            CSPHeaderMode mode = (CSPHeaderMode)((Object)((Object)entry.getKey()));
            CSPHeaderConfiguration config = (CSPHeaderConfiguration)entry.getValue();
            String headerValue = config.renderHeaderValue(this.settings, cycle);
            webResponse.setHeader(mode.getHeader(), headerValue);
            if (config.isAddLegacyHeaders()) {
                webResponse.setHeader(mode.getLegacyHeader(), headerValue);
            }
        });
    }

    protected boolean mustProtect(IRequestHandler handler) {
        if (handler instanceof IRequestHandlerDelegate) {
            return this.mustProtect(((IRequestHandlerDelegate)handler).getDelegateHandler());
        }
        return this.settings.mustProtectRequest(handler);
    }
}

