/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.request.mapper.info;

import org.apache.wicket.request.mapper.info.ComponentInfo;
import org.apache.wicket.request.mapper.info.PageInfo;
import org.apache.wicket.util.lang.Args;
import org.apache.wicket.util.string.Strings;

public class PageComponentInfo {
    private static final char SEPARATOR = '-';
    private final PageInfo pageInfo;
    private final ComponentInfo componentInfo;

    public PageComponentInfo(PageInfo pageInfo, ComponentInfo componentInfo) {
        Args.notNull(pageInfo, "pageInfo");
        this.pageInfo = pageInfo;
        this.componentInfo = componentInfo;
    }

    public PageInfo getPageInfo() {
        return this.pageInfo;
    }

    public ComponentInfo getComponentInfo() {
        return this.componentInfo;
    }

    public String toString() {
        Object result = this.pageInfo.toString();
        if (this.componentInfo != null) {
            result = (String)result + "-" + String.valueOf(this.componentInfo);
        }
        return result;
    }

    public static PageComponentInfo parse(String s) {
        ComponentInfo componentInfo;
        PageInfo pageInfo;
        if (Strings.isEmpty(s)) {
            return null;
        }
        int i = s.indexOf(45);
        if (i == -1) {
            pageInfo = PageInfo.parse(s);
            componentInfo = null;
        } else {
            pageInfo = PageInfo.parse(s.substring(0, i));
            componentInfo = ComponentInfo.parse(s.substring(i + 1));
        }
        if (pageInfo == null) {
            return null;
        }
        return new PageComponentInfo(pageInfo, componentInfo);
    }
}

