/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.tserver.session;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.OptionalLong;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.apache.accumulo.core.data.Column;
import org.apache.accumulo.core.dataImpl.KeyExtent;
import org.apache.accumulo.core.dataImpl.thrift.IterInfo;
import org.apache.accumulo.core.securityImpl.thrift.TCredentials;
import org.apache.accumulo.core.spi.common.IteratorConfiguration;
import org.apache.accumulo.core.spi.common.Stats;
import org.apache.accumulo.core.spi.scan.ScanInfo;
import org.apache.accumulo.core.util.Stat;
import org.apache.accumulo.tserver.scan.ScanParameters;
import org.apache.accumulo.tserver.scan.ScanTask;
import org.apache.accumulo.tserver.session.Session;
import org.apache.accumulo.tserver.tablet.TabletBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ScanSession<T>
extends Session
implements ScanInfo {
    private static final Logger log = LoggerFactory.getLogger(ScanSession.class);
    private OptionalLong lastRunTime = OptionalLong.empty();
    private final Stat idleStats = new Stat();
    public final Stat runStats = new Stat();
    public final ScanParameters scanParams;
    private final Map<String, String> executionHints;
    private final TabletResolver tabletResolver;
    private final AtomicReference<ScanTask<T>> scanTaskRef = new AtomicReference();
    private boolean loggedZombieStackTrace = false;

    public static ScanMeasurer wrap(ScanSession<?> scanInfo, Runnable r) {
        return new ScanMeasurer(scanInfo, r);
    }

    ScanSession(TCredentials credentials, ScanParameters scanParams, Map<String, String> executionHints, TabletResolver tabletResolver) {
        super(credentials);
        this.scanParams = scanParams;
        this.executionHints = executionHints == null ? Collections.emptyMap() : Collections.unmodifiableMap(executionHints);
        this.tabletResolver = tabletResolver;
    }

    public long getCreationTime() {
        return this.startTime;
    }

    public OptionalLong getLastRunTime() {
        return this.lastRunTime;
    }

    public Stats getRunTimeStats() {
        return this.runStats;
    }

    public Stats getIdleTimeStats() {
        return this.idleStats;
    }

    public Stats getIdleTimeStats(long currentTime) {
        long idleTime = currentTime - this.getLastRunTime().orElse(this.getCreationTime());
        Preconditions.checkArgument((idleTime >= 0L ? 1 : 0) != 0);
        Stat copy = this.idleStats.copy();
        copy.addStat(idleTime);
        return copy;
    }

    public Set<Column> getFetchedColumns() {
        return Collections.unmodifiableSet(this.scanParams.getColumnSet());
    }

    public Collection<IteratorConfiguration> getClientScanIterators() {
        return this.scanParams.getSsiList().stream().map(x$0 -> new IterConfImpl((IterInfo)x$0)).collect(Collectors.toList());
    }

    public Map<String, String> getExecutionHints() {
        return this.executionHints;
    }

    public void finishedRun(long start, long finish) {
        long idleTime = start - this.getLastRunTime().orElse(this.getCreationTime());
        long runTime = finish - start;
        this.lastRunTime = OptionalLong.of(finish);
        this.idleStats.addStat(idleTime);
        this.runStats.addStat(runTime);
    }

    public TabletResolver getTabletResolver() {
        return this.tabletResolver;
    }

    public ScanTask<T> getScanTask() {
        return this.scanTaskRef.get();
    }

    public void setScanTask(ScanTask<T> scanTask) {
        Objects.requireNonNull(scanTask);
        this.scanTaskRef.getAndUpdate(currScanTask -> {
            Preconditions.checkState((currScanTask == null ? 1 : 0) != 0, (Object)"Unable to set a scan task when one is already set");
            return scanTask;
        });
    }

    public void clearScanTask() {
        this.scanTaskRef.getAndUpdate(currScanTask -> {
            Preconditions.checkState((currScanTask == null || currScanTask.getScanThread() == null || currScanTask.producedResult() ? 1 : 0) != 0, (Object)"Can not clear scan task that is still running and has not produced a result");
            return null;
        });
    }

    public void logZombieStackTrace() {
        ScanTask.ScanThreadStackTrace scanStackTrace;
        Preconditions.checkState((this.getState() == Session.State.REMOVED ? 1 : 0) != 0);
        ScanTask<T> scanTask = this.scanTaskRef.get();
        if (scanTask != null && (scanStackTrace = scanTask.getStackTrace()) != null && !this.loggedZombieStackTrace) {
            long changeTimeMillis = this.elaspedSinceStateChange(TimeUnit.MILLISECONDS);
            Exception exception = new Exception("Fake exception to capture stack trace of zombie scan.  Thread id:" + scanStackTrace.threadId + " thread name:" + scanStackTrace.threadName);
            exception.setStackTrace(scanStackTrace.stackTrace);
            log.warn("Scan session with no client active for {}ms has a zombie scan thread. Scan session info : {} ", new Object[]{changeTimeMillis, this, exception});
            this.loggedZombieStackTrace = true;
        }
    }

    @Override
    public boolean cleanup() {
        this.tabletResolver.close();
        if (!super.cleanup()) {
            return false;
        }
        ScanTask<T> scanTask = this.scanTaskRef.get();
        return scanTask == null || scanTask.getScanThread() == null;
    }

    @Override
    public String toString() {
        return super.toString() + " tableId:" + String.valueOf(this.getTableId());
    }

    public static class ScanMeasurer
    implements Runnable {
        private final ScanSession<?> session;
        private final Runnable task;

        ScanMeasurer(ScanSession<?> session, Runnable task) {
            this.session = session;
            this.task = task;
        }

        @Override
        public void run() {
            long t1 = System.currentTimeMillis();
            this.task.run();
            long t2 = System.currentTimeMillis();
            this.session.finishedRun(t1, t2);
        }

        public ScanInfo getScanInfo() {
            return this.session;
        }
    }

    public static interface TabletResolver {
        public TabletBase getTablet(KeyExtent var1);

        public void close();
    }

    private class IterConfImpl
    implements IteratorConfiguration {
        private final IterInfo ii;

        IterConfImpl(IterInfo ii) {
            this.ii = ii;
        }

        public String getIteratorClass() {
            return this.ii.className;
        }

        public String getName() {
            return this.ii.iterName;
        }

        public int getPriority() {
            return this.ii.priority;
        }

        public Map<String, String> getOptions() {
            Map<String, String> opts = ScanSession.this.scanParams.getSsio().get(this.ii.iterName);
            return opts == null || opts.isEmpty() ? Collections.emptyMap() : Collections.unmodifiableMap(opts);
        }
    }
}

