/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.iteratorsImpl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import org.apache.accumulo.core.classloader.ClassLoaderUtil;
import org.apache.accumulo.core.client.IteratorSetting;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.data.constraints.DefaultKeySizeConstraint;
import org.apache.accumulo.core.dataImpl.thrift.IterInfo;
import org.apache.accumulo.core.iterators.IteratorEnvironment;
import org.apache.accumulo.core.iterators.IteratorUtil;
import org.apache.accumulo.core.iterators.SortedKeyValueIterator;
import org.apache.accumulo.core.iterators.user.VersioningIterator;
import org.apache.accumulo.core.iteratorsImpl.IteratorBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IteratorConfigUtil {
    private static final Logger log = LoggerFactory.getLogger(IteratorConfigUtil.class);
    public static final Comparator<IterInfo> ITER_INFO_COMPARATOR = Comparator.comparingInt(IterInfo::getPriority);

    public static Property getProperty(IteratorUtil.IteratorScope scope) {
        Objects.requireNonNull(scope);
        switch (scope) {
            case scan: {
                return Property.TABLE_ITERATOR_SCAN_PREFIX;
            }
            case minc: {
                return Property.TABLE_ITERATOR_MINC_PREFIX;
            }
            case majc: {
                return Property.TABLE_ITERATOR_MAJC_PREFIX;
            }
        }
        throw new IllegalStateException("Could not find configuration property for IteratorScope");
    }

    public static Map<String, String> generateInitialTableProperties(boolean limitVersion) {
        TreeMap<String, String> props = new TreeMap<String, String>();
        if (limitVersion) {
            for (IteratorUtil.IteratorScope iterScope : IteratorUtil.IteratorScope.values()) {
                props.put(String.valueOf((Object)Property.TABLE_ITERATOR_PREFIX) + iterScope.name() + ".vers", "20," + VersioningIterator.class.getName());
                props.put(String.valueOf((Object)Property.TABLE_ITERATOR_PREFIX) + iterScope.name() + ".vers.opt.maxVersions", "1");
            }
        }
        props.put(String.valueOf((Object)Property.TABLE_CONSTRAINT_PREFIX) + "1", DefaultKeySizeConstraint.class.getName());
        return props;
    }

    public static List<IterInfo> parseIterConf(IteratorUtil.IteratorScope scope, List<IterInfo> iters, Map<String, Map<String, String>> allOptions, AccumuloConfiguration conf) {
        Map<String, String> properties = conf.getAllPropertiesWithPrefix(IteratorConfigUtil.getProperty(scope));
        ArrayList<IterInfo> iterators = new ArrayList<IterInfo>(iters);
        Property scopeProperty = IteratorConfigUtil.getProperty(scope);
        String scopePropertyKey = scopeProperty.getKey();
        for (Map.Entry<String, String> entry : properties.entrySet()) {
            String suffix = entry.getKey().substring(scopePropertyKey.length());
            String[] suffixSplit = suffix.split("\\.", 3);
            if (suffixSplit.length == 1) {
                String[] sa = entry.getValue().split(",");
                int prio = Integer.parseInt(sa[0]);
                String className = sa[1];
                iterators.add(new IterInfo(prio, className, suffixSplit[0]));
                continue;
            }
            if (suffixSplit.length == 3 && suffixSplit[1].equals("opt")) {
                String iterName = suffixSplit[0];
                String optName = suffixSplit[2];
                allOptions.computeIfAbsent(iterName, k -> new HashMap()).put(optName, entry.getValue());
                continue;
            }
            throw new IllegalArgumentException("Invalid iterator format: " + entry.getKey());
        }
        iterators.sort(ITER_INFO_COMPARATOR);
        return iterators;
    }

    public static void mergeIteratorConfig(List<IterInfo> destList, Map<String, Map<String, String>> destOpts, List<IterInfo> tableIters, Map<String, Map<String, String>> tableOpts, List<IterInfo> ssi, Map<String, Map<String, String>> ssio) {
        destList.addAll(tableIters);
        destList.addAll(ssi);
        destList.sort(ITER_INFO_COMPARATOR);
        Set<Map.Entry<String, Map<String, String>>> es = tableOpts.entrySet();
        for (Map.Entry<String, Map<String, String>> entry : es) {
            if (entry.getValue() == null) {
                destOpts.put(entry.getKey(), null);
                continue;
            }
            destOpts.put(entry.getKey(), new HashMap<String, String>(entry.getValue()));
        }
        IteratorConfigUtil.mergeOptions(ssio, destOpts);
    }

    private static void mergeOptions(Map<String, Map<String, String>> ssio, Map<String, Map<String, String>> allOptions) {
        ssio.forEach((k, v) -> {
            if (v != null) {
                Map options = (Map)allOptions.get(k);
                if (options == null) {
                    allOptions.put((String)k, (Map<String, String>)v);
                } else {
                    options.putAll(v);
                }
            }
        });
    }

    public static IteratorBuilder.IteratorBuilderEnv loadIterConf(IteratorUtil.IteratorScope scope, List<IterInfo> iters, Map<String, Map<String, String>> iterOpts, AccumuloConfiguration conf) {
        HashMap<String, Map<String, String>> allOptions = new HashMap<String, Map<String, String>>();
        List<IterInfo> iterators = IteratorConfigUtil.parseIterConf(scope, iters, allOptions, conf);
        IteratorConfigUtil.mergeOptions(iterOpts, allOptions);
        return IteratorBuilder.builder(iterators).opts(allOptions);
    }

    public static SortedKeyValueIterator<Key, Value> convertItersAndLoad(IteratorUtil.IteratorScope scope, SortedKeyValueIterator<Key, Value> source, AccumuloConfiguration conf, List<IteratorSetting> iterators, IteratorEnvironment env) throws IOException, ReflectiveOperationException {
        ArrayList<IterInfo> ssiList = new ArrayList<IterInfo>();
        HashMap<String, Map<String, String>> ssio = new HashMap<String, Map<String, String>>();
        for (IteratorSetting is : iterators) {
            ssiList.add(new IterInfo(is.getPriority(), is.getIteratorClass(), is.getName()));
            ssio.put(is.getName(), is.getOptions());
        }
        IteratorBuilder.IteratorBuilderEnv ibEnv = IteratorConfigUtil.loadIterConf(scope, ssiList, ssio, conf);
        IteratorBuilder iterBuilder = ibEnv.env(env).useClassLoader(ClassLoaderUtil.tableContext(conf)).build();
        return IteratorConfigUtil.loadIterators(source, iterBuilder);
    }

    public static SortedKeyValueIterator<Key, Value> loadIterators(SortedKeyValueIterator<Key, Value> source, IteratorBuilder iteratorBuilder) throws IOException, ReflectiveOperationException {
        SortedKeyValueIterator<Key, Value> prev = source;
        boolean useClassLoader = iteratorBuilder.useAccumuloClassLoader;
        HashMap<String, Class<SortedKeyValueIterator<Key, Value>>> classCache = new HashMap<String, Class<SortedKeyValueIterator<Key, Value>>>();
        for (IterInfo iterInfo : iteratorBuilder.iters) {
            try {
                Class<SortedKeyValueIterator<Key, Value>> clazz = null;
                log.trace("Attempting to load iterator class {}", (Object)iterInfo.className);
                if (iteratorBuilder.useClassCache) {
                    clazz = (Class<SortedKeyValueIterator<Key, Value>>)classCache.get(iterInfo.className);
                    if (clazz == null) {
                        clazz = IteratorConfigUtil.loadClass(useClassLoader, iteratorBuilder.context, iterInfo);
                        classCache.put(iterInfo.className, clazz);
                    }
                } else {
                    clazz = IteratorConfigUtil.loadClass(useClassLoader, iteratorBuilder.context, iterInfo);
                }
                SortedKeyValueIterator<Key, Value> skvi = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                Map<String, String> options = iteratorBuilder.iterOpts.get(iterInfo.iterName);
                if (options == null) {
                    options = Collections.emptyMap();
                }
                skvi.init(prev, options, iteratorBuilder.iteratorEnvironment);
                prev = skvi;
            }
            catch (ReflectiveOperationException e) {
                log.error("Failed to load iterator {}, for table {}, from context {}", new Object[]{iterInfo.className, iteratorBuilder.iteratorEnvironment.getTableId(), iteratorBuilder.context, e});
                throw new RuntimeException(e);
            }
        }
        return prev;
    }

    private static Class<SortedKeyValueIterator<Key, Value>> loadClass(boolean useAccumuloClassLoader, String context, IterInfo iterInfo) throws ClassNotFoundException {
        if (useAccumuloClassLoader) {
            Class<SortedKeyValueIterator<Key, Value>> clazz = ClassLoaderUtil.loadClass(context, iterInfo.className, SortedKeyValueIterator.class);
            log.trace("Iterator class {} loaded from context {}, classloader: {}", new Object[]{iterInfo.className, context, clazz.getClassLoader()});
            return clazz;
        }
        Class<SortedKeyValueIterator<Key, Value>> clazz = Class.forName(iterInfo.className).asSubclass(SortedKeyValueIterator.class);
        log.trace("Iterator class {} loaded from classpath", (Object)iterInfo.className);
        return clazz;
    }
}

