/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.util;

import com.beust.jcommander.Parameter;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.context.Scope;
import java.security.SecureRandom;
import java.util.Iterator;
import java.util.Properties;
import org.apache.accumulo.core.cli.ClientOpts;
import org.apache.accumulo.core.client.Accumulo;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.conf.ClientProperty;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.trace.TraceUtil;
import org.apache.hadoop.io.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RandomWriter {
    private static final int num_columns_per_row = 1;
    private static final int num_payload_bytes = 1024;
    private static final Logger log = LoggerFactory.getLogger(RandomWriter.class);
    private static final SecureRandom random = new SecureRandom();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        Opts opts = new Opts();
        opts.principal = "root";
        opts.parseArgs(RandomWriter.class.getName(), args, new Object[0]);
        Span span = TraceUtil.startSpan(RandomWriter.class, (String)"main");
        try (Scope scope = span.makeCurrent();){
            long start = System.currentTimeMillis();
            Properties clientProps = opts.getClientProps();
            String principal = ClientProperty.AUTH_PRINCIPAL.getValue(clientProps);
            log.info("starting at {} for user {}", (Object)start, (Object)principal);
            try (AccumuloClient accumuloClient = (AccumuloClient)Accumulo.newClient().from(clientProps).build();
                 BatchWriter bw = accumuloClient.createBatchWriter(opts.tableName);){
                log.info("Writing {} mutations...", (Object)opts.count);
                bw.addMutations((Iterable)new RandomMutationGenerator(opts.count));
            }
            catch (Exception e) {
                log.error("{}", (Object)e.getMessage(), (Object)e);
                throw e;
            }
            long stop = System.currentTimeMillis();
            log.info("stopping at {}", (Object)stop);
            log.info("elapsed: {}", (Object)(((double)stop - (double)start) / 1000.0));
        }
        finally {
            span.end();
        }
    }

    static class Opts
    extends ClientOpts {
        @Parameter(names={"--count"}, description="number of mutations to write", required=true)
        long count;
        @Parameter(names={"--table"}, description="table to use")
        String tableName = "test_write_table";

        Opts() {
        }
    }

    public static class RandomMutationGenerator
    implements Iterable<Mutation>,
    Iterator<Mutation> {
        private final long max_mutations;
        private int mutations_so_far = 0;
        private static final Logger log = LoggerFactory.getLogger(RandomMutationGenerator.class);

        public RandomMutationGenerator(long num_mutations) {
            this.max_mutations = num_mutations;
        }

        @Override
        public boolean hasNext() {
            return (long)this.mutations_so_far < this.max_mutations;
        }

        @Override
        public Mutation next() {
            Text row_value = new Text(Long.toString((random.nextLong() & Long.MAX_VALUE) / 177L % 100000000000L));
            Mutation m = new Mutation(row_value);
            for (int column = 0; column < 1; ++column) {
                Text column_fam = new Text("col_fam");
                byte[] bytes = new byte[1024];
                random.nextBytes(bytes);
                m.put(column_fam, new Text("" + column), new Value(bytes));
            }
            ++this.mutations_so_far;
            if (this.mutations_so_far % 1000000 == 0) {
                log.info("Created {} mutations so far", (Object)this.mutations_so_far);
            }
            return m;
        }

        @Override
        public void remove() {
            ++this.mutations_so_far;
        }

        @Override
        public Iterator<Mutation> iterator() {
            return this;
        }
    }
}

